/*
 * Decompiled with CFR 0.152.
 */
package rampancy.standard;

import rampancy.standard.RDefaultSegmentTree;
import rampancy.util.RPoint;
import rampancy.util.RUtil;
import rampancy.util.data.segmentTree.RSTNode;
import rampancy.util.movement.RMovementStatistic;
import rampancy.util.wave.REnemyWave;

public class RDefaultMovementStatistic
implements RMovementStatistic {
    public static final int STANDARD_ROLL_DEPTH = 1;
    private RDefaultSegmentTree segmentTree = new RDefaultSegmentTree();

    public double getDanger(REnemyWave wave, RPoint location) {
        return 0.0;
    }

    public double getSafestGuessFactor(REnemyWave wave) {
        RSTNode leaf = this.segmentTree.getSegmentForState(wave.getTargetState());
        double[] guessFactors = leaf.getGuessFactors();
        int lowestIndex = RUtil.indexOfSmallest(guessFactors);
        int offset = lowestIndex - guessFactors.length / 2;
        double factor = (double)offset / (double)((guessFactors.length - 1) / 2);
        return factor;
    }

    public double[] getGuessFactorArray(REnemyWave wave) {
        return this.segmentTree.getSegmentForState(wave.getTargetState()).getGuessFactors();
    }

    public void noteHitByBullet(REnemyWave wave, RPoint hitLocation) {
        double factorRaw = wave.computeRawFactor(hitLocation);
        int guessFactorIndex = (int)RUtil.limit(0.0, factorRaw * 30.0 + 30.0, 60.0);
        RSTNode leaf = this.segmentTree.getSegmentForState(wave.getTargetState());
        RSTNode.updateGuessFactors(leaf, guessFactorIndex, 1.0, 1);
    }
}

