/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.bullet;

import dmh.robocode.bullet.SimulatedBullet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimulatedBulletList {
    private List<SimulatedBullet> bullets = new ArrayList<SimulatedBullet>();
    private int hits = 0;
    private int misses = 0;
    private int defaultHits = 0;
    private int defaultMisses = 0;

    public int getInProgressCount() {
        return this.bullets.size();
    }

    public double getSuccessRate() {
        int h = this.hits;
        int m = this.misses;
        if (h + m < 20) {
            h += this.defaultHits;
            m += this.defaultMisses;
        }
        if (h + m > 0) {
            return (double)h / (double)(h + m) * 100.0;
        }
        return 0.0;
    }

    public int getTotalHits() {
        return this.hits;
    }

    public int getTotalMisses() {
        return this.misses;
    }

    public void add(SimulatedBullet bullet) {
        this.bullets.add(bullet);
    }

    public void processCurrentTime(long time) {
        Iterator<SimulatedBullet> bulletIterator = this.bullets.iterator();
        while (bulletIterator.hasNext()) {
            SimulatedBullet bullet = bulletIterator.next();
            bullet.processAtTime(time);
            switch (bullet.getResult()) {
                case HIT: {
                    ++this.hits;
                    bulletIterator.remove();
                    break;
                }
                case MISS: {
                    ++this.misses;
                    bulletIterator.remove();
                    break;
                }
                case DEAD: {
                    bulletIterator.remove();
                    break;
                }
            }
        }
    }

    public void processEndOfRound() {
        this.bullets.clear();
    }

    public void setDefaultSuccessStats(int defaultHits, int defaultMisses) {
        this.defaultHits = defaultHits;
        this.defaultMisses = defaultMisses;
    }
}

