/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.gunner.aiming;

import dmh.robocode.bullet.SimulatedBullet;
import dmh.robocode.bullet.SimulatedBulletList;
import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.gunner.aiming.AimingStrategy;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.Geometry;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public abstract class CalibratedAimingStrategy
implements AimingStrategy {
    private CommandBasedRobot myRobot;
    private EnemyRobot enemy;
    private int segmentCount;
    private Map<String, SimulatedBulletList[]> allBulletSegments;
    private boolean isLearningAllowed;
    private Color color;
    private Map<String, Integer> categoryDefaultHits;
    private Map<String, Integer> categoryDefaultMisses;

    public CalibratedAimingStrategy(CommandBasedRobot myRobot, EnemyRobot enemy, boolean isLearningAllowed, Color color) {
        this.myRobot = myRobot;
        this.enemy = enemy;
        this.color = color;
        this.allBulletSegments = new HashMap<String, SimulatedBulletList[]>();
        this.categoryDefaultHits = new HashMap<String, Integer>();
        this.categoryDefaultMisses = new HashMap<String, Integer>();
        this.isLearningAllowed = isLearningAllowed;
        this.segmentCount = isLearningAllowed ? 8 : 1;
    }

    private SimulatedBulletList[] getSegments(String category) {
        SimulatedBulletList[] segments = this.allBulletSegments.get(category);
        if (segments == null) {
            segments = this.getNewSegments();
            this.allBulletSegments.put(category, segments);
        }
        return segments;
    }

    private void setCategoryDefaultSuccessRating(String category, int defaultHits, int defaultMisses) {
        for (SimulatedBulletList bulletList : this.getSegments(category)) {
            bulletList.setDefaultSuccessStats(defaultHits, defaultMisses);
        }
        this.categoryDefaultHits.put(category, defaultHits);
        this.categoryDefaultMisses.put(category, defaultMisses);
    }

    private SimulatedBulletList[] getNewSegments() {
        SimulatedBulletList[] newSegments = new SimulatedBulletList[this.segmentCount];
        for (int s = 0; s < newSegments.length; ++s) {
            newSegments[s] = new SimulatedBulletList();
        }
        return newSegments;
    }

    @Override
    public final void simulateShot(String category, double bulletSpeed) {
        Location target;
        if (this.isLearningAllowed && (target = this.getTargetForShot(bulletSpeed)) != null) {
            double targetBearing = Geometry.getBearingBetweenLocations(this.myRobot.getLocation(), target);
            double estimatedSuccess = this.getEstimatedSuccessOfShotUsingRules(bulletSpeed);
            int segmentNumber = this.getSegmentNumber(estimatedSuccess);
            SimulatedBullet bullet = new SimulatedBullet(this.enemy, this.myRobot.getLocation(), this.myRobot.getTime(), targetBearing, bulletSpeed);
            this.getSegments(category)[segmentNumber].add(bullet);
        }
    }

    @Override
    public void notifyShotJustFired() {
    }

    @Override
    public double getEstimatedSuccessOfShot(String category, double bulletSpeed) {
        double estimatedSuccess = this.getEstimatedSuccessOfShotUsingRules(bulletSpeed);
        if (estimatedSuccess == 0.0) {
            return 0.0;
        }
        if (this.isLearningAllowed) {
            int segmentNumber = this.getSegmentNumber(estimatedSuccess);
            double simulatedSuccess = this.getSegments(category)[segmentNumber].getSuccessRate();
            double segmentMidpoint = this.getSegmentMidpoint(segmentNumber);
            double adjustment = simulatedSuccess - segmentMidpoint;
            return Math.max(0.1, estimatedSuccess + adjustment);
        }
        return Math.max(0.1, estimatedSuccess - Math.random());
    }

    protected double getDefaultEstimatedSuccess(double bulletSpeed) {
        Location enemyLocation = this.getEnemy().getLatestRadarObservation().getLocation();
        if (enemyLocation == null) {
            return 0.0;
        }
        double distance = Geometry.getDistanceBetweenLocations(this.getMyRobot().getLocation(), enemyLocation);
        return Math.max(0.0, 100.0 - distance / bulletSpeed);
    }

    public abstract double getEstimatedSuccessOfShotUsingRules(double var1);

    @Override
    public abstract Location getTargetForShot(double var1);

    @Override
    public final Color getDebugColour() {
        return this.color;
    }

    @Override
    public final void processTurn() {
        for (SimulatedBulletList[] segments : this.allBulletSegments.values()) {
            for (SimulatedBulletList segment : segments) {
                segment.processCurrentTime(this.myRobot.getTime());
            }
        }
    }

    @Override
    public final void processEndOfRound(CommandBasedRobot myRobotInNextRound) {
        for (SimulatedBulletList[] segments : this.allBulletSegments.values()) {
            for (SimulatedBulletList segment : segments) {
                segment.processEndOfRound();
            }
        }
        this.myRobot = myRobotInNextRound;
    }

    @Override
    public void debugDisplayStats() {
        for (Map.Entry<String, SimulatedBulletList[]> categoryEntry : this.allBulletSegments.entrySet()) {
            int hits = 0;
            int misses = 0;
            StringBuffer segmentDetails = new StringBuffer();
            for (SimulatedBulletList segment : categoryEntry.getValue()) {
                hits += segment.getTotalHits();
                misses += segment.getTotalMisses();
                segmentDetails.append(segment.getTotalHits() + "/" + (segment.getTotalHits() + segment.getTotalMisses()) + "  ");
            }
            if (hits + misses <= 0) continue;
            int successRating = hits * 100 / (hits + misses);
            System.out.println("    " + categoryEntry.getKey() + "    " + this.getFullName() + "    " + successRating + "% [ " + hits + "/" + (hits + misses) + " ]  " + segmentDetails);
        }
    }

    @Override
    public final String getFullName() {
        String parameters = this.getParametersAsString();
        if (parameters == null || parameters.isEmpty()) {
            return this.getClass().getSimpleName();
        }
        return this.getClass().getSimpleName() + "(" + this.getParametersAsString() + ")";
    }

    protected String getParametersAsString() {
        return null;
    }

    private int getSegmentNumber(double estimatedSuccess) {
        return (int)Math.min((double)(this.segmentCount - 1), Math.floor(estimatedSuccess / 100.0 * (double)this.segmentCount));
    }

    private double getSegmentMidpoint(int segment) {
        return ((double)segment + 0.5) * 100.0 / (double)this.segmentCount;
    }

    protected EnemyRobot getEnemy() {
        return this.enemy;
    }

    protected CommandBasedRobot getMyRobot() {
        return this.myRobot;
    }

    @Override
    public boolean isUnfinishedPattern() {
        return false;
    }

    @Override
    public String getUniqueShortId() {
        return this.getClass().getSimpleName().replaceAll("[^A-Z]", "");
    }

    @Override
    public String getStatsAsString() {
        StringBuffer result = new StringBuffer();
        for (Map.Entry<String, SimulatedBulletList[]> categoryEntry : this.allBulletSegments.entrySet()) {
            int hits = 0;
            int misses = 0;
            for (SimulatedBulletList segment : categoryEntry.getValue()) {
                hits += segment.getTotalHits();
                misses += segment.getTotalMisses();
            }
            Integer defaultHits = this.categoryDefaultHits.get(categoryEntry.getKey());
            Integer defaultMisses = this.categoryDefaultMisses.get(categoryEntry.getKey());
            if (defaultHits != null) {
                hits += defaultHits.intValue();
            }
            if (defaultMisses != null) {
                misses += defaultMisses.intValue();
            }
            if (hits + misses < 0) continue;
            result.append("\t");
            result.append(categoryEntry.getKey());
            result.append("\t");
            result.append(hits);
            result.append("\t");
            result.append(misses);
        }
        return result.toString();
    }

    @Override
    public void processStatsAsString(String stats) {
        String[] splits = stats.split("\t");
        for (int pos = 0; pos < splits.length - 2; pos += 3) {
            this.setCategoryDefaultSuccessRating(splits[pos], Integer.parseInt(splits[pos + 1]), Integer.parseInt(splits[pos + 2]));
        }
    }
}

