/*
 * Decompiled with CFR 0.152.
 */
package eem.frame.dangermap;

import eem.frame.bot.fighterBot;
import eem.frame.dangermap.dangerCalc;
import eem.frame.misc.graphics;
import eem.frame.misc.logger;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class dangerPoint
implements Comparable<dangerPoint> {
    public Point2D.Double position;
    public double dangerLevel;

    public dangerPoint() {
        this.position = new Point2D.Double(0.0, 0.0);
        this.dangerLevel = 0.0;
    }

    public dangerPoint(Point2D.Double double_, double d) {
        this.position = (Point2D.Double)double_.clone();
        this.dangerLevel = d;
    }

    public double getDanger() {
        return this.dangerLevel;
    }

    public void setDanger(double d) {
        this.dangerLevel = d;
    }

    public double calculateDanger(long l, fighterBot fighterBot2) {
        double d = 0.0;
        d += dangerCalc.calculateDangerFromWall(l, this.position, fighterBot2);
        d += dangerCalc.calculateDangerFromEnemyBots(l, this.position, fighterBot2);
        this.setDanger(d += dangerCalc.calculateDangerFromEnemyWaves(l, this.position, fighterBot2));
        return d;
    }

    public Point2D.Double getPosition() {
        return this.position;
    }

    public void setPosition(Point2D.Double double_) {
        this.position = (Point2D.Double)double_.clone();
    }

    public int compare(dangerPoint dangerPoint2, dangerPoint dangerPoint3) {
        double d = dangerPoint2.dangerLevel;
        double d2 = dangerPoint3.dangerLevel;
        if (d == d2) {
            return 0;
        }
        if (d > d2) {
            return 1;
        }
        return -1;
    }

    @Override
    public int compareTo(dangerPoint dangerPoint2) {
        return this.compare(this, dangerPoint2);
    }

    public void print() {
        logger.dbg("Point [" + this.position.x + ", " + this.position.y + "]" + " has danger level = " + this.dangerLevel);
    }

    public void onPaint(Graphics2D graphics2D) {
        Point2D.Double double_ = this.position;
        double d = this.dangerLevel;
        graphics2D.setColor(graphics.dangerLevel2mapColor(d));
        double d2 = 5.0;
        graphics.drawCircle(graphics2D, double_, d2);
        graphics2D.setColor(new Color(0, 0, 170, 255));
        double d3 = 2.0;
        graphics.drawCircle(graphics2D, double_, d3);
    }
}

