/*
 * Decompiled with CFR 0.152.
 */
package origin;

import java.awt.geom.Point2D;
import java.util.concurrent.ConcurrentHashMap;
import origin.Enemy;
import origin.SleepSiphon;
import origin.Util;
import robocode.util.Utils;

public class Radar {
    private static Enemy oldestScanned = null;
    private static long oldestScannedAge = -1L;
    private static double turnAmountRemaining = 0.0;
    private static long timeToScanAll = 1L;

    public static void infinityLock(Enemy target, SleepSiphon self) {
        if (self.getRadarTurnRemaining() == 0.0) {
            self.setTurnRadarRight(Double.POSITIVE_INFINITY);
        }
    }

    public static void spinToCenter(SleepSiphon self) {
        if (self.getRadarTurnRemaining() == 0.0) {
            Point2D.Double center = Util.getFieldCenter();
            double spinDirection = Math.signum(Utils.normalRelativeAngle((double)(Math.atan2(center.getX() - self.getX(), center.getY() - self.getY()) - self.getRadarHeadingRadians())));
            self.setTurnRadarRight(Double.POSITIVE_INFINITY * spinDirection);
        }
    }

    public static void factorLock(Enemy target, SleepSiphon self) {
        double FACTOR = 36.0 / Point2D.distance(target.getX(), target.getY(), self.getX(), self.getY()) * 8.0 * Math.PI;
        if (target != null) {
            double absBearing = target.getBearing() + self.getHeadingRadians();
            self.setTurnRadarRightRadians(FACTOR * Utils.normalRelativeAngle((double)(absBearing - self.getRadarHeadingRadians())));
        }
    }

    public static void oldestScanned(ConcurrentHashMap<String, Enemy> enemies, SleepSiphon self) {
        long currentTime = self.getTime();
        String nOldestScannedName = Util.getOldestName(enemies, self);
        Enemy nOldestScanned = enemies.get(nOldestScannedName);
        turnAmountRemaining -= 0.7853981633974483;
        if (nOldestScanned != null && (nOldestScanned != oldestScanned || oldestScannedAge != nOldestScanned.getLatest().getAge(self.getTime()))) {
            oldestScanned = nOldestScanned;
            oldestScannedAge = nOldestScanned.getLatest().getAge(currentTime);
        }
        if (oldestScanned != null && oldestScanned.timeSinceUpdate(currentTime) > 5L) {
            Radar.spinToCenter(self);
        } else if (oldestScanned != null) {
            double relX = oldestScanned.getX() - self.getX();
            double relY = oldestScanned.getY() - self.getY();
            double absBearing = Math.atan2(relX, relY);
            double radarTurnToTarget = Utils.normalRelativeAngle((double)(absBearing - self.getRadarHeadingRadians()));
            long timeSinceOldestScan = oldestScanned.getPreviousData().getAge(currentTime);
            double mea = Radar.calcSimpleMEA((Point2D)self.getPosition(), (Point2D)oldestScanned.getPosition(), 8.0, (int)Math.signum(radarTurnToTarget), timeSinceOldestScan);
            double turnAngle = Utils.normalRelativeAngle((double)(mea - self.getRadarHeadingRadians()));
            turnAmountRemaining = Math.abs(turnAngle);
            self.setTurnRadarRightRadians(turnAngle);
        }
    }

    public static double calcSimpleMEA(Point2D reference, Point2D target, double velocity, double heading, long time) {
        double relX = target.getX() - reference.getX();
        double relY = target.getY() - reference.getY();
        double bearing = Math.atan2(relX, relY);
        double perpendicular = bearing + 1.5707963267948966;
        double headingOffsetFromBearing = heading - bearing;
        double lateralDirection = Math.signum(Radar.normalizeAngle(headingOffsetFromBearing));
        double maxEscapeDistance = velocity * lateralDirection * (double)time;
        double maxRelEscapeX = maxEscapeDistance * Math.sin(perpendicular) + relX;
        double maxRelEscapeY = maxEscapeDistance * Math.cos(perpendicular) + relY;
        double maxEscapeAngle = Math.atan2(maxRelEscapeX, maxRelEscapeY);
        return maxEscapeAngle;
    }

    public static double calcSimpleMEA(Point2D reference, Point2D target, double velocity, int angularDirectionSignnum, long time) {
        double relX = target.getX() - reference.getX();
        double relY = target.getY() - reference.getY();
        double bearing = Math.atan2(relX, relY);
        double perpendicular = bearing + 1.5707963267948966;
        double maxEscapeDistance = velocity * (double)angularDirectionSignnum * (double)time;
        double maxRelEscapeX = maxEscapeDistance * Math.sin(perpendicular) + relX;
        double maxRelEscapeY = maxEscapeDistance * Math.cos(perpendicular) + relY;
        double maxEscapeAngle = Math.atan2(maxRelEscapeX, maxRelEscapeY);
        return maxEscapeAngle;
    }

    public static double normalizeAngle(double angle) {
        double pi = Math.PI;
        while (angle > pi) {
            angle -= pi;
        }
        while (angle <= -pi) {
            angle += pi;
        }
        return angle;
    }
}

