/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.morfeas;

import gre.svman4.useful.Buffer;
import gre.svman4.useful.RobotState;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class EnemyState
extends RobotState
implements Serializable {
    private static final int MAX_DISTANCE_WAVE_SURFING_CHECK = 1200;
    private static final int MAX_DISTANCE_GUN_TARGETING = 900;
    public static final int BINS = 43;
    public static final int WAVE_BINS = 47;
    public static final int WAVE_DIFF_ANGLE_INDEXES = 5;
    public static final int WAVE_DISTANCE_INDEXES = 10;
    public static final int WAVE_VELOCITY_INDEXES = 10;
    private static final double[][][] gunBuffers = new double[10][10][43];
    private static final long serialVersionUID = 5185811350477189479L;
    public static final int WAVE_BEARING_BINS = 5;
    public static final double[][][] waveStats = new double[10][10][47];
    public int[] hits;
    public boolean isAlive = true;
    public double lastVelocity;
    public int lateralDirection;
    public Buffer surfAbsBearing = new Buffer(2);
    public Buffer surfDirections = new Buffer(2);
    private int RollingAverageReadsCounter = 0;
    private int RollingAverageGunReadsCounter = 0;
    public static final int NUMBER_OF_ENTRIES_ON_ROLLING_AVERAGES_FOR_GUN = 25;
    private static final double ROLLING_AVERAGE_MAX_READS_FOR_MOVE = 50.0;

    public EnemyState(int numberOfGuns) {
        this.hits = new int[numberOfGuns];
    }

    public double[] getEnemyGunCurrentStatus(double mineVelocity, double angle, double distance) {
        int indexVelocity = (int)Math.min(Math.abs(mineVelocity) / 0.0, 9.0);
        int indexDistance = (int)Math.min(Math.abs(distance) / 120.0, 10.0);
        return this.getEnemyGunCurrentStatus(indexVelocity, indexDistance);
    }

    private double[] getEnemyGunCurrentStatus(int indexVelocity, int indexDistance) {
        return waveStats[indexDistance][indexVelocity];
    }

    public double[] getGunCurrentStatus(double distance, double velocity, double lastVelocity) {
        int distanceIndex = (int)(distance / 90.0);
        if (distanceIndex >= 10) {
            distanceIndex = 9;
        }
        int velocityIndex = (int)Math.abs(velocity / 2.0);
        int lastVelocityIndex = (int)Math.abs(lastVelocity / 2.0);
        double[] answer = null;
        try {
            answer = gunBuffers[distanceIndex][velocityIndex];
        }
        catch (Exception exp) {
            System.out.println("distanceIndex=" + distanceIndex);
            System.out.println("velocityIndex=" + velocityIndex);
            System.out.println("lastVelocityIndex=" + lastVelocityIndex);
        }
        return answer;
    }

    public void logGunHit(double distance, double velocity, double lastVelocity, int offsetIndex) {
        int distanceIndex = (int)(distance / 90.0);
        if (distanceIndex >= 10) {
            distanceIndex = 9;
        }
        int velocityIndex = (int)Math.abs(velocity / 8.0 / 10.0);
        for (int j = 0; j < 10; ++j) {
            for (int i = 0; i < 10; ++i) {
                for (int xLoop = 0; xLoop < 43; ++xLoop) {
                    EnemyState.gunBuffers[j][i][xLoop] = EnemyState.rollingAvg(gunBuffers[j][i][xLoop], 1.0 / (Math.pow(distanceIndex - j, 2.0) + Math.pow(offsetIndex - xLoop, 2.0) + Math.pow(velocityIndex - i, 2.0) + 1.0), Math.min(this.RollingAverageGunReadsCounter++, 25), 1.0);
                }
            }
        }
    }

    public static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public void logHit(double mineRobotVelocity, double distanceToEnemyPosition, int indexAngle) {
        int indexVelocity = (int)Math.min(Math.abs(mineRobotVelocity) / 0.0, 9.0);
        int indexDistance = (int)Math.min(Math.abs(distanceToEnemyPosition) / 120.0, 9.0);
        for (int t = 0; t < 10; ++t) {
            for (int yLoop = 0; yLoop < 10; ++yLoop) {
                for (int xLoop = 0; xLoop < 47; ++xLoop) {
                    EnemyState.waveStats[t][yLoop][xLoop] = EnemyState.rollingAvg(waveStats[t][yLoop][xLoop], 1.0 / (Math.pow(indexAngle - xLoop, 2.0) + Math.pow(indexVelocity - yLoop, 2.0) + Math.pow(indexDistance - t, 2.0) + 1.0), Math.min((double)this.RollingAverageReadsCounter++, 50.0), 1.0);
                }
            }
        }
    }

    public void onPaint(Graphics2D g) {
        if (this.isAlive) {
            g.draw(new Rectangle2D.Double(this.x - 18.0, this.y - 18.0, 36.0, 36.0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

