/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.useful;

import gre.svman4.useful.FieldPoint;

public class MotionState
extends FieldPoint {
    private static final long serialVersionUID = -6910411238440391069L;
    public double heading;
    public double velocity;

    public double getLateralVelocity(MotionState target) {
        double enemyLateralVelocity = target.velocity * Math.sin(this.getAngleTo(target) - target.heading);
        return enemyLateralVelocity;
    }

    public double getAdvancingVelocity(MotionState target) {
        double advancingVelocity = -Math.cos(this.getAngleTo(target) - target.heading) * target.velocity;
        return advancingVelocity;
    }

    public double getMaxEscapeAngle(double velocity) {
        double temp = Math.asin(8.0 / velocity);
        return temp;
    }

    public int getLateralDirection(MotionState target) {
        return this.getLateralVelocity(target) >= 0.0 ? 1 : -1;
    }

    public MotionState() {
    }

    public MotionState(MotionState motionState) {
        super(motionState.x, motionState.y);
        this.heading = motionState.heading;
        this.velocity = motionState.velocity;
    }

    public MotionState(double x, double y) {
        super(x, y);
    }
}

