/*
 * Decompiled with CFR 0.152.
 */
package rjw.radar;

import rjw.Props;
import rjw.RabidWombat;
import rjw.radar.EnemyScan;
import rjw.radar.EnemyWave;
import robocode.Rules;

public class Enemy {
    private final int MAX_LOG_SIZE;
    private EnemyScan[] _scans;
    private int _next = 0;
    private int _size = 0;

    public Enemy(EnemyScan enemy) {
        Props p = RabidWombat.getProps();
        this.MAX_LOG_SIZE = p.getInt("memory.maxLogSize", 500);
        this._scans = new EnemyScan[this.MAX_LOG_SIZE];
        this.addScan(enemy);
    }

    public void addScan(EnemyScan enemy) {
        if (this._size != this.MAX_LOG_SIZE) {
            ++this._size;
        }
        this._scans[this._next] = enemy;
        this._next = (this._next + 1) % this.MAX_LOG_SIZE;
    }

    public void notifyHitMe(double power) {
        this.get(0).addDamage(-Rules.getBulletHitBonus((double)power));
    }

    public void notifyBulletHit(double power) {
        this.get(0).addDamage(Rules.getBulletDamage((double)power));
    }

    public void notifyRobotCollision() {
        this.get(0).recordEnemyCollision();
    }

    public EnemyScan get(int index) {
        int i = this._next - index - 1;
        if (i < 0) {
            i += this.MAX_LOG_SIZE;
        }
        return this._scans[i];
    }

    public int size() {
        return this._size;
    }

    public EnemyWave fireCheck(RabidWombat bot) {
        if (this._size < 2) {
            return null;
        }
        EnemyScan enemy = this.get(0);
        EnemyScan enemy0 = this.get(1);
        if (enemy.getTick() - enemy0.getTick() != 1L) {
            return null;
        }
        double de = enemy.getEnergy() - enemy0.getEnergy();
        double v0 = enemy0.v().d;
        double dv = Math.abs(enemy.v().d - v0);
        if (dv > 2.0 && !enemy.getCollidedWithEnemy()) {
            de += Rules.getWallHitDamage((double)v0);
        }
        if ((de += enemy.getDamage()) <= -0.1 && de >= -3.0) {
            return new EnemyWave(enemy0, -de, bot);
        }
        return null;
    }

    public String getName() {
        return this.get(0).getName();
    }
}

