/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.gun;

import florent.XSeries.gun.GunStrategy;
import florent.XSeries.radar.Enemy;
import florent.XSeries.utils.RobocodeTools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class LinearGun
extends GunStrategy {
    private AdvancedRobot me;
    private Line2D.Double lineOfFire;
    private Line2D.Double lineOfMovement;

    public LinearGun(AdvancedRobot me) {
        this.me = me;
    }

    public void onMainLoop() {
        Enemy target = this.selector.getTarget();
        if (target == null) {
            return;
        }
        double firePower = this.power.getPower(target);
        if (firePower + 1.0 > this.me.getEnergy()) {
            return;
        }
        if (this.me.getGunTurnRemainingRadians() == 0.0) {
            this.me.setFireBullet(firePower);
        }
        Point2D.Double myLocation = new Point2D.Double(this.me.getX(), this.me.getY());
        Point2D.Double targetLocation = new Point2D.Double(target.location.x, target.location.y);
        if (target.energy != 0.0 || target.velocity != 0.0) {
            targetLocation = RobocodeTools.projectMotion(targetLocation, target.heading, target.timeSinceScan * target.velocity);
            double bulletVelocity = RobocodeTools.bulletVelocity(firePower);
            int travelTime = 0;
            double velocity = target.velocity;
            double delay = (double)this.me.getTime() - target.lastScan;
            int i = 0;
            while ((double)i < delay) {
                targetLocation = RobocodeTools.projectMotion(targetLocation, target.heading, velocity);
                velocity = Math.min(Math.abs(velocity) + 2.0, 8.0) * (double)RobocodeTools.sign(velocity);
                ++i;
            }
            while (targetLocation.distance(myLocation) <= bulletVelocity * (double)travelTime) {
                targetLocation = RobocodeTools.projectMotion(targetLocation, target.heading, velocity);
                velocity = Math.min(Math.abs(velocity) + 2.0, 8.0) * (double)RobocodeTools.sign(velocity);
                ++travelTime;
            }
        }
        double enemyAbsoluteBearing = RobocodeTools.absoluteBearing(new Point2D.Double(this.me.getX(), this.me.getY()), targetLocation);
        this.lineOfFire = new Line2D.Double(new Point2D.Double(targetLocation.x, this.me.getBattleFieldHeight() - targetLocation.y), new Point2D.Double(this.me.getX(), this.me.getBattleFieldHeight() - this.me.getY()));
        this.lineOfMovement = new Line2D.Double(new Point2D.Double(targetLocation.x, this.me.getBattleFieldHeight() - targetLocation.y), new Point2D.Double(target.location.x, this.me.getBattleFieldHeight() - target.location.y));
        this.me.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.me.getGunHeadingRadians())));
    }

    public void onPaint(Graphics2D e) {
        e.setColor(Color.MAGENTA);
        e.draw(this.lineOfFire);
        e.setColor(Color.GREEN);
        e.draw(this.lineOfMovement);
        this.selector.onPaint(e);
    }
}

