/*
 * Decompiled with CFR 0.152.
 */
package ultra.core;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdg.tools.BotTrigo;
import robocode.ScannedRobotEvent;
import ultra.core.BotDump;
import ultra.core.LogEntry;

public class UltraLogManager {
    private final Map<String, List<LogEntry>> logs = new HashMap<String, List<LogEntry>>();
    private String target;

    public LogEntry log(BotDump r, ScannedRobotEvent e) {
        this.target = e.getName();
        Point2D p = BotTrigo.getPosition(r, r.getHeading() + e.getBearing(), e.getDistance());
        LogEntry logEntry = new LogEntry(this.target, p, r.getTime(), e.getHeading(), e.getVelocity(), e.getEnergy());
        List<LogEntry> log = this.logs.get(this.target);
        if (log == null) {
            log = new ArrayList<LogEntry>();
            this.logs.put(this.target, log);
        }
        log.add(logEntry);
        return logEntry;
    }

    public LogEntry getLatest() {
        return this.reverseGet(0);
    }

    public int size() {
        return this.logs.get(this.target).size();
    }

    public LogEntry reverseGet(int i) {
        int size;
        List<LogEntry> entries = this.logs.get(this.target);
        if (entries != null && i < (size = entries.size())) {
            return entries.get(size - 1 - i);
        }
        return null;
    }

    public LogEntry get(int i) {
        List<LogEntry> entries = this.logs.get(this.target);
        int size = entries.size();
        if (i < size) {
            return entries.get(i);
        }
        return null;
    }
}

