/*
 * Decompiled with CFR 0.152.
 */
package css;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Delitioner
extends AdvancedRobot {
    protected static final double R_WIDTH = 36.0;
    protected static final double R_HEIGHT = 36.0;
    protected static long _tick;
    protected double _power;
    protected boolean _sweep;
    protected static Rectangle2D.Double _fieldRectSafe;
    protected static Rectangle2D.Double _fieldRect;
    protected ArrayList<Enemy> _enemies;
    protected ArrayList<Enemy> _sweepRecord;
    protected ArrayList<Wave> _waves;
    protected Enemy _me;
    protected Enemy _target;
    protected Point2D.Double _myDst;
    public int _timeSinceDirChangeCounter;
    public int _randomDirChangeAmount;

    public void run() {
        this.setColors(new Color(1, 1, 1), new Color(200, 0, 0), new Color(60, 45, 5));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this._me = new Enemy(this.getName());
        this._waves = new ArrayList();
        this._sweepRecord = new ArrayList(this.getOthers());
        this._enemies = new ArrayList(this.getOthers());
        this._myDst = new Point2D.Double();
        _fieldRectSafe = new Rectangle2D.Double(40.0, 40.0, this.getBattleFieldWidth() - 80.0, this.getBattleFieldHeight() - 80.0);
        _fieldRect = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        while (true) {
            this.radar();
            this.moveSurf();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double fire;
        this.updateMe();
        Enemy enemy = this.addEnemy(e);
        if (enemy.rating() < 0.3 * this._target.rating()) {
            this._target = enemy;
        }
        if (!this._sweepRecord.contains(enemy)) {
            this._sweepRecord.add(enemy);
        }
        this._power = this.firePower();
        this._waves.add(new Wave(this._me, enemy, this._power));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this._target.bestFactor(this._me, this._power) - this.getGunHeadingRadians())));
        if (this._power > 0.0 && this.getGunHeat() == 0.0 && this.getGunTurnRemaining() < 5.0) {
            this.setFire(this._power);
        }
        if ((fire = enemy.energyDrop()) <= 3.0 && fire >= 0.1) {
            this._waves.add(new Wave(enemy, this._me, fire));
        }
        this.projectWaves();
    }

    protected void radar() {
        this.updateMe();
        if (!(this._target != null && this._target.alive() && !(this.avgAge() > 14.0 / Math.sqrt(this.getOthers())) || this._sweep)) {
            double maxDelta = 0.0;
            this._sweepRecord.clear();
            for (Enemy e : this._enemies) {
                double d;
                if (!e.alive()) continue;
                if (e.age() < 2L) {
                    this._sweepRecord.add(e);
                    continue;
                }
                double tmp = Utils.normalRelativeAngle((double)(Delitioner.absBearing(this._me, e) - Delitioner.absBearing(this._me, this._target)));
                if (!(Math.abs(maxDelta) < Math.abs(d))) continue;
                maxDelta = tmp;
            }
            this.setTurnRadarRight(maxDelta < 0.0 ? -360 : 360);
            this._sweep = true;
        }
        if (this._sweep) {
            boolean bl = this._sweep = this.getRadarTurnRemaining() != 0.0 && this._sweepRecord.size() < this.getOthers();
        }
        if (!this._sweep) {
            double head;
            double tar = Delitioner.absBearing(this._me, this._target);
            this.setTurnRadarLeftRadians(Utils.normalRelativeAngle((double)(head - (tar += Utils.normalRelativeAngle((double)((head = this.getRadarHeadingRadians()) - tar)) < 0.0 ? 0.3490658503988659 : -0.3490658503988659))));
        }
    }

    protected double firePower() {
        if (this._target == null || this._target.age() > 5L) {
            return -1.0;
        }
        double center = this.getGunHeadingRadians();
        int inView = 0;
        for (Enemy e : this._enemies) {
            if (!e.alive() || !(Math.abs(center - Utils.normalAbsoluteAngle((double)Delitioner.absBearing(this._me, e))) < 0.3)) continue;
            ++inView;
        }
        double max = 3.0;
        double min = max / 4.0;
        double power = min + Delitioner.limit(0.0, (900.0 - this._target.distance(this._me)) / 840.0 * Math.sqrt((double)inView + 0.2), 1.0) * (max - min);
        this.setBulletColor(new Color(235, 235, 235 - (int)((power /= Math.sqrt(this._target.age() + 1L) * (this._me.energy > 15.0 ? 1.0 : Delitioner.limit(1.0, 15.0 / this._me.energy, 15.0))) * 70.0)));
        return Delitioner.limit(-1.0, Delitioner.limit(0.0, power, this._target.energy * 16.0 / power + 0.01), this._me.energy - 0.1);
    }

    protected void moveTo(Point2D.Double target) {
        double angle = Utils.normalRelativeAngle((double)(Delitioner.absBearing(this._me, target) - this._me.heading));
        double turnAngle = Math.atan(Math.tan(angle));
        double length = target.distance(this._me);
        this.setMaxVelocity(Delitioner.closestWall(this._me) < 100.0 && Delitioner.wallApproachRate(this._me) > 0.1 ? Delitioner.mix(0.0, 8.0, Delitioner.limit(0.35, Delitioner.closestWall(this._me) / 240.0 / Delitioner.wallApproachRate(this._me), 1.0)) : 8.0);
        this.setTurnRightRadians(turnAngle);
        this.setAhead(angle == turnAngle ? length : -length);
    }

    public void onWin(WinEvent e) {
        this.out.println("All enemies have been delitioned...");
    }

    public void execute() {
        super.execute();
        ++_tick;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.addEnemy(e.getName()).updateEnergy(-1.0);
    }

    public void onHitRobot(HitRobotEvent e) {
        if (e.getEnergy() > 0.0) {
            this._target = this.addEnemy(e);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        this.addEnemy(e.getName()).updateEnergy(e.getEnergy());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Wave wave = this.getWave(e.getName(), e.getVelocity());
        Enemy en = this.addEnemy(e.getName());
        if (wave == null && !en._history.isEmpty()) {
            wave = new Wave(en, this._me, e.getPower());
            Point2D bestGuess = null;
            double bestAngle = Double.POSITIVE_INFINITY;
            double toBullet = this._me.heading + e.getBearingRadians();
            for (Scan s : en._history) {
                double angle = Utils.normalAbsoluteAngle((double)(toBullet - Delitioner.absBearing(this._me, s)));
                if (!(bestAngle > angle)) continue;
                bestGuess = s;
                bestAngle = angle;
            }
            Point2D.Double origin = Delitioner.project(this._me, toBullet, bestGuess == null ? 300.0 * Math.random() : bestGuess.distance(this._me));
            origin.setLocation(Delitioner.limit(0.0, origin.x, Delitioner._fieldRect.width), Delitioner.limit(0.0, origin.y, Delitioner._fieldRect.height));
            for (Scan s : this._me._history) {
                if (s.tick != ((Scan)bestGuess).tick) continue;
                wave.tOrigin = s;
                break;
            }
            wave.sOrigin = new Scan(_tick - (long)((int)(bestGuess.distance(this._me) / e.getVelocity())), ((Scan)bestGuess).heading, ((Scan)bestGuess).velocity, ((Scan)bestGuess).energy, origin.x, origin.y);
        }
        wave.registerHit();
    }

    public double wallSmoothing(Point2D.Double origin, double angle, int orientation) {
        Enemy closest = null;
        for (Enemy e : this._enemies) {
            if (!e.alive() || closest != null && !(closest.distanceSq(origin) > e.distanceSq(origin))) continue;
            closest = e;
        }
        Wave w = this.closestEnemyWave();
        if (closest != null) {
            double x = angle;
            double shootAngle = Delitioner.absBearing(w.sOrigin, w.tOrigin);
            double limit = angle + Math.PI * (double)orientation;
            while (x < limit) {
                if (!(!_fieldRectSafe.contains(Delitioner.project(origin, x, 160.0)) || closest.distance(origin) < 300.0 && closest.distanceSq(origin) > closest.distanceSq(Delitioner.project(origin, x, 20.0)) || Math.abs(Utils.normalRelativeAngle((double)(x - shootAngle))) < 0.7853981633974483)) {
                    angle = x;
                    break;
                }
                x += 0.05 * (double)orientation;
            }
        }
        while (!_fieldRectSafe.contains(Delitioner.project(origin, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public double checkDanger(Wave surfWave, int direction) {
        Scan pos = this._me.clone();
        double danger = 0.0;
        int counter = 0;
        while (counter < 500) {
            double moveAngle = this.wallSmoothing(pos, Delitioner.absBearing(surfWave.sOrigin, pos) + (double)direction * Math.PI / 2.0, direction) - pos.heading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            double maxTurning = Rules.getTurnRateRadians((double)pos.velocity);
            pos.heading = Utils.normalRelativeAngle((double)(pos.heading + Delitioner.limit(-maxTurning, Utils.normalRelativeAngle((double)moveAngle), maxTurning)));
            pos.velocity = pos.velocity + (pos.velocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir);
            pos.velocity = Delitioner.limit(-8.0, pos.velocity, 8.0);
            pos.setLocation(Delitioner.project(pos, pos.heading, pos.velocity));
            if (surfWave.distance(pos, counter++) < surfWave.speed) break;
        }
        for (Wave w : this._me._stat) {
            if (w.shooter != surfWave.shooter) continue;
            danger += 1.0 / Delitioner.limit(0.003, Delitioner.square(surfWave.factorToPoint(pos) - w.factor), 3.0);
        }
        return danger;
    }

    public void moveSurf() {
        Wave surfWave = this.closestEnemyWave();
        if (this.getOthers() > 5 || surfWave == null) {
            this.move();
            return;
        }
        double goAngle = Delitioner.absBearing(surfWave.sOrigin, this._me);
        goAngle = this.checkDanger(surfWave, -1) < this.checkDanger(surfWave, 1) ? this.wallSmoothing(this._me, goAngle - 1.5707963267948966, -1) : this.wallSmoothing(this._me, goAngle + 1.5707963267948966, 1);
        this._myDst = Delitioner.project(this._me, goAngle, 100.0);
        this.moveTo(this._myDst);
    }

    protected void move() {
        double bestRisk = Double.POSITIVE_INFINITY;
        double currentHeading = this._me.vector();
        double _lastHeading = this._me.shot(1).vector();
        ++this._timeSinceDirChangeCounter;
        if (Math.abs(Utils.normalRelativeAngle((double)(currentHeading - _lastHeading))) > 1.0471975511965976) {
            this._timeSinceDirChangeCounter = 0;
            this._randomDirChangeAmount = 5 + (int)(Math.random() * 35.0);
        }
        double testAngle = 0.0;
        while (testAngle < Math.PI * 2) {
            Point2D.Double testPoint = Delitioner.project(this._me, testAngle, 40.0);
            if (_fieldRectSafe.contains(testPoint)) {
                double testRisk = 0.0;
                for (Enemy e : this._enemies) {
                    if (!e.alive()) continue;
                    testRisk += Delitioner.limit(0.5, e.energy / this._me.energy, 2.0) / testPoint.distanceSq(e) * (1.0 + Math.abs(Math.cos(Delitioner.absBearing(this._me, e) - testAngle))) * (double)(e.age() + 1L);
                    if (!(this._me.distance(e) < 100.0) || !(Math.abs(Utils.normalRelativeAngle((double)(Delitioner.absBearing(this._me, e) - Delitioner.absBearing(this._me, testPoint)))) < 1.9477874452256718)) continue;
                    testRisk += 1.0;
                }
                for (Wave hit : this._me._stat) {
                    double angle = Utils.normalRelativeAngle((double)(1.5707963267948966 - Math.abs(testAngle - Delitioner.absBearing(this._me, hit.shooter))));
                    testRisk += Delitioner.square(angle) * (double)(hit.shooter.alive() ? 20 : 4) * (20.0 - hit.speed) / hit.tHit.distance(testPoint) / (double)hit.age();
                }
                if (Math.abs(Utils.normalRelativeAngle((double)(currentHeading - testAngle))) < 1.0471975511965976 && this.getOthers() <= 4) {
                    testRisk /= 7.0;
                    if (this._timeSinceDirChangeCounter > this._randomDirChangeAmount) {
                        testRisk *= 20.0;
                    }
                }
                int z = 0;
                while (z < 7) {
                    testRisk *= 1.0 + 2000.0 / testPoint.distanceSq(this._me.shot(z * 5 + 1));
                    ++z;
                }
                if (testRisk < bestRisk) {
                    bestRisk = testRisk;
                    this._myDst = testPoint;
                }
            }
            testAngle += 0.12566370614359174;
        }
        this.moveTo(this._myDst);
    }

    protected void updateMe() {
        this._me.update(this.getHeadingRadians(), this.getVelocity(), this.getEnergy(), this.getX(), this.getY());
    }

    protected Enemy getEnemy(String name) {
        for (Enemy e : this._enemies) {
            if (!e.equals(name)) continue;
            return e;
        }
        return null;
    }

    protected Enemy addEnemy(String name) {
        Enemy tmp = this.getEnemy(name);
        if (tmp == null) {
            tmp = new Enemy(name);
            this._enemies.add(tmp);
        }
        if (this._target == null) {
            this._target = tmp;
        }
        return tmp;
    }

    protected Enemy addEnemy(ScannedRobotEvent e) {
        Enemy tmp = this.addEnemy(e.getName());
        tmp.update(e.getHeadingRadians(), e.getVelocity(), e.getEnergy(), Delitioner.project(this._me, e.getBearingRadians() + this.getHeadingRadians(), e.getDistance()));
        return tmp;
    }

    protected Enemy addEnemy(HitRobotEvent e) {
        Enemy tmp = this.addEnemy(e.getName());
        tmp.update(tmp.heading, tmp.velocity, e.getEnergy(), Delitioner.project(this._me, e.getBearingRadians() + this.getHeadingRadians(), 72.0));
        return tmp;
    }

    protected double avgAge() {
        double sum = 0.0;
        double count = this.getOthers();
        if (count == 0.0) {
            return 0.0;
        }
        for (Enemy e : this._enemies) {
            if (!e.alive()) continue;
            sum += (double)e.age();
            count -= 1.0;
        }
        return (sum + count * (double)_tick) / (double)this.getOthers();
    }

    protected Wave getWave(String owner, double speed) {
        for (Wave w : this._waves) {
            if (!w.shooter.equals(owner) || !(w.distanceToTarget() < 50.0) || Math.round(speed * 10.0) != Math.round(w.speed * 10.0)) continue;
            return w;
        }
        return null;
    }

    protected static double wallApproachRate(Scan s) {
        return Math.abs(s.velocity) < 0.05 ? 0.0 : Delitioner.closestWall(s) - Delitioner.closestWall(Delitioner.project(s, s.vector(), 1.0));
    }

    protected static double mix(double from, double to, double x) {
        return from < to ? from + (to - from) * x : Delitioner.mix(to, from, 1.0 - x);
    }

    protected static double closestWall(Point2D.Double p) {
        return Math.min(Math.min(p.x, Delitioner._fieldRect.width - p.x), Math.min(p.y, Delitioner._fieldRect.height - p.y));
    }

    protected static double square(double x) {
        return x * x;
    }

    protected static int sign(double x) {
        return x < 0.0 ? -1 : 1;
    }

    protected static Point2D.Double project(Point2D.Double origin, double angle, double length) {
        return new Point2D.Double(origin.x + Math.sin(angle) * length, origin.y + Math.cos(angle) * length);
    }

    protected static double limit(double min, double value, double max) {
        return min > max ? Delitioner.limit(max, value, min) : Math.max(min, Math.min(value, max));
    }

    protected static double absBearing(Point2D.Double from, Point2D.Double to) {
        return Math.atan2(to.x - from.x, to.y - from.y);
    }

    protected static int circlingDir(Scan origin, Scan moving) {
        return Math.sin(moving.heading - Delitioner.absBearing(origin, moving)) * moving.velocity < 0.0 ? -1 : 1;
    }

    protected static double escapeAngle(double bulletSpeed) {
        return Math.asin(8.0 / bulletSpeed);
    }

    protected Wave closestEnemyWave() {
        Wave closest = null;
        for (Wave w : this._waves) {
            if (w.target != this._me || closest != null && !(w.distanceToTarget() < closest.distanceToTarget())) continue;
            closest = w;
        }
        return closest;
    }

    protected void projectWaves() {
        int i = 0;
        while (i < this._waves.size()) {
            Wave w = this._waves.get(i);
            if (w.target != this._me && w.distanceToTarget() < 8.0) {
                w.registerHit();
                this._waves.remove(i--);
            } else if (w.target == this._me && w.distanceToTarget() < 36.0 - w.speed * 2.0) {
                this._waves.remove(i--);
            }
            ++i;
        }
    }

    protected class Enemy
    extends Scan {
        public static final int LEN_HIST = 200;
        public static final int LEN_STAT = 1000;
        public String name;
        public Scan shot;
        public LinkedList<Wave> _stat;
        private ArrayList<Scan> _history;

        public Enemy(String n) {
            super(_tick, 0.0, 0.0, 100.0, 0.0, 0.0);
            this._stat = new LinkedList();
            this._history = new ArrayList(200);
            this.name = n;
        }

        public boolean alive() {
            return this.energy >= 0.0;
        }

        public void updateEnergy(double h) {
            if (this.alive()) {
                this.shot.energy = this.energy = h;
            }
        }

        public void update(double h, double v, double e, Point2D.Double p) {
            this.update(h, v, e, p.x, p.y);
        }

        public void update(double h, double v, double e, double x, double y) {
            if (!this.alive()) {
                return;
            }
            if (this._history.isEmpty() || this.tick < _tick) {
                if (this._history.size() >= 200) {
                    this._history.remove(199);
                }
                this.shot = new Scan(_tick, h, v, e, x, y);
                this._history.add(0, this.shot);
            } else {
                this.shot.update(_tick, h, v, e, x, y);
            }
            super.update(_tick, h, v, e, x, y);
        }

        public double energyDrop() {
            return this.age() == 0L && this.tick - this.shot((int)1).tick == 1L ? this.shot((int)1).energy - this.energy : 0.0;
        }

        public void addStat(Wave w) {
            if (this._stat.size() >= 1000) {
                this._stat.removeLast();
            }
            this._stat.add(0, w);
        }

        public boolean equals(String n) {
            return n.equals(this.name);
        }

        public double rating() {
            int count = 1;
            for (Wave w : Delitioner.this._me._stat) {
                if (w.shooter != this) continue;
                ++count;
            }
            return this.alive() ? this.distanceSq(Delitioner.this._me) * Delitioner.square(this.age() + 4L) / (double)count : Double.POSITIVE_INFINITY;
        }

        public Scan shot(int past) {
            return this._history.get((int)Delitioner.limit(0.0, past, this._history.size() - 1));
        }

        public double bestFactor(Enemy e, double power) {
            Wave now = new Wave(e, this, power);
            double bestDiff = Double.POSITIVE_INFINITY;
            double bearing = Delitioner.absBearing(e, this);
            double escape = (double)now.circling * Delitioner.escapeAngle(Rules.getBulletSpeed((double)power));
            double bestFactor = bearing;
            for (Wave w : this._stat) {
                if (w.shooter != now.shooter || !(now.difference(w) < bestDiff) || !_fieldRect.contains(Delitioner.project(e, bearing + w.factor * escape, now.distance))) continue;
                bestDiff = now.difference(w);
                bestFactor = bearing + w.factor * escape;
                if (bestDiff < 15.0) break;
            }
            return bestFactor;
        }
    }

    protected class Wave {
        public Enemy shooter;
        public Enemy target;
        public Scan sOrigin;
        public Scan tOrigin;
        public Scan sHit;
        public Scan tHit;
        public int circling;
        public double factor;
        public double speed;
        public double distance;
        public double awayVelocity;
        public double latVelocity;

        public Wave(Enemy sh, Enemy tar, double power) {
            this.shooter = sh;
            this.target = tar;
            this.sOrigin = this.shooter.shot;
            this.tOrigin = this.target.shot;
            this.speed = Rules.getBulletSpeed((double)power);
            this.awayVelocity = this.shooter.distance(this.target) - this.shooter.shot(1).distance(this.target.shot(1));
            this.latVelocity = Math.sin(Delitioner.absBearing(this.shooter, this.target) - Delitioner.absBearing(this.shooter.shot(1), this.target.shot(1))) * this.target.velocity;
            this.circling = Delitioner.circlingDir(sh, tar);
            this.distance = sh.distance(tar);
        }

        public void registerHit() {
            if (this.target.age() > 2L) {
                return;
            }
            this.sHit = this.shooter.shot;
            this.tHit = this.target.shot;
            this.factor = this.factorToPoint(this.tHit);
            this.target.addStat(this);
        }

        public double factorToPoint(Point2D.Double p) {
            return Utils.normalRelativeAngle((double)(Delitioner.absBearing(this.sOrigin, p) - Delitioner.absBearing(this.sOrigin, this.tOrigin))) / Delitioner.escapeAngle(this.speed) * (double)this.circling;
        }

        public double distanceToTarget() {
            return this.distance(this.target, 0);
        }

        public double distance(Point2D.Double p, int future) {
            return this.sOrigin.distance(p) - (double)((long)future + this.age()) * this.speed;
        }

        public long age() {
            return _tick - this.sOrigin.tick;
        }

        public double difference(Wave w) {
            return Delitioner.square(w.distance / w.speed - this.distance / this.speed) / 4.0 + 10.0 * Math.abs(this.awayVelocity - w.awayVelocity) + 15.0 * Math.abs(this.latVelocity * (double)this.circling - w.latVelocity * (double)w.circling);
        }
    }

    protected class Scan
    extends Point2D.Double {
        public long tick;
        public double heading;
        public double velocity;
        public double energy;

        public Scan(long t, double h, double v, double e, double x, double y) {
            this.update(t, h, v, e, x, y);
        }

        public void update(long t, double h, double v, double e, double x, double y) {
            this.setLocation(x, y);
            this.heading = h;
            this.energy = e;
            this.velocity = v;
            this.tick = t;
        }

        public long age() {
            return _tick - this.tick;
        }

        public double vector() {
            return Utils.normalRelativeAngle((double)(this.heading + (Delitioner.this._me.velocity < 0.0 ? Math.PI : 0.0)));
        }

        public Scan clone() {
            return new Scan(this.tick, this.heading, this.velocity, this.energy, this.x, this.y);
        }
    }
}

