/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.compound;

import dmonner.xlbp.Component;
import dmonner.xlbp.DownstreamComponent;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.compound.Compound;
import dmonner.xlbp.layer.UpstreamLayer;

public abstract class AbstractCompound
implements Compound {
    private static final long serialVersionUID = 1L;
    protected final String name;
    protected UpstreamLayer out;
    protected boolean built;

    public AbstractCompound(AbstractCompound that, NetworkCopier copier) {
        this.name = copier.getCopyNameFrom(that);
    }

    public AbstractCompound(String name) {
        this.name = name;
    }

    @Override
    public void addDownstream(DownstreamComponent downstream) {
        this.out.addDownstream(downstream);
    }

    @Override
    public UpstreamLayer asUpstreamLayer() {
        return this.out;
    }

    @Override
    public void build() {
        if (!this.built) {
            this.built = true;
        }
    }

    @Override
    public void clear() {
        this.clearActivations();
        this.clearEligibilities();
        this.clearResponsibilities();
    }

    @Override
    public int compareTo(Component that) {
        return this.name.compareTo(that.getName());
    }

    @Override
    public boolean connectedDownstream(DownstreamComponent downstream) {
        return this.out.connectedDownstream(downstream);
    }

    @Override
    public abstract AbstractCompound copy(NetworkCopier var1);

    @Override
    public AbstractCompound copy(String nameSuffix) {
        NetworkCopier copier = new NetworkCopier(nameSuffix);
        AbstractCompound copy = this.copy(copier);
        copier.build();
        return copy;
    }

    @Override
    public void copyConnectivityFrom(Component comp, NetworkCopier copier) {
        if (comp instanceof AbstractCompound) {
            AbstractCompound that = (AbstractCompound)comp;
            this.out.copyConnectivityFrom(that.out, copier);
        }
    }

    @Override
    public DownstreamComponent getDownstream() {
        return this.out.getDownstream();
    }

    @Override
    public DownstreamComponent getDownstream(int index) {
        return this.out.getDownstream(index);
    }

    @Override
    public int getIndexInDownstream() {
        return this.out.getIndexInDownstream();
    }

    @Override
    public int getIndexInDownstream(int index) {
        return this.out.getIndexInDownstream(index);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UpstreamLayer getOutput() {
        return this.out;
    }

    @Override
    public UpstreamLayer getOutput(int index) {
        if (index > 0) {
            throw new IllegalArgumentException("Index too large.");
        }
        return this.out;
    }

    @Override
    public int indexOfDownstream(DownstreamComponent downstream) {
        return this.out.indexOfDownstream(downstream);
    }

    @Override
    public boolean isBuilt() {
        return this.built;
    }

    @Override
    public int nDownstream() {
        return this.out.nDownstream();
    }

    @Override
    public int nOutputs() {
        return 1;
    }

    @Override
    public boolean optimize() {
        if (this.out == null) {
            throw new IllegalStateException("Missing output layer.");
        }
        return true;
    }

    @Override
    public void removeDownstream(DownstreamComponent downstream) {
        this.out.removeDownstream(downstream);
    }

    @Override
    public void removeDownstream(int index) {
        this.out.removeDownstream(index);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        if (sb.showName()) {
            sb.indent();
            sb.append(this.name);
            sb.append(" : ");
            sb.append(this.getClass().getSimpleName());
            sb.appendln();
        }
    }

    @Override
    public String toString(String show) {
        NetworkStringBuilder sb = new NetworkStringBuilder(show);
        this.toString(sb);
        return sb.toString();
    }

    @Override
    public void unbuild() {
        this.built = false;
    }
}

