/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.layer;

import dmonner.xlbp.Component;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.Responsibilities;
import dmonner.xlbp.layer.AbstractUpstreamLayer;
import dmonner.xlbp.layer.CopySourceLayer;

public class CopyDestinationLayer
extends AbstractUpstreamLayer {
    private static final long serialVersionUID = 1L;
    private CopySourceLayer source;

    public CopyDestinationLayer(CopyDestinationLayer that, NetworkCopier copier) {
        super(that, copier);
    }

    public CopyDestinationLayer(String name, CopySourceLayer source) {
        super(name, source.size());
        this.source = source;
        this.source.setCopyDestination(this);
    }

    @Override
    public void activateTest() {
        System.arraycopy(this.source.y, 0, this.y, 0, this.size);
    }

    @Override
    public void activateTrain() {
        this.activateTest();
    }

    @Override
    public void build() {
        if (!this.built) {
            if (this.source == null) {
                throw new IllegalStateException("CopyDestinationLayer " + this.name + " has no source!");
            }
            super.build();
            this.y = new float[this.size];
            this.d = new Responsibilities(this.size);
            this.built = true;
        }
    }

    @Override
    public CopyDestinationLayer copy(NetworkCopier copier) {
        return new CopyDestinationLayer(this, copier);
    }

    @Override
    public CopyDestinationLayer copy(String nameSuffix) {
        return this.copy(new NetworkCopier(nameSuffix));
    }

    @Override
    public void copyConnectivityFrom(Component comp, NetworkCopier copier) {
        super.copyConnectivityFrom(comp, copier);
        if (comp instanceof CopyDestinationLayer) {
            this.source = copier.getCopyIfExists(((CopyDestinationLayer)comp).source);
        }
    }

    public CopySourceLayer getCopySource() {
        return this.source;
    }

    public void setCopySource(CopySourceLayer source) {
        this.source = source;
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        super.toString(sb);
        sb.pushIndent();
        if (sb.showExtra()) {
            sb.appendln("CopySource: " + this.source);
        }
        sb.popIndent();
    }

    @Override
    public void updateEligibilities() {
        this.downstream.updateUpstreamResponsibilities(this.myIndexInDownstream);
    }

    @Override
    public void updateResponsibilities() {
    }
}

