/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.stat.AbstractStat;
import dmonner.xlbp.stat.Stat;
import dmonner.xlbp.util.CSVWriter;
import java.io.IOException;
import java.util.Map;

public class BitDistStat
extends AbstractStat {
    public static float OFF = 0.0f;
    public static float ON = 1.0f;
    public static float MID = 0.5f;
    public static boolean WTA = false;
    private final float on;
    private final float mid;
    private final boolean wta;
    private final String name;
    private final int n;
    private final int[] output;
    private final int[] target;
    private final float[] fracOutput;
    private final float[] fracTarget;
    private int totOutput;
    private int totTarget;

    public BitDistStat(BitDistStat that) {
        this.name = that.name;
        this.on = that.on;
        this.mid = that.mid;
        this.wta = that.wta;
        this.n = that.n;
        this.output = (int[])that.output.clone();
        this.target = (int[])that.target.clone();
        this.fracOutput = (float[])that.fracOutput.clone();
        this.fracTarget = (float[])that.fracTarget.clone();
        this.totOutput = that.totOutput;
        this.totTarget = that.totTarget;
    }

    public BitDistStat(int n) {
        this("Dist", n);
    }

    public BitDistStat(String name, int n) {
        this.name = name;
        this.on = ON;
        this.mid = MID;
        this.wta = WTA;
        this.n = n;
        this.output = new int[n];
        this.target = new int[n];
        this.fracOutput = new float[n];
        this.fracTarget = new float[n];
    }

    public void add(BitDistStat that) {
        if (this.n != that.n) {
            throw new IllegalArgumentException("Can only add in BitDistStats with same n.");
        }
        for (int i = 0; i < this.n; ++i) {
            int n = i;
            this.output[n] = this.output[n] + that.output[i];
            int n2 = i;
            this.target[n2] = this.target[n2] + that.target[i];
        }
    }

    @Override
    public void add(Stat that) {
        if (!(that instanceof BitDistStat)) {
            throw new IllegalArgumentException("Can only add in other BitDistStats.");
        }
        this.add((BitDistStat)that);
    }

    @Override
    public void addTo(String prefix, Map<String, Object> map) {
        int i;
        for (i = 0; i < this.n; ++i) {
            map.put(prefix + this.name + "Output" + i, this.output[i]);
        }
        for (i = 0; i < this.n; ++i) {
            map.put(prefix + this.name + "Target" + i, this.target[i]);
        }
        for (i = 0; i < this.n; ++i) {
            map.put(prefix + this.name + "FracOutput" + i, Float.valueOf(this.fracOutput[i]));
        }
        for (i = 0; i < this.n; ++i) {
            map.put(prefix + this.name + "FracTarget" + i, Float.valueOf(this.fracTarget[i]));
        }
    }

    @Override
    public void analyze() {
        int i;
        this.totOutput = 0;
        this.totTarget = 0;
        for (i = 0; i < this.n; ++i) {
            this.totOutput += this.output[i];
            this.totTarget += this.target[i];
        }
        for (i = 0; i < this.n; ++i) {
            this.fracOutput[i] = (float)this.output[i] / (float)this.totOutput;
            this.fracTarget[i] = (float)this.target[i] / (float)this.totTarget;
        }
    }

    private void append(StringBuilder sb, String field, float val) {
        sb.append(this.name);
        sb.append(field);
        sb.append(" = ");
        sb.append(val);
        sb.append("\n");
    }

    private void append(StringBuilder sb, String field, int val) {
        sb.append(this.name);
        sb.append(field);
        sb.append(" = ");
        sb.append(val);
        sb.append("\n");
    }

    @Override
    public void clear() {
        int i;
        this.totOutput = 0;
        this.totTarget = 0;
        for (i = 0; i < this.n; ++i) {
            this.output[i] = 0;
            this.target[i] = 0;
        }
        for (i = 0; i < this.n; ++i) {
            this.fracOutput[i] = 0.0f;
            this.fracTarget[i] = 0.0f;
        }
    }

    public void compare(float[] target, float[] output) {
        if (WTA) {
            this.compareWTA(target, output);
        } else {
            this.compareExact(target, output);
        }
    }

    public void compareExact(float[] target, float[] output) {
        for (int i = 0; i < target.length; ++i) {
            if (Float.isInfinite(target[i]) || Float.isNaN(target[i])) {
                throw new IllegalArgumentException("Infinite/NaN Target!");
            }
            if (Float.isInfinite(output[i]) || Float.isNaN(output[i])) {
                throw new IllegalArgumentException("Infinite/NaN Output!");
            }
            if (target[i] >= MID) {
                int n = i;
                this.target[n] = this.target[n] + 1;
            }
            if (!(output[i] >= MID)) continue;
            int n = i;
            this.output[n] = this.output[n] + 1;
        }
    }

    public void compareWTA(float[] target, float[] output) {
        int targetIdx = -1;
        int outputIdx = -1;
        float outputMax = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < target.length; ++i) {
            if (Float.isInfinite(target[i]) || Float.isNaN(target[i])) {
                throw new IllegalArgumentException("Infinite/NaN Target!");
            }
            if (Float.isInfinite(output[i]) || Float.isNaN(output[i])) {
                throw new IllegalArgumentException("Infinite/NaN Output!");
            }
            if (target[i] == ON) {
                if (targetIdx >= 0) {
                    throw new IllegalArgumentException("Multiple target bits set! Not suitable for WTA.");
                }
                targetIdx = i;
            }
            if (!(output[i] > outputMax)) continue;
            outputIdx = i;
            outputMax = output[i];
        }
        int n = targetIdx;
        this.target[n] = this.target[n] + 1;
        int n2 = outputIdx;
        this.output[n2] = this.output[n2] + 1;
    }

    @Override
    public void saveData(CSVWriter out) throws IOException {
        int i;
        for (i = 0; i < this.n; ++i) {
            out.appendField(this.output[i]);
        }
        for (i = 0; i < this.n; ++i) {
            out.appendField(this.target[i]);
        }
        for (i = 0; i < this.n; ++i) {
            out.appendField(this.fracOutput[i]);
        }
        for (i = 0; i < this.n; ++i) {
            out.appendField(this.fracTarget[i]);
        }
    }

    @Override
    public void saveHeader(String prefix, CSVWriter out) throws IOException {
        int i;
        for (i = 0; i < this.n; ++i) {
            out.appendHeader(prefix + this.name + "Output" + i);
        }
        for (i = 0; i < this.n; ++i) {
            out.appendHeader(prefix + this.name + "Target" + i);
        }
        for (i = 0; i < this.n; ++i) {
            out.appendHeader(prefix + this.name + "FracOutput" + i);
        }
        for (i = 0; i < this.n; ++i) {
            out.appendHeader(prefix + this.name + "FracTarget" + i);
        }
    }

    @Override
    public String toString(String prefix) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.n; ++i) {
            this.append(sb, prefix + this.name + "Output" + i, this.output[i]);
        }
        for (i = 0; i < this.n; ++i) {
            this.append(sb, prefix + this.name + "Target" + i, this.target[i]);
        }
        for (i = 0; i < this.n; ++i) {
            this.append(sb, prefix + this.name + "FracOutput" + i, this.fracOutput[i]);
        }
        for (i = 0; i < this.n; ++i) {
            this.append(sb, prefix + this.name + "FracTarget" + i, this.fracTarget[i]);
        }
        return sb.toString();
    }
}

