/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.util;

import dmonner.xlbp.util.NoiseGenerator;
import java.util.Random;

public class NormalNoiseGenerator
implements NoiseGenerator {
    private final Random random;
    private final float mean;
    private final float sd;
    private float cached;

    public NormalNoiseGenerator(Random random, float mean, float sd) {
        this.random = random;
        this.mean = mean;
        this.sd = sd;
    }

    @Override
    public float next() {
        float v2;
        float v1;
        float s;
        if (!Float.isNaN(this.cached)) {
            float rv = this.mean + this.cached * this.sd;
            this.cached = Float.NaN;
            return rv;
        }
        while ((s = (v1 = 2.0f * this.random.nextFloat() - 1.0f) * v1 + (v2 = 2.0f * this.random.nextFloat() - 1.0f) * v2) >= 1.0f) {
        }
        float factor = (float)Math.sqrt(-2.0 * Math.log(s) / (double)s);
        this.cached = factor * v1;
        return this.mean + factor * v2 * this.sd;
    }
}

