/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws;

import java.awt.geom.Point2D;
import xander.core.drive.Direction;
import xander.core.drive.DistancingEquation;
import xander.core.drive.DriveController;
import xander.core.drive.DrivePrediction;
import xander.core.drive.OrbitalDrivePredictor;
import xander.core.math.RCMath;
import xander.core.math.RCPhysics;
import xander.core.math.VelocityVector;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.gfws.FactorArrays;
import xander.gfws.FactorRange;

public class OrbitalFactorArrays {
    public static FactorRange getReachableFactorRange(double bulletVelocity, Snapshot initialAttackerSnapshot, Snapshot initialDefenderSnapshot, long time, int numFactors, boolean diveProtect, DistancingEquation distancingEquation, OrbitalDrivePredictor orbitalDrivePaths) {
        double bulletPower = RCPhysics.getBulletPower(bulletVelocity);
        Wave wave = new Wave(initialDefenderSnapshot, initialAttackerSnapshot, bulletPower, initialAttackerSnapshot.getTime());
        return OrbitalFactorArrays.getReachableFactorRange(wave, initialAttackerSnapshot, initialDefenderSnapshot, time, numFactors, diveProtect, distancingEquation, orbitalDrivePaths);
    }

    public static FactorRange getReachableFactorRange(Wave wave, Snapshot attackerSnapshot, Snapshot defenderSnapshot, long time, int numFactors, boolean diveProtect, DistancingEquation distancingEquation, OrbitalDrivePredictor orbitalDrivePaths) {
        int ccwDivisionIndex;
        int cwDivisionIndex;
        int currentDivisionIndex;
        FactorRange rfr = new FactorRange();
        double currentAngle = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), defenderSnapshot.getX(), defenderSnapshot.getY());
        double divisionAngle = RCMath.getTurnAngle(wave.getInitialDefenderBearing(), currentAngle);
        rfr.currentDefenderIndex = currentDivisionIndex = FactorArrays.getFactorIndex(divisionAngle, numFactors, wave.getBulletVelocity(), wave.getSurfDirection());
        double currentDistance = Double.POSITIVE_INFINITY;
        if (attackerSnapshot != null) {
            currentDistance = attackerSnapshot.getDistance();
        }
        DrivePrediction cwDrivePrediction = orbitalDrivePaths.predictMaxPathBeforeBulletHit(defenderSnapshot, Direction.CLOCKWISE, wave.getOriginX(), wave.getOriginY(), time - wave.getOriginTime(), wave.getBulletVelocity(), currentDistance, distancingEquation);
        Point2D.Double cwPosition = cwDrivePrediction.getFinalDriveState().getPosition();
        double cwAngleFromOrigin = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), cwPosition.x, cwPosition.y);
        double cwAngleOffset = RCMath.getTurnAngle(wave.getInitialDefenderBearing(), cwAngleFromOrigin);
        rfr.maxClockwiseIndex = cwDivisionIndex = FactorArrays.getFactorIndex(cwAngleOffset, numFactors, wave.getBulletVelocity(), wave.getSurfDirection());
        rfr.maxClockwiseFactorAngle = cwAngleOffset;
        rfr.clockwisePath = cwDrivePrediction.getDrivePath();
        rfr.clockwiseDistances = new double[rfr.clockwisePath.size()];
        rfr.clockwiseFactorIndexes = new double[rfr.clockwisePath.size()];
        Point2D.Double attackerPos = new Point2D.Double(attackerSnapshot.getX(), attackerSnapshot.getY());
        double[] attackerDelta = attackerSnapshot.getXYShift();
        int i = 0;
        while (i < rfr.clockwiseDistances.length) {
            Point2D.Double point = rfr.clockwisePath.get(i);
            rfr.clockwiseDistances[i] = RCMath.getDistanceBetweenPoints(point.x, point.y, attackerPos.x, attackerPos.y);
            double pointAngle = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), point.x, point.y);
            double pointFactorAngle = RCMath.getTurnAngle(wave.getInitialDefenderBearing(), pointAngle);
            rfr.clockwiseFactorIndexes[i] = FactorArrays.getPreciseFactorIndex(pointFactorAngle, numFactors, wave.getBulletVelocity(), wave.getSurfDirection());
            attackerPos.x += attackerDelta[0];
            attackerPos.y += attackerDelta[1];
            ++i;
        }
        DrivePrediction ccwDrivePrediction = orbitalDrivePaths.predictMaxPathBeforeBulletHit(defenderSnapshot, Direction.COUNTER_CLOCKWISE, wave.getOriginX(), wave.getOriginY(), time - wave.getOriginTime(), wave.getBulletVelocity(), currentDistance, distancingEquation);
        Point2D.Double ccwPosition = ccwDrivePrediction.getFinalDriveState().getPosition();
        double ccwAngleFromOrigin = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), ccwPosition.x, ccwPosition.y);
        double ccwAngleOffset = RCMath.getTurnAngle(wave.getInitialDefenderBearing(), ccwAngleFromOrigin);
        rfr.maxCounterClockwiseIndex = ccwDivisionIndex = FactorArrays.getFactorIndex(ccwAngleOffset, numFactors, wave.getBulletVelocity(), wave.getSurfDirection());
        rfr.maxCounterClockwiseFactorAngle = ccwAngleOffset;
        rfr.counterClockwisePath = ccwDrivePrediction.getDrivePath();
        rfr.counterClockwiseDistances = new double[rfr.counterClockwisePath.size()];
        rfr.counterClockwiseFactorIndexes = new double[rfr.counterClockwisePath.size()];
        attackerPos = new Point2D.Double(attackerSnapshot.getX(), attackerSnapshot.getY());
        int i2 = 0;
        while (i2 < rfr.counterClockwiseDistances.length) {
            Point2D.Double point = rfr.counterClockwisePath.get(i2);
            rfr.counterClockwiseDistances[i2] = RCMath.getDistanceBetweenPoints(point.x, point.y, attackerPos.x, attackerPos.y);
            double pointAngle = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), point.x, point.y);
            double pointFactorAngle = RCMath.getTurnAngle(wave.getInitialDefenderBearing(), pointAngle);
            rfr.counterClockwiseFactorIndexes[i2] = FactorArrays.getPreciseFactorIndex(pointFactorAngle, numFactors, wave.getBulletVelocity(), wave.getSurfDirection());
            attackerPos.x += attackerDelta[0];
            attackerPos.y += attackerDelta[1];
            ++i2;
        }
        double cwDistance = rfr.clockwiseDistances[rfr.clockwiseDistances.length - 1];
        double ccwDistance = rfr.counterClockwiseDistances[rfr.counterClockwiseDistances.length - 1];
        if (diveProtect && currentDistance < (distancingEquation.getOptimalDistance() + distancingEquation.getMaxRetreatDistance()) / 2.0) {
            if ((ccwDistance < currentDistance - 35.0 || ccwDistance < 70.0) && cwDistance >= currentDistance) {
                ccwDivisionIndex = Math.min(currentDivisionIndex, cwDivisionIndex);
                rfr.diveProtected = true;
            } else if ((cwDistance < currentDistance - 35.0 || cwDistance < 70.0) && ccwDistance >= currentDistance) {
                cwDivisionIndex = Math.max(currentDivisionIndex, ccwDivisionIndex);
                rfr.diveProtected = true;
            }
        }
        if (ccwDivisionIndex > cwDivisionIndex) {
            rfr.beginIndex = cwDivisionIndex;
            rfr.endIndex = ccwDivisionIndex;
        } else {
            rfr.beginIndex = ccwDivisionIndex;
            rfr.endIndex = cwDivisionIndex;
        }
        return rfr;
    }

    public static void driveToFactor(Wave wave, double factorAngle, double x, double y, double opponentDistance, DistancingEquation distancingEquation, OrbitalDrivePredictor orbitalDrivePaths, DriveController driveController) {
        double facing = RCMath.getRobocodeAngle(wave.getOriginX() - x, wave.getOriginY() - y);
        double opposingAngle = RCMath.normalizeDegrees(facing + 180.0);
        double turnAngle = RCMath.getTurnAngle(opposingAngle, wave.getInitialDefenderBearing() + factorAngle);
        Direction direction = turnAngle < 0.0 ? Direction.COUNTER_CLOCKWISE : Direction.CLOCKWISE;
        double targetHeadingFromOrigin = RCMath.normalizeDegrees(wave.getInitialDefenderBearing() + factorAngle);
        boolean isOvershoot = orbitalDrivePaths.isOvershoot(wave.getOrigin(), opponentDistance, direction, targetHeadingFromOrigin, wave, distancingEquation);
        double speed = isOvershoot ? 0.0 : 8.0;
        VelocityVector driveVector = orbitalDrivePaths.getSmoothedOrbitAngle(wave.getOrigin(), opponentDistance, direction, distancingEquation, speed);
        driveController.drive(driveVector.getRoboAngle(), driveVector.getMagnitude());
    }
}

