/*
 * Decompiled with CFR 0.152.
 */
package vjik;

import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class EnemyData {
    private String name;
    private double energy;
    private double x;
    private double y;
    private double vel;
    private double crs;
    private double accel;
    private double omega;
    private double hdg;
    private double brg;
    private double dist;
    private double closure;
    private long scanTime;

    public String getName() {
        return this.name;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getVel() {
        return this.vel;
    }

    public double getCrs() {
        return this.crs;
    }

    public double getAccel() {
        return this.accel;
    }

    public double getOmega() {
        return this.omega;
    }

    public double getHdg() {
        return this.hdg;
    }

    public double getBrg() {
        return this.brg;
    }

    public double getDist() {
        return this.dist;
    }

    public double getClosure() {
        return this.closure;
    }

    public long getScanTime() {
        return this.scanTime;
    }

    public void setEnergy(double d) {
        this.energy = d;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EnemyData enemyData = (EnemyData)object;
        return !(this.name == null ? enemyData.name != null : !this.name.equals(enemyData.name));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return String.format(this.name + " energy: " + this.energy + " dist: " + this.dist + "%n" + "scantime: " + this.scanTime + " accel: " + this.accel + " omega: " + this.omega + "%n", new Object[0]);
    }

    public EnemyData() {
        this.x = -1.0;
        this.y = -1.0;
        this.vel = 0.0;
        this.hdg = 0.0;
        this.brg = 0.0;
        this.crs = 0.0;
        this.dist = 0.0;
        this.scanTime = -1L;
    }

    public EnemyData(ScannedRobotEvent scannedRobotEvent, double d, double d2, double d3) {
        this.name = scannedRobotEvent.getName();
        this.energy = scannedRobotEvent.getEnergy();
        this.vel = scannedRobotEvent.getVelocity();
        this.crs = scannedRobotEvent.getHeadingRadians();
        this.dist = scannedRobotEvent.getDistance();
        this.brg = scannedRobotEvent.getBearingRadians();
        this.hdg = Utils.normalAbsoluteAngle((double)(d3 + this.brg));
        this.closure = -1.0 * this.vel * Math.cos(Utils.normalRelativeAngle((double)(this.crs - this.hdg)));
        this.x = d + this.dist * Math.sin(this.hdg);
        this.y = d2 + this.dist * Math.cos(this.hdg);
        this.scanTime = scannedRobotEvent.getTime();
    }

    public void importTgt(ScannedRobotEvent scannedRobotEvent, double d, double d2, double d3) {
        this.name = scannedRobotEvent.getName();
        this.energy = scannedRobotEvent.getEnergy();
        this.accel = this.scanTime == scannedRobotEvent.getTime() - 1L ? scannedRobotEvent.getVelocity() - this.vel : 0.0;
        this.vel = scannedRobotEvent.getVelocity();
        this.omega = this.scanTime == scannedRobotEvent.getTime() - 1L ? scannedRobotEvent.getHeadingRadians() - this.crs : 0.0;
        this.crs = scannedRobotEvent.getHeadingRadians();
        this.dist = scannedRobotEvent.getDistance();
        this.brg = scannedRobotEvent.getBearingRadians();
        this.hdg = Utils.normalAbsoluteAngle((double)(d3 + this.brg));
        this.closure = -1.0 * this.vel * Math.cos(Utils.normalRelativeAngle((double)(this.crs - this.hdg)));
        this.x = d + this.dist * Math.sin(this.hdg);
        this.y = d2 + this.dist * Math.cos(this.hdg);
        this.scanTime = scannedRobotEvent.getTime();
    }

    public void updateTgt(double d, double d2, double d3, long l) {
        if (l - this.scanTime == 0L) {
            return;
        }
        this.x += this.vel * Math.sin(this.crs);
        this.y += this.vel * Math.cos(this.crs);
        this.hdg = Math.atan((this.x - d) / (this.y - d2));
        if (d2 > this.y) {
            this.hdg += Math.PI;
        }
        this.brg = Utils.normalRelativeAngle((double)(this.hdg - d3));
        this.dist = Math.hypot(this.x - d, this.y - d2);
    }
}

