/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy;

import alk.lap.LoudAndProud;
import alk.lap.strategy.AtomicMove;
import alk.lap.utils.RollingHistory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternBase {
    private static final int HISTORY_SIZE = 2000;
    private static final int SEARCHPATTERN_SIZE = 7;
    private static final int MIN_MOVE_SUCCESSORS = 40;
    RollingHistory<AtomicMove> atomicMoveHistory = new RollingHistory(2000);
    RollingHistory<String> accessHashHistory = new RollingHistory(7);
    RollingHistory<AtomicMove> followersHistory = new RollingHistory(40);
    int currentHash = 0;
    private LoudAndProud proud;

    public void addAtomicMove(AtomicMove aMove) {
        aMove.historyHash = this.currentHash = this.getCurrentStoragePattern().hashCode();
        this.atomicMoveHistory.newIteration(aMove);
        this.accessHashHistory.newIteration(aMove.toSmallString());
        AtomicMove addSuccessors = this.followersHistory.newIteration(aMove);
        if (addSuccessors != null) {
            StringBuffer aBuf = new StringBuffer(40);
            for (AtomicMove successor : this.followersHistory) {
                aBuf.append(successor.toSmallString());
                aBuf.append("-");
            }
            addSuccessors.futureHash = aBuf.toString().hashCode();
        }
    }

    private String getCurrentStoragePattern() {
        StringBuffer aBuf = new StringBuffer(7);
        for (String moveHash : this.accessHashHistory) {
            aBuf.append(moveHash);
            aBuf.append("-");
        }
        return aBuf.toString();
    }

    public String createOccurenceKey(int p, int f) {
        return p + "-" + f;
    }

    public SortedSet<PatternOccurence> getCurrentMatchingPatternOccurences() {
        int historySize = this.atomicMoveHistory.size();
        int searchHash = this.getCurrentStoragePattern().hashCode();
        PatternOccurence occurence = null;
        HashMap<String, PatternOccurence> patternOccurences = new HashMap<String, PatternOccurence>();
        Iterator<AtomicMove> historicMoves = this.atomicMoveHistory.iterator();
        int i = 0;
        while (i < historySize - 40) {
            AtomicMove move = historicMoves.next();
            if (move.historyHash == searchHash) {
                String searchKey = this.createOccurenceKey(move.historyHash, move.futureHash);
                occurence = (PatternOccurence)patternOccurences.get(searchKey);
                if (occurence != null) {
                    ++occurence.occurenceCount;
                    occurence.indexOfOccurence = i;
                } else {
                    occurence = new PatternOccurence();
                    occurence.searchPattern = move.historyHash;
                    occurence.followers = move.futureHash;
                    occurence.indexOfOccurence = i;
                    occurence.occurenceCount = 1;
                    patternOccurences.put(occurence.getKey(), occurence);
                }
            }
            ++i;
        }
        if (occurence == null) {
            this.proud.log("atomic move not found in history");
            return null;
        }
        TreeSet<PatternOccurence> sortedOccurences = new TreeSet<PatternOccurence>();
        sortedOccurences.addAll(patternOccurences.values());
        return sortedOccurences;
    }

    public void newRound(LoudAndProud proud) {
        this.proud = proud;
    }

    public ListIterator<AtomicMove> getItemsBeginningAt(int index) {
        return this.atomicMoveHistory.getItemsBeginningAt(index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PatternOccurence
    implements Comparable<PatternOccurence> {
        int searchPattern;
        int followers;
        int occurenceCount;
        public int indexOfOccurence;

        public String getKey() {
            return PatternBase.this.createOccurenceKey(this.searchPattern, this.followers);
        }

        @Override
        public int compareTo(PatternOccurence o) {
            return this.occurenceCount < o.occurenceCount ? 1 : -1;
        }
    }
}

