/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.utils;

import alk.lap.LoudAndProud;

public class DVektor {
    public double x = 0.0;
    public double y = 0.0;

    public DVektor() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public DVektor(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setXY(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getDirection() {
        return Math.toDegrees(Math.atan2(this.x, this.y));
    }

    public String toString() {
        return "(x=" + LoudAndProud.printStaticDouble(this.x) + ",y=" + LoudAndProud.printStaticDouble(this.y) + ")";
    }

    public static DVektor scaleVector(DVektor vek, double faktor) {
        return new DVektor(vek.x * faktor, vek.y * faktor);
    }

    public static DVektor add(DVektor vektor, DVektor vektor2) {
        return new DVektor(vektor.x + vektor2.x, vektor.y + vektor2.y);
    }

    public static DVektor sub(DVektor a, DVektor b) {
        return new DVektor(a.x - b.x, a.y - b.y);
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static boolean isInRectangle(DVektor aPosition, double x1, double y1, double x2, double y2) {
        return aPosition.x > x1 && aPosition.x < x2 && aPosition.y > y1 && aPosition.y < y2;
    }

    public int getIntX() {
        return new Double(this.x).intValue();
    }

    public int getIntY() {
        return new Double(this.y).intValue();
    }

    public DVektor copy() {
        return new DVektor(this.x, this.y);
    }

    public double getDistanceTo(DVektor p) {
        return DVektor.sub(p, this).getLength();
    }

    public double getDirectionTo(DVektor p) {
        return DVektor.sub(p, this).getDirection();
    }

    public void rotate(DVektor center, double rotationInDegree) {
        double dx = this.x - center.x;
        double dy = this.y - center.y;
        double rotationInRad = Math.toRadians(rotationInDegree);
        double cosRot = Math.cos(rotationInRad);
        double sinRot = Math.sin(rotationInRad);
        this.x = dx * cosRot - dy * sinRot + center.x;
        this.y = dx * sinRot + dy * cosRot + center.y;
    }

    public void rotate(double beamAngle) {
        this.rotate(new DVektor(), beamAngle);
    }

    public static DVektor fromPolarCoord(double angle, double length) {
        double angleInRad = Math.toRadians(angle);
        return new DVektor(length * Math.sin(angleInRad), length * Math.cos(angleInRad));
    }

    public void add(DVektor vec) {
        this.x += vec.x;
        this.y += vec.y;
    }

    public void sub(DVektor vec) {
        this.x -= vec.x;
        this.y -= vec.y;
    }

    public void scale(double factor) {
        this.x *= factor;
        this.y *= factor;
    }
}

