/*
 * Decompiled with CFR 0.152.
 */
package amk.guns;

import amk.util.Gun;
import amk.util.Point2d;
import amk.util.Utils;
import amk.util.Vector2d;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class Linear
extends Gun {
    String name = "DadsGun";
    String version = "0.1";
    AdvancedRobot master;

    public Linear(AdvancedRobot bot) {
        this.master = bot;
    }

    public void prepare(ScannedRobotEvent e) {
        double targetingAngle = this.getTargetingAngle(e);
        this.master.setTurnGunRightRadians(targetingAngle);
    }

    public double getTargetingAngle(ScannedRobotEvent e) {
        double hd = this.master.getHeadingRadians();
        double gunHd = this.master.getGunHeadingRadians();
        double botBr = e.getBearingRadians();
        double angleToTarget = Utils.normalizeAngleRadians(hd + botBr);
        double currentAngle = Utils.bestAngle(angleToTarget - gunHd);
        int timeToAngle = (int)Math.ceil(Math.abs(currentAngle / Utils.GUN_ROT_VEL));
        Point2d location = new Point2d(this.master.getX(), this.master.getY());
        Vector2d velocity = new Vector2d(Math.sin(hd) * this.master.getVelocity(), Math.cos(hd) * this.master.getVelocity());
        Vector2d targetVector = new Vector2d(Math.sin(angleToTarget) * e.getDistance(), Math.cos(angleToTarget) * e.getDistance());
        Point2d targetLocation = new Point2d(location);
        targetLocation.applyForce(targetVector);
        Vector2d targetVelocity = new Vector2d(Math.sin(e.getHeadingRadians()) * e.getVelocity(), Math.cos(e.getHeadingRadians()) * e.getVelocity());
        for (int x = 0; x < timeToAngle; ++x) {
            velocity.rotate(Utils.BOT_ROT_VEL);
            location.applyForce(velocity);
        }
        targetVelocity.scale(timeToAngle);
        targetLocation.applyForce(targetVelocity);
        double distance = location.distance(targetLocation);
        currentAngle = Utils.bestAngle(Math.atan2(targetLocation.x - location.x, targetLocation.y - location.y) - gunHd);
        return currentAngle;
    }
}

