/*
 * Decompiled with CFR 0.152.
 */
package rdt.Guns;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import rdt.AgentSmith.AgentSmith;
import rdt.Guns.FriendlyWaveTargetInterface;
import rdt.Guns.GunVirtualGunTargetInterface;
import rdt.RobotData.RobotData;
import rdt.SubsystemMode;
import rdt.Targeting.Targeting;
import rdt.VirtualGuns.Guns.DC.Segmentation;
import rdt.VirtualGuns.Guns.DC.VirtualGunDC;
import rdt.VirtualGuns.VirtualGunStats;
import rdt.VirtualGuns.VirtualGuns;
import rdt.VirtualGuns.VirtualGunsFiringData;
import rdt.Waves.WaveData;
import rdt.Waves.WaveManager;
import robocode.BulletHitBulletEvent;
import robocode.util.Utils;

public class GunVirtualGunArrayMode
extends SubsystemMode {
    private long _nextFireTurn = 0L;
    private double _nextFirePower = 0.0;
    private double _targetFiringAngle = 0.0;
    private WaveManager _waveManager = null;
    private VirtualGuns _virtualGuns = null;
    private VirtualGunsFiringData _latestFiringData = null;

    public GunVirtualGunArrayMode() {
        this.Initialise("Virtual Gun Array");
        this._waveManager = new WaveManager(new FriendlyWaveTargetInterface(), 200, Color.green);
        ArrayList<Segmentation.eSegmentation> segmentationList = new ArrayList<Segmentation.eSegmentation>();
        segmentationList.add(Segmentation.eSegmentation.Distance);
        segmentationList.add(Segmentation.eSegmentation.LateralVelocity);
        segmentationList.add(Segmentation.eSegmentation.AdvancingVelocity);
        segmentationList.add(Segmentation.eSegmentation.Acceleration);
        segmentationList.add(Segmentation.eSegmentation.TimeSinceDirectionChange);
        segmentationList.add(Segmentation.eSegmentation.TimeSinceDeceleration);
        segmentationList.add(Segmentation.eSegmentation.TotalTicks);
        segmentationList.add(Segmentation.eSegmentation.DistanceLast10);
        segmentationList.add(Segmentation.eSegmentation.DistanceToWallAhead);
        segmentationList.add(Segmentation.eSegmentation.DistanceToWallBehind);
        this._virtualGuns = new VirtualGuns("Guns", 450, 15, this._waveManager, new GunVirtualGunTargetInterface(), 1.0, 0.01, true);
        this._virtualGuns.AddVirtualGun(new VirtualGunDC(50, segmentationList, 1.0, 0.01, true, false));
        this._virtualGuns.AddVirtualGun(new VirtualGunDC(100, segmentationList, 1.0, 0.01, true, false));
    }

    @Override
    public void UpdateHighestPriority() {
        RobotData currentTarget = Targeting.GetCurrentTarget();
        if (currentTarget == null || !currentTarget.Valid || currentTarget.NumSnapshots < 5 || currentTarget.Dead) {
            return;
        }
        this._nextFirePower = AgentSmith.Energy.GetFirepower();
        if (this._nextFirePower <= 0.0) {
            return;
        }
        if (this._latestFiringData != null && this._nextFireTurn == AgentSmith.Instance().getTime() && AgentSmith.Instance().getGunTurnRemaining() == 0.0 && AgentSmith.Instance().getGunHeat() <= 0.0) {
            VirtualGunsFiringData actualFiringData = this._latestFiringData.Clone();
            actualFiringData.TickFired = AgentSmith.Instance().getTime();
            this._waveManager.AddWave(this._latestFiringData, WaveData.eWaveType.Real);
            AgentSmith.Instance().setFire(this._nextFirePower);
            return;
        }
        this.UpdateFiringData(this._nextFirePower);
        if (this._latestFiringData == null) {
            return;
        }
        this._waveManager.AddWave(this._latestFiringData, WaveData.eWaveType.Virtual);
        AgentSmith.Instance().setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this._targetFiringAngle - AgentSmith.Instance().getGunHeadingRadians())));
        this._nextFireTurn = AgentSmith.Instance().getTime() + 1L;
    }

    private void UpdateFiringData(double firepower) {
        RobotData currentTarget = Targeting.GetCurrentTarget();
        if (currentTarget == null || !currentTarget.Valid || AgentSmith.Instance().getEnergy() <= 0.0) {
            return;
        }
        int numVirtualGuns = this._virtualGuns.GetNumVirtualGuns();
        int chosenGunIndex = -1;
        double bestVal = -1.0;
        int gunIndex = 0;
        while (gunIndex < numVirtualGuns) {
            VirtualGunStats stats = this._virtualGuns.GetGunStats(gunIndex);
            double val = stats.GetRollingHitPercent();
            if (val > bestVal) {
                bestVal = val;
                chosenGunIndex = gunIndex;
            }
            ++gunIndex;
        }
        if (chosenGunIndex >= 0) {
            this._latestFiringData = this._virtualGuns.GetFiringData(firepower);
            this._latestFiringData.ChosenGunIndex = chosenGunIndex;
            this._targetFiringAngle = this._latestFiringData.GunFiringData.get((int)chosenGunIndex).FiringAbsoluteAngles.get(0);
        } else {
            this._latestFiringData = null;
        }
    }

    @Override
    public float GetPriority() {
        RobotData currentTarget = Targeting.GetCurrentTarget();
        if (currentTarget == null) {
            return 0.0f;
        }
        if (!currentTarget.Valid) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public void Shutdown() {
    }

    @Override
    public void Update() {
        RobotData currentTarget = Targeting.GetCurrentTarget();
        if (currentTarget == null || !currentTarget.Valid || currentTarget.NumSnapshots < 2) {
            return;
        }
        this._waveManager.Update();
        this._virtualGuns.Update();
    }

    @Override
    public void OnRoundStart() {
        this._nextFireTurn = 0L;
        this._nextFirePower = 0.0;
        this._latestFiringData = null;
        this._waveManager.ClearWaves();
    }

    @Override
    public void OnBulletHitBulletEvent(BulletHitBulletEvent event) {
        this._virtualGuns.OnBulletHitBullet(event.getBullet().getX(), event.getBullet().getY());
    }

    @Override
    public void DebugDraw(Graphics2D gfx) {
        this._waveManager.DebugDraw(gfx);
        this._virtualGuns.DebugDraw(gfx);
    }

    public WaveManager GetWaveManager() {
        return this._waveManager;
    }
}

