/*
 * Decompiled with CFR 0.152.
 */
package jbot;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jbot.Rabbit2;

public class Inherit {
    private Rabbit2 mBot;
    private static Header mHeader = new Header("");
    private boolean mIsLoaded = false;
    private boolean mIsSetup = false;
    boolean mCanSave = true;

    public Inherit(Rabbit2 bot) {
        this.mBot = bot;
    }

    public boolean isLoaded() {
        return this.mIsLoaded;
    }

    public boolean isSetup() {
        return this.mIsSetup;
    }

    public int getAge() {
        return Inherit.mHeader.mAge;
    }

    public long getTime() {
        return Inherit.mHeader.mTotalTime;
    }

    public String getEnemyName() {
        return Inherit.mHeader.mEnemyName;
    }

    public boolean containsObjects() {
        return !Inherit.mHeader.mContainersList.isEmpty();
    }

    public boolean addContainer(Container in) {
        if (!this.mIsSetup) {
            this.mBot.out.println("Inherit: addObject() - aby mozliwe bylo dodanie obiektu nalezy najpierw wywolac loadData()");
            return false;
        }
        if (in == null) {
            return false;
        }
        Container c = null;
        ListIterator<Container> i = Inherit.mHeader.mContainersList.listIterator(0);
        while (i.hasNext()) {
            c = i.next();
            if (c.getObjectName().compareTo(in.getObjectName()) != 0) continue;
            i.remove();
            break;
        }
        Inherit.mHeader.mContainersList.add(in);
        return true;
    }

    public Container getContainerOf(Class cls) {
        if (!this.mIsSetup) {
            this.mBot.out.println("Inherit: getObject() - aby mozliwe bylo pobranie obiektu nalezy najpierw wywolac loadData()");
            return null;
        }
        Container out = null;
        for (Container obj : Inherit.mHeader.mContainersList) {
            if (!cls.isInstance(obj)) continue;
            return obj;
        }
        return out;
    }

    public Container getContainerBy(String name) {
        if (!this.mIsSetup) {
            this.mBot.out.println("Inherit: getObject() - aby mozliwe bylo pobranie obiektu nalezy najpierw wywolac loadData()");
            return null;
        }
        Container out = null;
        for (Container obj : Inherit.mHeader.mContainersList) {
            if (obj.getObjectName().compareTo(name) != 0) continue;
            return obj;
        }
        return out;
    }

    public boolean setupProfile(String newEnemyName) {
        if (this.mIsLoaded) {
            this.mBot.out.println("Inherit: setupProfile() wywolane niepotrzebnie, dane juz zaladowane!");
            return false;
        }
        try {
            if (mHeader == null || Inherit.mHeader.mEnemyName.compareTo(newEnemyName) != 0) {
                throw new Exception();
            }
        }
        catch (Exception e1) {
            this.mBot.out.println("Inherit: utworzony nowy profil dla: " + newEnemyName);
            mHeader = new Header(newEnemyName);
            this.mIsSetup = true;
            return true;
        }
        ++Inherit.mHeader.mAge;
        this.mIsLoaded = true;
        this.mIsSetup = true;
        this.mBot.out.println("Inherit: zaladowano profil dla: " + Inherit.mHeader.mEnemyName + " (" + Inherit.mHeader.mAge + " ladowanie, czas z " + Inherit.mHeader.mTotalTime + " klatek)");
        return true;
    }

    public boolean saveProfile() {
        Inherit.mHeader.mTotalTime += this.mBot.getTime();
        try {
            if (!this.mCanSave) {
                mHeader = null;
                this.mIsSetup = false;
                this.mIsLoaded = false;
                this.mBot.out.println("\nInherit: usunieto profil");
            }
            this.mBot.out.println("\nInherit: profil przeciwnika zapisany do pliku!");
        }
        catch (Exception e) {
            this.mBot.out.println("Inherit: nie udalo sie zapsiac profilu przeciwnika: " + e.getMessage());
            return false;
        }
        return true;
    }

    public void setDoNotSave(boolean save) {
        this.mCanSave = !save;
        this.mBot.out.println("\nInherit: informacje z tej tury nie zostana zapisane");
    }

    public static abstract class Container
    implements Serializable {
        private static final long serialVersionUID = -5556614958452011265L;
        protected final String mObjectName;

        protected Container(String name) {
            this.mObjectName = name;
        }

        public String getObjectName() {
            return this.mObjectName;
        }
    }

    public static class Header
    implements Serializable {
        private static final long serialVersionUID = 3483931133285978698L;
        protected int mAge = 0;
        protected long mTotalTime = 0L;
        protected String mEnemyName;
        protected List<Container> mContainersList;

        Header(String enemyName) {
            this.mEnemyName = enemyName;
            this.mContainersList = new LinkedList<Container>();
        }
    }
}

