/*
 * Decompiled with CFR 0.152.
 */
package jbot.tracer.techniques;

import java.awt.Color;
import java.util.Random;
import jbot.Rabbit2;
import jbot.tracer.Ray;
import jbot.tracer.Target;
import jbot.tracer.Wave;
import jbot.tracer.techniques.TracerTechnique;
import jbot.util.MathUtil;
import jbot.util.Vector2;
import robocode.Rules;

public class ModulatedAvgTechnique
extends TracerTechnique {
    static final int AVG_VEL_COUNT_DELTA = 15;
    static final int AVG_VEL_RANDOM_RANGE = 8;
    static final int AVG_VEL_REWARD = 10;
    static final int AVG_MAX_COUNT = 185;
    static final int AVG_MIN_COUNT = 15;
    static final int AVG_COUNT = 1;
    static final int AVG_LONGER = 0;
    static final int AVG_SHORTER = 2;
    int mAvgVelCount = 20;
    double[] mAvgVel = new double[3];
    Random mRandom = new Random();
    Vector2[] estimPoss;
    long recentEstimateTime = -1L;

    public ModulatedAvgTechnique(String techName, Rabbit2 rabbit, Target self, Target target, double initialEfficient, double learnFactor) {
        super(techName, rabbit, self, target, initialEfficient, learnFactor);
        this.mColor = Color.YELLOW;
        this.mAvgVel[0] = 0.0;
        this.mAvgVel[1] = 0.0;
        this.mAvgVel[2] = 0.0;
    }

    int normalAvgCount(int count) {
        if (count < 15) {
            count = 15;
        } else if (count > 185) {
            count = 185;
        }
        return count;
    }

    public void addEstimatedRay(Wave w) {
        this.estimateTargetPositions(w.getShotTime(), w.getShotPos(), w.getSpeed());
        Target.Data self = this.mSelf.getHistoryAt(w.getShotTime());
        int i = 0;
        while (i < 3) {
            this.estimPoss[i].sub(self.getPosition()).normalize();
            ++i;
        }
        w.addRay(new RayEx(this, this.estimPoss[1], this.getHitProbability(w.getDistToTarget()), this.estimPoss[2], this.estimPoss[0]));
    }

    public double getShotAngleFor(long shootTime, Vector2 shootPos, double shootPower) {
        double bulletSpeed = Rules.getBulletSpeed((double)shootPower);
        this.estimateTargetPositions(shootTime, shootPos, bulletSpeed);
        return this.estimPoss[1].getAngle();
    }

    public void estimateTargetPositions(long shootTime, Vector2 shootPos, double shootSpeed) {
        if (this.recentEstimateTime == this.getRecentTime()) {
            return;
        }
        this.recentEstimateTime = this.getRecentTime();
        Target.Data target = this.mTarget.getHistoryAt(shootTime);
        this.mAvgVel[0] = 0.0;
        this.mAvgVel[1] = 0.0;
        this.mAvgVel[2] = 0.0;
        int olderCount = 0;
        int currCount = 0;
        int newerCount = 0;
        long olderTime = shootTime - (long)this.mAvgVelCount - 15L + 1L + (long)this.mRandom.nextInt(8);
        long newerTime = shootTime - (long)this.mAvgVelCount + 15L - 1L + (long)this.mRandom.nextInt(8);
        for (Target.Data h : this.mTarget.getHistory()) {
            if (h.getTime() > shootTime || h.getTime() < olderTime) continue;
            this.mAvgVel[0] = this.mAvgVel[0] + h.getSpeed();
            ++olderCount;
            if (h.getTime() < (long)this.mAvgVelCount) continue;
            this.mAvgVel[1] = this.mAvgVel[1] + h.getSpeed();
            ++currCount;
            if (h.getTime() < newerTime) continue;
            this.mAvgVel[2] = this.mAvgVel[2] + h.getSpeed();
            ++newerCount;
        }
        if (this.mTarget.getHistorySize() != 0) {
            if (olderCount > 0) {
                this.mAvgVel[0] = this.mAvgVel[0] / (double)olderCount;
            }
            if (currCount > 0) {
                this.mAvgVel[1] = this.mAvgVel[1] / (double)currCount;
            }
            if (newerCount > 0) {
                this.mAvgVel[2] = this.mAvgVel[2] / (double)newerCount;
            }
        }
        double v = this.mAvgVel[1];
        double a = target.getDirectionAngle();
        double w = target.getAngleSpeed();
        Vector2 dir = new Vector2(a);
        Vector2 distance = target.getPosition().sub(shootPos);
        this.mEstimatedPath.clear();
        int t = 0;
        do {
            ++t;
            dir.rotate(w);
            if (MathUtil.cmp(v, 0.0) != 0) {
                Vector2 offset = dir.clone().multiply(v);
                distance.add(offset);
            }
            this.mEstimatedPath.add(distance.clone().add(shootPos));
        } while (!(distance.getLength() / shootSpeed > (double)t - 1.0 && distance.getLength() / shootSpeed < (double)t + 1.0) && t <= 40);
        distance.add(shootPos);
        Vector2 s = distance.clone().sub(target.getPosition());
        double avg_newer_mul = MathUtil.cmp(this.mAvgVel[1], 0.0) == 0 ? 0.0 : this.mAvgVel[2] / this.mAvgVel[1];
        double avg_older_mul = MathUtil.cmp(this.mAvgVel[1], 0.0) == 0 ? 0.0 : this.mAvgVel[0] / this.mAvgVel[1];
        Vector2[] positions = new Vector2[3];
        positions[1] = distance;
        positions[2] = s.clone().multiply(avg_newer_mul);
        positions[0] = s.clone().multiply(avg_older_mul);
        positions[2].add(target.getPosition());
        positions[0].add(target.getPosition());
        this.estimPoss = (Vector2[])positions.clone();
    }

    public String prepareLogString() {
        String log = "\n Avg Velocity Count = " + this.mAvgVelCount + "\n Avg Velocity = " + this.mAvgVel[1];
        return log;
    }

    public void selfLearn(Wave w, Ray r, double aimError) {
        RayEx rex = (RayEx)r;
        double[] distances = new double[3];
        distances[1] = rex.getDirection().multiply(w.getTraveledDistance()).add(w.getShotPos()).sub(this.mTarget.getPosition()).getLength();
        distances[2] = rex.mDirAvgShorter.clone().multiply(w.getTraveledDistance()).add(w.getShotPos()).sub(this.mTarget.getPosition()).getLength();
        distances[0] = rex.mDirAvgLonger.clone().multiply(w.getTraveledDistance()).add(w.getShotPos()).sub(this.mTarget.getPosition()).getLength();
        if (distances[2] < distances[1] && distances[2] < distances[0]) {
            this.mAvgVelCount = this.normalAvgCount(this.mAvgVelCount - 10);
        } else if (distances[0] <= distances[1]) {
            this.mAvgVelCount = this.normalAvgCount(this.mAvgVelCount + 10);
        }
    }

    public class RayEx
    extends Ray {
        Vector2 mDirAvgShorter;
        Vector2 mDirAvgLonger;

        public RayEx(TracerTechnique technique, Vector2 direction, double distance, Vector2 dirAvgShorter, Vector2 dirAvgLonger) {
            super(technique, direction, distance);
            this.mDirAvgShorter = dirAvgShorter;
            this.mDirAvgLonger = dirAvgLonger;
        }
    }
}

