/*
 * Decompiled with CFR 0.152.
 */
package jbot.util;

import jbot.util.Vector2;

public class MathUtil {
    public static final double PI = Math.PI;
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double QUART_PI = 0.7853981633974483;
    public static final double CMP_DOUBLE_PREC = 1.0E-7;

    public static double radiansToDegrees(double radians) {
        return radians * 180.0 / Math.PI;
    }

    public static double degreesToRadians(double degrees) {
        return degrees / 180.0 * Math.PI;
    }

    public static int cmp(double a, double b) {
        if (a < b - 1.0E-7) {
            return -1;
        }
        if (a > b + 1.0E-7) {
            return 1;
        }
        return 0;
    }

    public static boolean isGreather(double a, double b) {
        return a > b + 1.0E-7;
    }

    public static boolean isLess(double a, double b) {
        return a < b - 1.0E-7;
    }

    public static Vector2 radiansToDirection(double radians) {
        return new Vector2(Math.sin(radians), Math.cos(radians));
    }

    public static int sign(double a) {
        return a > 0.0 ? 1 : -1;
    }

    public static double trunc(double val, double min, double max) {
        if (val > max) {
            return max;
        }
        if (val < min) {
            return min;
        }
        return val;
    }
}

