/*
 * Decompiled with CFR 0.152.
 */
package zzx;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Serunyr
extends AdvancedRobot {
    int moveDirection = -1;
    double previousEnergy = 100.0;
    boolean radarLock;
    public double wallStick = 180.0;
    static double bulletPower;
    static double fieldXMid;
    static double fieldYMid;
    double cornerX;
    double cornerY;
    double dist = 1000.0;
    static double turn;
    boolean inCorner;

    public void run() {
        bulletPower = 2.0;
        this.setColors(Color.yellow, Color.darkGray, Color.yellow, Color.yellow, Color.black);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRight(360.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absoluteBearing = e.getBearingRadians() + this.getHeadingRadians();
        double latVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing);
        if (this.getOthers() > 1) {
            double gunTurn = Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians())) + latVel / 15.0;
            if (this.getGunHeat() == 0.0) {
                this.setTurnGunRightRadians(gunTurn);
                this.fire(e.getEnergy() / 4.0);
                this.radarLock = false;
            } else {
                this.radarLock = true;
                this.setTurnGunRightRadians(gunTurn);
            }
            if (this.radarLock) {
                this.setTurnRadarRightRadians(36.6 * Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
                this.setTurnGunRightRadians(gunTurn);
            }
            this.cornerMovement(e);
        } else {
            this.fire(e.getEnergy() / 4.0);
            if (this.getTime() % 31L == 0L) {
                this.moveDirection *= -1;
            }
            if (e.getEnergy() < 5.0) {
                bulletPower = 1.3;
            }
            if (e.getVelocity() == 0.0) {
                bulletPower = 3.0;
            }
            if (this.getEnergy() < bulletPower) {
                bulletPower = 0.0;
            }
            this.setTurnRadarRightRadians(2.5 * Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
            double gunTurn = Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians() + Math.asin(latVel / (20.0 - 3.0 * bulletPower))));
            this.setTurnGunRightRadians(gunTurn);
            this.cornerMovement(e);
        }
    }

    public void cornerMovement(ScannedRobotEvent e) {
        double goalDirection;
        if (this.getTime() % 31L == 0L) {
            this.moveDirection *= -1;
            this.inCorner = false;
        }
        if (this.getX() < this.getBattleFieldWidth() * 0.2 && this.getY() < this.getBattleFieldHeight() * 0.2) {
            this.inCorner = true;
        } else {
            if (this.inCorner) {
                this.moveDirection *= -1;
                this.out.println("stay in corner!");
            }
            goalDirection = e.getBearing() - 90.0 - (double)(30 * this.moveDirection);
            this.setTurnRightRadians(this.getWallSmoothedTurn(Math.toRadians(goalDirection)));
            this.setAhead(100 * this.moveDirection);
        }
        if (this.getX() < this.getBattleFieldWidth() * 0.2 && this.getY() > this.getBattleFieldHeight() * 0.8) {
            this.inCorner = true;
        } else {
            if (this.inCorner) {
                this.moveDirection *= -1;
                this.out.println("stay in corner!");
            }
            goalDirection = e.getBearing() - 90.0 - (double)(30 * this.moveDirection);
            this.setTurnRightRadians(this.getWallSmoothedTurn(Math.toRadians(goalDirection)));
            this.setAhead(100 * this.moveDirection);
        }
        if (this.getX() > this.getBattleFieldWidth() * 0.8 && this.getY() > this.getBattleFieldHeight() * 0.8) {
            this.inCorner = true;
        } else {
            if (this.inCorner) {
                this.moveDirection *= -1;
                this.out.println("stay in corner!");
            }
            this.setAhead(100 * this.moveDirection);
            goalDirection = e.getBearing() - 90.0 - (double)(30 * this.moveDirection);
            this.setTurnRightRadians(this.getWallSmoothedTurn(Math.toRadians(goalDirection)));
        }
        if (this.getX() > this.getBattleFieldWidth() * 0.8 && this.getY() < this.getBattleFieldHeight() * 0.2) {
            this.inCorner = true;
        } else {
            if (this.inCorner) {
                this.moveDirection *= -1;
                this.out.println("stay in corner!");
            }
            this.setAhead(100 * this.moveDirection);
            goalDirection = e.getBearing() - 90.0 - (double)(30 * this.moveDirection);
            this.setTurnRightRadians(this.getWallSmoothedTurn(Math.toRadians(goalDirection)));
        }
        double changeInEnergy = this.previousEnergy - e.getEnergy();
        if (changeInEnergy > 0.0 && changeInEnergy <= 3.0) {
            this.setAhead(5 * this.moveDirection);
            this.inCorner = false;
        }
    }

    public void doOneVerseOneMovement(ScannedRobotEvent e) {
        double changeInEnergy;
        if (Math.random() > 0.96) {
            this.moveDirection *= -1;
        }
        double totalBearing = e.getBearing();
        if (this.moveDirection == -1) {
            totalBearing += 180.0;
        }
        if (totalBearing > 360.0) {
            totalBearing -= 360.0;
        }
        if (totalBearing < 45.0) {
            this.moveDirection *= -1;
        }
        if ((changeInEnergy = this.previousEnergy - e.getEnergy()) > 0.0) {
            this.moveDirection *= -1;
            this.setTurnRight(90 * this.moveDirection);
        }
        this.fire(e.getEnergy() / 4.0);
        Graphics2D g = this.getGraphics();
        g.setColor(Color.white);
        if (changeInEnergy > 0.0) {
            double targetPlaceX = this.targetX(e);
            double targetPlaceY = this.targetY(e);
            g.drawRect((int)targetPlaceX, (int)targetPlaceY, 36, 36);
            double theta = Math.toDegrees(Math.atan2(targetPlaceX, targetPlaceY));
            Rectangle2D.Double battleField = new Rectangle2D.Double(50.0, 50.0, this.getBattleFieldWidth() - 100.0, this.getBattleFieldHeight() - 100.0);
            if (battleField.contains(targetPlaceX, targetPlaceY)) {
                this.setTurnRight(Utils.normalRelativeAngleDegrees((double)(theta - this.getHeading())));
                this.setAhead(180 * this.moveDirection);
            }
        }
        this.previousEnergy = e.getEnergy();
    }

    public double targetX(ScannedRobotEvent e) {
        double randomX = new Double(Math.random() * this.getBattleFieldWidth());
        return randomX;
    }

    public double targetY(ScannedRobotEvent e) {
        double randomY = new Double(Math.random() * this.getBattleFieldHeight());
        return randomY;
    }

    public double retrieveX(ScannedRobotEvent e) {
        double edir = this.getHeadingRadians() + e.getBearingRadians();
        double X = this.getX() + Math.sin(edir) * e.getDistance();
        return X;
    }

    public double retrieveY(ScannedRobotEvent e) {
        double edir = this.getHeadingRadians() + e.getBearingRadians();
        double Y = this.getY() + Math.cos(edir) * e.getDistance();
        return Y;
    }

    public double getWallSmoothedTurn(double t) {
        double wSD = 20.0;
        double turn = t;
        double predictiveDistance = 100.0;
        double ourHeading = this.getHeadingRadians();
        if (this.moveDirection == -1) {
            ourHeading += Math.PI;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(wSD, wSD, this.getBattleFieldWidth() - 2.0 * wSD, this.getBattleFieldHeight() - 2.0 * wSD);
        while (true) {
            double finishY;
            double totalTurn = turn + ourHeading;
            double dXTravel = Math.sin(totalTurn) * predictiveDistance;
            double dYTravel = Math.cos(totalTurn) * predictiveDistance;
            double finishX = this.getX() + dXTravel;
            if (bounds.contains(finishX, finishY = this.getY() + dYTravel)) {
                return turn;
            }
            turn += 0.4 * (double)this.moveDirection;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.setTurnRight(90 * this.moveDirection);
        this.setAhead(100 * this.moveDirection);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.moveDirection *= -1;
    }

    public void onHitWall(HitWallEvent e) {
        this.moveDirection *= -1;
        this.setAhead(90 * this.moveDirection);
    }
}

