/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.BulletTracking;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.RobotModule;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.Robot;

public class WaveSimulator
extends RobotModule {
    protected Tracking tracking;
    protected Opponent enemy;
    protected int frequency = 5;
    private int frequencyCounter;

    public WaveSimulator(AdvancedRobot advancedRobot, Tracking tracking) {
        super(advancedRobot);
        this.tracking = tracking;
        this.frequencyCounter = this.frequency;
    }

    @Override
    public void init() {
        this.enemy = null;
    }

    @Override
    public void turn() {
        if (this.enemy == null) {
            Object[] objectArray = this.tracking.getTargets();
            if (objectArray.length > 0) {
                this.enemy = (Opponent)objectArray[0];
            }
        } else if (!this.enemy.isDead() && !this.enemy.isMovementBasedOnFiring()) {
            if (this.frequencyCounter <= 0 && this.enemy.getSelfAiming().getPossibleHits().size() < 150) {
                BulletTracking bulletTracking = new BulletTracking(1.8, new Position((Robot)this.robot), this.enemy, this.tracking, this.robot.getTime(), true);
                this.tracking.injectBullet(bulletTracking);
                this.frequencyCounter = this.frequency;
            } else {
                --this.frequencyCounter;
            }
        }
    }
}

