/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.util.Vector;
import shrub.MHTracker;
import shrub.MoveHistory;
import shrub.TargetPData;

public class MultiPData {
    private Vector mTargetList = new Vector();
    private int mNumTargetsInList = 0;
    private int mCurrentTargetIndex = -1;
    private final int mNumTargetsPerGo;
    private final int mMinPeriod;
    private final int mPeriodStep;
    private final int mNumPeriods;
    private double mValueThreshold = 50.0;
    private MHTracker mTrackerRef = null;

    public MultiPData(int numTargetsPerGo, int minPeriod, int periodStep, int numPeriods, double valueThreshold) {
        this.mNumTargetsPerGo = numTargetsPerGo;
        this.mMinPeriod = minPeriod;
        this.mPeriodStep = periodStep;
        this.mNumPeriods = numPeriods;
        this.mValueThreshold = valueThreshold;
    }

    public void SetTrackerRef(MHTracker trackerRef) {
        this.mTrackerRef = trackerRef;
    }

    public void SetValueThreshold(double newValue) {
        this.mValueThreshold = newValue;
        for (int index = 0; index < this.mNumTargetsInList; ++index) {
            TargetPData thisTarget = (TargetPData)this.mTargetList.get(index);
            thisTarget.SetValueThreshold(this.mValueThreshold);
        }
    }

    public void ReportSighting(String targetName) {
        int posn = -1;
        posn = this.FindNamedTarget(targetName);
        if (posn < 0 || posn >= this.mNumTargetsInList) {
            this.AddNewTarget(targetName);
        }
    }

    private final int FindNamedTarget(String searchName) {
        int answer = -1;
        boolean found = false;
        for (int index = 0; !found && index < this.mNumTargetsInList; ++index) {
            TargetPData target = (TargetPData)this.mTargetList.get(index);
            String targetName = target.GetName();
            if (!targetName.equals(searchName)) continue;
            found = true;
            answer = index;
        }
        return answer;
    }

    private void AddNewTarget(String targetName) {
        if (this.mTrackerRef == null) {
            System.out.println("ERROR: null tracker, MultiPData::AddNewTarget");
        } else {
            int index = this.mTrackerRef.FindNamedTarget(targetName);
            MoveHistory targetHistory = this.mTrackerRef.GetHistoryByIndex(index);
            TargetPData newPData = TargetPData.getInstance(targetName, targetHistory, this.mMinPeriod, this.mPeriodStep, this.mNumPeriods, this.mValueThreshold);
            this.mTargetList.add(newPData);
            this.mNumTargetsInList = this.mTargetList.size();
        }
    }

    public void RemoveAll() {
        for (int index = 0; index < this.mNumTargetsInList; ++index) {
            this.RemoveTargetAt(index);
        }
    }

    private void RemoveTargetAt(int index) {
        this.mTargetList.remove(index);
        this.mNumTargetsInList = this.mTargetList.size();
    }

    public final int GetNumTargets() {
        return this.mNumTargetsInList;
    }

    public void ReportRobotDeath(String deathName) {
        int posn = this.FindNamedTarget(deathName);
        if (posn >= 0) {
            this.RemoveTargetAt(posn);
        }
    }

    public final int GetBestPeriodForTarget(String targetName) {
        int bestPeriod = -1;
        int index = this.FindNamedTarget(targetName);
        if (index >= 0 && index < this.mNumTargetsInList) {
            TargetPData pData = (TargetPData)this.mTargetList.get(index);
            bestPeriod = pData.GetBestPeriod();
        }
        return bestPeriod;
    }

    public void DoNextPeriodicityCalcs() {
        for (int count = 0; count < this.mNumTargetsPerGo; ++count) {
            ++this.mCurrentTargetIndex;
            if (this.mCurrentTargetIndex >= this.mNumTargetsInList || this.mCurrentTargetIndex < 0) {
                this.mCurrentTargetIndex = 0;
            }
            if (this.mNumTargetsInList <= 0 || this.mCurrentTargetIndex < 0 || this.mCurrentTargetIndex >= this.mNumTargetsInList) continue;
            TargetPData pData = (TargetPData)this.mTargetList.get(this.mCurrentTargetIndex);
            pData.CalcNextPeriod();
        }
    }

    public void Print() {
        System.out.println("===== MultiPData =====");
        System.out.println("numTargets: " + this.mNumTargetsInList);
    }
}

