/*
 * Decompiled with CFR 0.152.
 */
package kawam;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import kawam.CircularIntercept;
import kawam.Enemy;
import kawam.EnemyManager;
import robocode.Bullet;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.Robot;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.WinEvent;

public class kmBot9
extends TeamRobot {
    final double PI = Math.PI;
    boolean movingForward = true;
    double pEnergy = 100.0;
    double pTime = 0.0;
    double plusAngle = 0.0;
    double plusDistance = 0.0;
    double dD = 70.0;
    int mD = 1;
    int sD = 1;
    EnemyManager eM = EnemyManager.getInstance();
    CircularIntercept intercept = null;
    double bulletPower = 0.0;
    Vector bulletList = new Vector();
    double leftLimit = 0.0;
    double rightLimit = 0.0;
    double bottomLimit = 0.0;
    double upperLimit = 0.0;
    double centerX = 0.0;
    double centerY = 0.0;
    boolean initialMove = false;
    int fireCount = 0;
    Point2D.Double upRight = null;
    Point2D.Double downRight = null;
    Point2D.Double upLeft = null;
    Point2D.Double downLeft = null;
    double cornerRange = 0.0;
    double[] rangeDist = new double[4];

    public void run() {
        this.leftLimit = this.getHeight();
        this.rightLimit = this.getBattleFieldWidth() - this.leftLimit;
        this.bottomLimit = this.leftLimit;
        this.upperLimit = this.getBattleFieldHeight() - this.bottomLimit;
        this.centerX = this.getBattleFieldWidth() / 2.0;
        this.centerY = this.getBattleFieldHeight() / 2.0;
        this.upLeft = new Point2D.Double(0.0, this.getBattleFieldHeight());
        this.downLeft = new Point2D.Double(0.0, 0.0);
        this.upRight = new Point2D.Double(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.downRight = new Point2D.Double(this.getBattleFieldWidth(), 0.0);
        this.cornerRange = this.getBattleFieldHeight() / 3.0;
        this.setColors(Color.black, Color.yellow, Color.yellow);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRight(360.0);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.isTeammate(e.getName())) {
            return;
        }
        this.turnAndGo(e);
        this.bulletPower = 3.0 - Math.min(e.getDistance(), 400.0) / 200.0;
        double distanceDiff = this.doPredict(e);
        if (distanceDiff < 0.1) {
            this.interceptAiming();
        } else {
            this.normalAiming(e);
        }
        this.sD = -this.sD;
        this.setTurnRadarRight(360 * this.sD);
        this.pEnergy = e.getEnergy();
        this.pTime = this.getTime();
    }

    public void turnAndGo(ScannedRobotEvent e) {
        this.rangeDist[0] = this.getRange(this.getX(), this.getY(), this.upRight.x, this.upRight.y);
        this.rangeDist[1] = this.getRange(this.getX(), this.getY(), this.downRight.x, this.downRight.y);
        this.rangeDist[2] = this.getRange(this.getX(), this.getY(), this.upLeft.x, this.upLeft.y);
        this.rangeDist[3] = this.getRange(this.getX(), this.getY(), this.downLeft.x, this.downLeft.y);
        boolean inCorner = false;
        boolean isUp = false;
        int i = 0;
        while (i < 4) {
            if (this.rangeDist[i] < this.cornerRange) {
                inCorner = true;
                if (i == 0 || i == 2) {
                    isUp = true;
                }
            }
            ++i;
        }
        boolean nearHLine = false;
        if (this.getY() < this.bottomLimit || this.getY() > this.upperLimit) {
            nearHLine = true;
            if (this.getY() > this.upperLimit) {
                isUp = true;
            }
        }
        boolean nearVLine = false;
        boolean isLeft = false;
        if (this.getX() < this.leftLimit || this.getX() > this.rightLimit) {
            nearVLine = true;
            if (this.getX() < this.leftLimit) {
                isLeft = true;
            }
        }
        if (inCorner || nearHLine) {
            if (isUp) {
                this.setTurnRight(180.0 - this.getHeading());
            } else {
                this.setTurnLeft(this.normalRelativeAngle(this.getHeading()));
            }
            this.setAhead(100.0);
        } else if (nearVLine) {
            if (isLeft) {
                this.setTurnLeft(this.normalRelativeAngle(this.getHeading() - 90.0));
            } else {
                this.setTurnLeft(this.normalRelativeAngle(this.getHeading() + 90.0));
            }
            this.setAhead(100.0);
        } else {
            double rNumber = (byte)(Math.random() * 10.0);
            rNumber = Math.ceil(rNumber);
            ++this.fireCount;
            if (this.fireCount > 3) {
                this.mD = -this.mD;
                this.fireCount = 0;
            }
            this.setTurnRight(e.getBearing() + 90.0 + this.plusAngle * (double)this.mD);
            double dEnergy = this.pEnergy - e.getEnergy();
            if (dEnergy > 0.0 && dEnergy <= 3.0) {
                this.setAhead((e.getDistance() / 3.0 + this.plusDistance) * (double)this.mD);
            }
        }
    }

    public double doPredict(ScannedRobotEvent e) {
        this.intercept = new CircularIntercept();
        double dTime = (double)this.getTime() - this.pTime;
        double distanceDiff = -1.0;
        double absoluteBearing = (this.getHeading() + e.getBearing()) % 360.0;
        double distance = e.getDistance();
        absoluteBearing = Math.toRadians(absoluteBearing);
        double actualX = this.getX() + Math.sin(absoluteBearing) * distance;
        double actualY = this.getY() + Math.cos(absoluteBearing) * distance;
        if (this.initialMove) {
            double initialDist = this.getRange(this.getX(), this.getY(), actualX, actualY);
            if (initialDist > this.dD) {
                this.goTo(actualX, actualY, (initialDist - this.dD) / 3.0);
            }
            this.initialMove = false;
        }
        this.intercept.calculate(this.getX(), this.getY(), actualX, actualY, e.getHeading(), e.getVelocity(), this.bulletPower, 0.1);
        this.eM.log(e, this.intercept);
        Enemy penemy = this.eM.get(e.getName(), 1);
        Enemy ppenemy = this.eM.get(e.getName(), 2);
        if (penemy != null) {
            double predictedX = penemy.getIntercept().getEstimatedPosition((double)dTime).x;
            double predictedY = penemy.getIntercept().getEstimatedPosition((double)dTime).y;
            distanceDiff = this.getRange(actualX, actualY, predictedX, predictedY);
        }
        if (penemy != null && ppenemy != null) {
            double px = penemy.getIntercept().targetStartingPoint.x;
            double py = penemy.getIntercept().targetStartingPoint.y;
            double ppx = ppenemy.getIntercept().targetStartingPoint.x;
            double ppy = ppenemy.getIntercept().targetStartingPoint.y;
            double predictedX1 = px + (px - ppx);
            double predictedY1 = py + (py - ppy);
            distanceDiff = this.getRange(actualX, actualY, predictedX1, predictedY1);
        }
        ((Robot)this).out.println("diff = " + distanceDiff);
        return distanceDiff;
    }

    public void normalAiming(ScannedRobotEvent e) {
        double direction = this.getHeading() + e.getBearing();
        double velocity = e.getVelocity() * Math.sin(Math.toRadians(e.getHeading() - direction));
        double angle = (direction - this.getGunHeading() + Math.toDegrees(velocity / e.getDistance()) + 720.0) % 360.0;
        this.setTurnGunRight(angle > 180.0 ? angle - 360.0 : angle);
        if (this.getEnergy() >= 0.1) {
            Bullet blt = this.setFireBullet(this.bulletPower);
            this.bulletList.add(blt);
        }
    }

    public void interceptAiming() {
        double turnAngle = this.normalRelativeAngle(this.intercept.bulletHeading_deg - this.getGunHeading());
        this.setTurnGunRight(turnAngle);
        if (Math.abs(turnAngle) <= this.intercept.angleThreshold && this.intercept.impactPoint.x > 0.0 && this.intercept.impactPoint.x < this.getBattleFieldWidth() && this.intercept.impactPoint.y > 0.0 && this.intercept.impactPoint.y < this.getBattleFieldHeight() && this.getEnergy() >= 0.1) {
            Bullet blt = this.setFireBullet(this.bulletPower);
            this.bulletList.add(blt);
        }
    }

    public void onDeath(DeathEvent de) {
        Iterator it = ((AbstractList)this.bulletList).iterator();
        double hitRatio = 0.0;
        int hitCount = 0;
        while (it.hasNext()) {
            Bullet blt = (Bullet)it.next();
            try {
                if (blt.getVictim() == null) continue;
                ++hitCount;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hitRatio = (double)hitCount / (double)this.bulletList.size() * 100.0;
        ((Robot)this).out.println("Bullet total =" + this.bulletList.size() + " Hit Count =" + hitCount + " Hit Ratio =" + Math.round(hitRatio) + "%");
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onWin(WinEvent e) {
        Iterator it = ((AbstractList)this.bulletList).iterator();
        double hitRatio = 0.0;
        int hitCount = 0;
        while (it.hasNext()) {
            Bullet blt = (Bullet)it.next();
            try {
                if (blt.getVictim() == null) continue;
                ++hitCount;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hitRatio = (double)hitCount / (double)this.bulletList.size() * 100.0;
        ((Robot)this).out.println("Bullet total =" + this.bulletList.size() + " Hit Count =" + hitCount + " Hit Ratio =" + Math.round(hitRatio) + "%");
        double dist = this.getRange(this.getX(), this.getY(), this.centerX, this.centerY);
        this.goTo(this.centerX, this.centerY, dist);
        this.turnLeft(this.getHeading());
        this.turnGunLeft(this.getGunHeading());
        while (true) {
            this.ahead(10 * this.mD);
            this.fire(1.0);
            this.mD = -this.mD;
        }
    }

    void goTo(double x, double y, double d) {
        double dist = d;
        double angle = Math.toDegrees(this.absbearing(this.getX(), this.getY(), x, y));
        double r = this.turnTo(angle);
        this.ahead(dist * r);
    }

    int turnTo(double angle) {
        int dir;
        double ang = this.normaliseBearing(this.getHeading() - angle);
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.turnLeft(ang);
        return dir;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    double normalRelativeAngle(double ang) {
        if (ang > 180.0) {
            ang -= 360.0;
        }
        if (ang < -180.0) {
            ang += 360.0;
        }
        return ang;
    }

    public double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }
}

