/*
 * Decompiled with CFR 0.152.
 */
package florent.refactor;

import florent.refactor.AdaptativeVisitRecorder;
import florent.refactor.FUtils;
import florent.refactor.MovementVisitRecorder;
import florent.refactor.VisitRecorder;
import florent.refactor.Wave;
import florent.refactor.WaveManager;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class JumperWave
extends Wave {
    private static final int GF0 = 15;
    private static final int GF1 = 30;
    private static final double[] BULLET_FLIGHT_TIME_SLICES = new double[]{10.0, 20.0, 30.0, 40.0, 50.0, 60.0};
    private static final double[] DISTANCE_SLICES = new double[]{150.0, 300.0, 450.0, 600.0};
    private static final double[] VELOCITY_SLICES = new double[]{1.0, 3.0, 5.0, 7.0};
    private static final double[] WALL_SLICES = new double[]{0.15, 0.35, 0.55, 0.75};
    private static final double[] TIME_SLICES = new double[]{0.1, 0.3, 0.7, 1.2};
    private static final double[] ACCEL_SLICES = new double[]{-0.5, 0.5};
    private static final double[] POWER_SLICES = new double[]{0.65, 1.3, 1.95, 2.6};
    private static final int BUFFERS = 15;
    private static final double[] WEIGHTS = new double[]{5.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.0, 9.0, 8.0, 10.0, 9.0, 0.0, 0.0, 0.0};
    private static double[] rawVisits = new double[31];
    private static double[][][] visitsVelocity = new double[POWER_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private static double[][][] visitsTimer = new double[POWER_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private static double[][][] visitsWall = new double[POWER_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private static double[][][][] visitsDistanceVelocity = new double[POWER_SLICES.length + 1][DISTANCE_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private static double[][][][] visitsWallTimer = new double[POWER_SLICES.length + 1][WALL_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private static double[][][][][] visitsDistanceVelocityWall = new double[POWER_SLICES.length + 1][DISTANCE_SLICES.length + 1][VELOCITY_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private static double[][][] visitsVelocity2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private static double[][][] visitsTimer2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private static double[][][] visitsWall2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private static double[][][][] visitsWallTimer2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][WALL_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private static double[][][][] visitsVelocityWall = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][VELOCITY_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private static double[][][] visitsAccel = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][ACCEL_SLICES.length + 1][31];
    private static double[][][][] visitsAccelVelocity = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][ACCEL_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private static double[][][][] visitsAccelWall = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][ACCEL_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private static double[] rawHits = new double[31];
    private static double[][][] hitsVelocity = new double[POWER_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private static double[][][] hitsTimer = new double[POWER_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private static double[][][] hitsWall = new double[POWER_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private static double[][][][] hitsDistanceVelocity = new double[POWER_SLICES.length + 1][DISTANCE_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private static double[][][][] hitsWallTimer = new double[POWER_SLICES.length + 1][WALL_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private static double[][][][][] hitsDistanceVelocityWall = new double[POWER_SLICES.length + 1][DISTANCE_SLICES.length + 1][VELOCITY_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private static double[][][] hitsVelocity2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private static double[][][] hitsTimer2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private static double[][][] hitsWall2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private static double[][][][] hitsWallTimer2 = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][WALL_SLICES.length + 1][TIME_SLICES.length + 1][31];
    private static double[][][][] hitsVelocityWall = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][VELOCITY_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private static double[][][] hitsAccel = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][ACCEL_SLICES.length + 1][31];
    private static double[][][][] hitsAccelVelocity = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][ACCEL_SLICES.length + 1][VELOCITY_SLICES.length + 1][31];
    private static double[][][][] hitsAccelWall = new double[BULLET_FLIGHT_TIME_SLICES.length + 1][ACCEL_SLICES.length + 1][WALL_SLICES.length + 1][31];
    private static Point2D.Double targetLocation;
    private static Point2D.Double enemyLocation;
    private static AdvancedRobot me;
    private static double myHeading;
    private static WaveManager manager;
    private static Rectangle2D.Double BF;
    private static double lastVelocity;
    private static int timeSinceVChange;
    private static int time;
    private static int hit;
    private static int headOnHit;
    private static int goodHit;
    private int distanceIndex;
    private int velocityIndex;
    private int accelIndex;
    private int wallIndex;
    private int timeIndex;
    private int powerIndex;
    private int bftIndex;
    private int predictedGf;
    private static VisitRecorder hitRecorder;
    private static VisitRecorder recorder;
    private boolean register = true;

    public static void initClass(AdvancedRobot me, WaveManager manager) {
        JumperWave.me = me;
        BF = new Rectangle2D.Double(18.0, 18.0, me.getBattleFieldWidth() - 36.0, me.getBattleFieldHeight() - 36.0);
        targetLocation = new Point2D.Double(me.getX(), me.getY());
        time = (int)me.getTime();
        JumperWave.manager = manager;
        JumperWave.rawHits[15] = 0.05;
        recorder = new MovementVisitRecorder();
        hitRecorder = new AdaptativeVisitRecorder();
    }

    public static void onScannedRobot(ScannedRobotEvent e) {
        enemyLocation = FUtils.projectMotion(targetLocation, me.getHeadingRadians() + e.getBearingRadians(), e.getDistance());
    }

    public void init(Point2D.Double gun, Point2D.Double target, int bearingDirection, double power, double velocity, double absoluteBearing, double fireTime) {
        this.init(gun, target, bearingDirection, power, velocity, absoluteBearing, 2, true, fireTime);
    }

    public void init(Point2D.Double gun, Point2D.Double target, int bearingDirection, double power, double velocity, double absoluteBearing, int offset, boolean register, double fireTime) {
        super.init(gun, target, bearingDirection, power, fireTime);
        this.distanceIndex = FUtils.index(DISTANCE_SLICES, gun.distance(target));
        this.velocityIndex = FUtils.index(VELOCITY_SLICES, Math.abs(velocity * Math.sin(me.getHeadingRadians() - absoluteBearing)));
        this.accelIndex = FUtils.index(ACCEL_SLICES, Math.abs(velocity) - Math.abs(lastVelocity));
        this.wallIndex = FUtils.index(WALL_SLICES, this.wallDistance(1.0, BF));
        this.timeIndex = FUtils.index(TIME_SLICES, (double)timeSinceVChange * 1.0 / this.travelTime(target, fireTime));
        this.bftIndex = FUtils.index(BULLET_FLIGHT_TIME_SLICES, gun.distance(target) / FUtils.bulletVelocity(power));
        this.powerIndex = FUtils.index(POWER_SLICES, power);
        lastVelocity = velocity;
        this.predictedGf = this.mostVisitedIndex();
        this.register = register;
    }

    private void synch() {
        if ((long)time == me.getTime()) {
            return;
        }
        timeSinceVChange = (int)((long)timeSinceVChange + (me.getTime() - (long)time));
        time = (int)me.getTime();
        targetLocation = new Point2D.Double(me.getX(), me.getY());
        if (Math.abs(me.getVelocity() - lastVelocity) > 0.5) {
            timeSinceVChange = 0;
        }
        myHeading = me.getHeadingRadians();
    }

    public boolean test() {
        this.synch();
        if (this.passed(18.0, time, targetLocation) && !this.passed(-18.0, time, targetLocation) && this.register) {
            double gf = this.visitingGf();
            if (me.getOthers() > 0) {
                double[][] buffers = this.visitBuffers();
                int i = 0;
                while (i < 15) {
                    recorder.registerVisit(gf, this.lowGf(gf, this.distance), this.highGf(gf, this.distance), buffers[i]);
                    ++i;
                }
            }
        }
        if (this.passed(-40.0, time, targetLocation)) {
            me.removeCustomEvent((Condition)this);
            manager.remove(this);
        }
        return false;
    }

    protected Point2D.Double getTargetLocation() {
        return targetLocation;
    }

    public double danger(Point2D.Double location) {
        double val = 0.0;
        int index = FUtils.toGF(this.visitingGf(location), rawHits);
        double cHeading = myHeading + FUtils.absoluteBearing(targetLocation, location);
        if (!JumperWave.flattenner()) {
            double i;
            int gf = this.predictedGf;
            if (JumperWave.isHeadOn()) {
                gf = 15;
            }
            if ((i = (double)Math.abs(gf - index)) < Math.ceil(30.0 * (Math.atan(18.0 / location.distance(this.getGunLocation())) / Math.asin(8.0 / this.velocity)))) {
                i /= 4.0;
            } else if (!BF.contains(location)) {
                i = 0.4;
            } else if (Math.abs(FUtils.absoluteBearing(location, enemyLocation) - cHeading) < 0.8975979010256552) {
                i /= 2.0;
            }
            val += 1.0 / i / Math.pow(Math.abs(1.0 + this.distanceToImpact(targetLocation, time) / this.velocity), 0.3);
        } else {
            int i = 1;
            while (i <= 30) {
                val += this.danger(i) / Math.pow(Math.abs(index - i) + 1, 0.5) / Math.pow(Math.abs(1.0 + this.distanceToImpact(targetLocation, time) / this.velocity), 0.5);
                ++i;
            }
        }
        return val;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (me.getOthers() <= 0) {
            return;
        }
        double gf = this.visitingGf(new Point2D.Double(e.getBullet().getX(), e.getBullet().getY()));
        ++hit;
        if (Math.abs(FUtils.toGF(gf, rawHits) - this.predictedGf) < FUtils.toGF(this.halfWidth(this.distance), rawHits) - FUtils.toGF(-this.halfWidth(this.distance), rawHits) + 1) {
            ++goodHit;
        }
        if (Math.abs(FUtils.toGF(gf, rawHits) - 15) < FUtils.toGF(this.halfWidth(this.distance), rawHits) - FUtils.toGF(-this.halfWidth(this.distance), rawHits) + 1) {
            ++headOnHit;
        }
        double[][] buffers = this.hitBuffers();
        int i = 0;
        while (i < 15) {
            this.registerHit(gf, this.lowGf(gf, this.distance), this.highGf(gf, this.distance), buffers[i]);
            ++i;
        }
        System.out.println(this.distanceToImpact(targetLocation, time));
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (me.getOthers() <= 0) {
            return;
        }
        double gf = this.visitingGf(new Point2D.Double(e.getBullet().getX(), e.getBullet().getY()));
        ++hit;
        if (Math.abs(FUtils.toGF(gf, rawHits) - this.predictedGf) < FUtils.toGF(this.halfWidth(this.distance), rawHits) - FUtils.toGF(-this.halfWidth(this.distance), rawHits) + 1) {
            ++goodHit;
        }
        if (Math.abs(FUtils.toGF(gf, rawHits) - 15) < FUtils.toGF(this.halfWidth(this.distance), rawHits) - FUtils.toGF(-this.halfWidth(this.distance), rawHits) + 1) {
            ++headOnHit;
        }
        double[][] buffers = this.hitBuffers();
        int i = 0;
        while (i < 15) {
            this.registerHit(gf, this.lowGf(gf, this.distance), this.highGf(gf, this.distance), buffers[i]);
            ++i;
        }
    }

    private static boolean isHeadOn() {
        return 1.0 * (double)headOnHit / (1.0 * (double)hit) > 0.6;
    }

    private static boolean flattenner() {
        return 1.0 * (double)goodHit / (1.0 * (double)hit) < 0.55;
    }

    private int mostVisitedIndex(double[] gfs, double[] fastGfs) {
        double distance = this.gunLocation.distance(this.startLocation);
        int bestGF = (gfs.length - 1) / 2;
        int GF_ONE = gfs.length - 1;
        double bestVal = 0.0;
        int halfWidth = (int)Math.floor(Math.atan(18.0 / distance) * (double)GF_ONE);
        int gf = GF_ONE;
        while (gf > 0) {
            double tmp = 0.0;
            int i = Math.max(1, gf - halfWidth);
            while (i <= Math.min(gf + halfWidth, GF_ONE)) {
                if ((tmp += gfs[i] + fastGfs[i]) > bestVal) {
                    bestGF = gf;
                    bestVal = tmp;
                }
                ++i;
            }
            --gf;
        }
        return bestGF;
    }

    private int mostVisitedIndex() {
        double distance = this.gunLocation.distance(this.startLocation);
        double[][] buffers = this.hitBuffers();
        int bestGF = 15;
        int GF_ONE = 30;
        double bestVal = 0.0;
        int halfWidth = (int)Math.floor(Math.atan(18.0 / distance) * (double)GF_ONE);
        int gf = GF_ONE;
        while (gf > 0) {
            double tmp = 0.0;
            int i = Math.max(1, gf - halfWidth);
            while (i <= Math.min(gf + halfWidth, GF_ONE)) {
                int j = 0;
                while (j < 15) {
                    tmp += buffers[j][i] * WEIGHTS[j];
                    ++j;
                }
                if (tmp > bestVal) {
                    bestGF = gf;
                    bestVal = tmp;
                }
                ++i;
            }
            --gf;
        }
        return bestGF;
    }

    public static void dump() {
        System.out.println("headOn : " + JumperWave.isHeadOn() + " : " + 1.0 * (double)headOnHit / (1.0 * (double)hit));
        System.out.println("flattener : " + JumperWave.flattenner() + " : " + 1.0 * (double)goodHit / (1.0 * (double)hit));
    }

    protected void registerHit(double gf, double lowGf, double highGf, double[] gfs) {
        hitRecorder.registerVisit(gf, lowGf, highGf, gfs);
    }

    protected double visitingGf(Point2D.Double location) {
        return FUtils.bindToRange(Utils.normalRelativeAngle((double)(Math.atan2(location.x - this.gunLocation.x, location.y - this.gunLocation.y) - Math.atan2(this.startLocation.x - this.gunLocation.x, this.startLocation.y - this.gunLocation.y))) / this.maxEscapeAngle() * (double)this.bearingDirection, -1.0, 1.0);
    }

    private double[][] hitBuffers() {
        double[][] buffers = new double[][]{rawHits, hitsVelocity[this.powerIndex][this.velocityIndex], hitsTimer[this.powerIndex][this.timeIndex], hitsWall[this.powerIndex][this.wallIndex], hitsDistanceVelocity[this.powerIndex][this.distanceIndex][this.velocityIndex], hitsWallTimer[this.powerIndex][this.wallIndex][this.timeIndex], hitsDistanceVelocityWall[this.powerIndex][this.distanceIndex][this.velocityIndex][this.wallIndex], hitsVelocity2[this.bftIndex][this.velocityIndex], hitsTimer2[this.bftIndex][this.timeIndex], hitsWall2[this.bftIndex][this.wallIndex], hitsWallTimer2[this.bftIndex][this.wallIndex][this.timeIndex], hitsVelocityWall[this.bftIndex][this.velocityIndex][this.wallIndex], hitsAccel[this.bftIndex][this.accelIndex], hitsAccelVelocity[this.bftIndex][this.accelIndex][this.velocityIndex], hitsAccelWall[this.bftIndex][this.accelIndex][this.wallIndex]};
        return buffers;
    }

    private double[][] visitBuffers() {
        double[][] buffers = new double[][]{rawVisits, visitsVelocity[this.powerIndex][this.velocityIndex], visitsTimer[this.powerIndex][this.timeIndex], visitsWall[this.powerIndex][this.wallIndex], visitsDistanceVelocity[this.powerIndex][this.distanceIndex][this.velocityIndex], visitsWallTimer[this.powerIndex][this.wallIndex][this.timeIndex], visitsDistanceVelocityWall[this.powerIndex][this.distanceIndex][this.velocityIndex][this.wallIndex], visitsVelocity2[this.bftIndex][this.velocityIndex], visitsTimer2[this.bftIndex][this.timeIndex], visitsWall2[this.bftIndex][this.wallIndex], visitsWallTimer2[this.bftIndex][this.wallIndex][this.timeIndex], visitsVelocityWall[this.bftIndex][this.velocityIndex][this.wallIndex], visitsAccel[this.bftIndex][this.accelIndex], visitsAccelVelocity[this.bftIndex][this.accelIndex][this.velocityIndex], visitsAccelWall[this.bftIndex][this.accelIndex][this.wallIndex]};
        return buffers;
    }

    private double danger(int index) {
        double[][] buffers = this.hitBuffers();
        double[][] buffersVisits = this.visitBuffers();
        double val = 0.0;
        int i = 0;
        while (i < 15) {
            val += (buffers[i][index] + buffersVisits[i][index] / 10.0) * WEIGHTS[i];
            ++i;
        }
        return val;
    }

    protected VisitRecorder getRecorder() {
        return recorder;
    }
}

