/*
 * Decompiled with CFR 0.152.
 */
package florent.refactor;

import florent.refactor.FUtils;
import florent.refactor.JumperWave;
import florent.refactor.ScanExtrapolator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;

public class WaveManager {
    private static final boolean RUMBLE = false;
    private static final boolean MEMENTO = false;
    private ArrayList bullets = new ArrayList(10);
    private ScanExtrapolator extrapolator;
    private AdvancedRobot me;
    private String name = "";
    private double energy;
    private double enemyVelocity;
    private double gunHeat;
    private Point2D.Double enemyLocation;
    private double lastFirePower = 2.0;
    private double lastFireTime;
    private double timeSinceLastFire = 0.0;
    private static double holdingFireDistance = 150.0;
    private static boolean resumeFire = false;
    private Point2D.Double[] myLocation = new Point2D.Double[4];
    private int[] bearingDirection = new int[4];
    private double[] velocity = new double[4];
    private double time;
    private double deltaTime;
    private double lastCollision = -1.0;
    private double lastScan;
    private static int missedScans;
    private static int scans;
    private static int shots;
    private static int hits;
    private ScannedRobotEvent lastScanEvent;
    private double myHeading;
    private Point2D.Double lastLocation;
    public JumperWave lastWave;
    public JumperWave heatWave;

    public void init(AdvancedRobot me) {
        this.me = me;
        this.myLocation[0] = new Point2D.Double(me.getX(), me.getY());
        this.velocity[0] = me.getVelocity();
        this.bearingDirection[0] = 1;
        int i = 1;
        while (i < 4) {
            this.myLocation[i] = this.myLocation[0];
            this.velocity[i] = this.velocity[0];
            this.bearingDirection[i] = this.bearingDirection[0];
            ++i;
        }
        this.gunHeat = me.getGunHeat();
        this.bullets = new ArrayList(10);
        this.heatWave = null;
        JumperWave.initClass(me, this);
        this.lastScan = -1.0;
        this.extrapolator = new ScanExtrapolator(me);
    }

    public JumperWave getClosestWave(Point2D.Double location, double time) {
        JumperWave closestWave = null;
        double bestDistance = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.bullets.size()) {
            JumperWave wave = (JumperWave)((Object)this.bullets.get(i));
            if (Math.abs(wave.distanceToImpact(location, time)) < bestDistance) {
                bestDistance = Math.abs(wave.distanceToImpact(location, time));
                closestWave = wave;
            }
            ++i;
        }
        return closestWave;
    }

    public JumperWave getNearestWave(Point2D.Double location, double time) {
        JumperWave nearestWave = null;
        double bestDistance = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.bullets.size()) {
            JumperWave wave = (JumperWave)((Object)this.bullets.get(i));
            double d = wave.distanceToImpact(location, time);
            if (d < bestDistance && d > 18.0) {
                bestDistance = wave.distanceToImpact(location, time);
                nearestWave = wave;
            }
            ++i;
        }
        return nearestWave;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        ++scans;
        if (this.lastScan > 0.0 && (double)e.getTime() - this.lastScan > 1.0) {
            missedScans = (int)((double)missedScans + ((double)e.getTime() - this.lastScan - 1.0));
        }
        if (this.lastScan > 0.0 && (double)e.getTime() - this.lastScan == 2.0) {
            this.onScannedRobot(this.extrapolator.getScan(this.lastScanEvent, this.myHeading, this.lastLocation, e, this.me.getHeadingRadians(), new Point2D.Double(this.me.getX(), this.me.getY()), this.lastFirePower, this.lastFireTime));
        }
        this.lastScan = e.getTime();
        boolean wallHit = false;
        this.name = e.getName();
        JumperWave.onScannedRobot(e);
        this.gunHeat = 1.0 + this.lastFirePower / 5.0 - this.timeSinceLastFire * this.me.getGunCoolingRate();
        double eDrop = this.energy - e.getEnergy();
        if (e.getVelocity() == 0.0 && Math.abs(this.enemyVelocity) > 2.0 && this.lastCollision != (double)e.getTime()) {
            wallHit = true;
        }
        this.enemyVelocity = e.getVelocity();
        this.energy = e.getEnergy();
        if (eDrop > 0.0 && eDrop <= 3.0) {
            if (wallHit && this.gunHeat > 0.1) {
                System.out.println("false fire detection: gun heat = " + this.gunHeat);
                this.addWave(this.lastFirePower, e, false);
            } else {
                holdingFireDistance = this.isHoldingFire() && this.isSkyClear() && this.energy < 10.0 ? (resumeFire ? Math.max(e.getDistance(), holdingFireDistance) : e.getDistance()) : holdingFireDistance;
                resumeFire = this.isHoldingFire() && this.isSkyClear() && this.energy < 10.0 ? true : resumeFire;
                this.timeSinceLastFire = 0.0;
                this.addWave(eDrop, e, true);
                this.lastFirePower = eDrop;
                this.lastFireTime = e.getTime();
                ++shots;
            }
        } else {
            this.addWave(this.lastFirePower, e, false);
        }
        if (this.gunHeat < this.me.getGunCoolingRate() * 2.0) {
            this.addHeatWave(e);
        }
        this.enemyLocation = FUtils.projectMotion(this.myLocation[0], this.me.getHeadingRadians() + e.getBearingRadians(), e.getDistance());
        this.lastScanEvent = e;
        this.myHeading = this.me.getHeadingRadians();
        this.lastLocation = this.myLocation[0];
    }

    private void addWave(double power, ScannedRobotEvent e, boolean fired) {
        JumperWave wave = new JumperWave();
        if (this.enemyLocation == null) {
            this.enemyLocation = FUtils.projectMotion(this.myLocation[0], this.me.getHeadingRadians() + e.getBearingRadians(), e.getDistance());
        }
        wave.init(this.enemyLocation, this.myLocation[3], this.bearingDirection[3], power, this.velocity[3], FUtils.absoluteBearing(this.enemyLocation, this.myLocation[3]), e.getTime() - 2L);
        if (fired) {
            this.bullets.add(wave);
        }
        this.me.addCustomEvent((Condition)wave);
        double heatTime = (1.0 + this.lastFirePower / 5.0) / this.me.getGunCoolingRate();
        this.lastWave = this.timeSinceLastFire > heatTime && this.timeSinceLastFire % heatTime == 0.0 || this.timeSinceLastFire <= heatTime ? wave : this.lastWave;
    }

    private void addHeatWave(ScannedRobotEvent e) {
        JumperWave wave = new JumperWave();
        Point2D.Double currentEnemyLocation = FUtils.projectMotion(this.myLocation[0], this.me.getHeadingRadians() + e.getBearingRadians(), e.getDistance());
        wave.init(currentEnemyLocation, this.myLocation[2], this.bearingDirection[2], this.lastFirePower, this.velocity[2], FUtils.absoluteBearing(currentEnemyLocation, this.myLocation[2]), 1, false, e.getTime());
        this.heatWave = wave;
        this.me.addCustomEvent((Condition)wave);
    }

    public void newTick() {
        this.myLocation[0] = new Point2D.Double(this.me.getX(), this.me.getY());
        this.velocity[0] = this.me.getVelocity();
        this.bearingDirection[0] = this.enemyLocation == null ? 1 : (this.velocity[0] * Math.sin(this.me.getHeadingRadians() - FUtils.absoluteBearing(this.enemyLocation, this.myLocation[0])) < 0.0 ? -1 : 1);
        int i = 0;
        while (i < 3) {
            this.myLocation[i + 1] = this.myLocation[i];
            this.bearingDirection[i + 1] = this.bearingDirection[i];
            this.velocity[i + 1] = this.velocity[i];
            ++i;
        }
        this.deltaTime = (double)this.me.getTime() - this.time;
        this.timeSinceLastFire = (double)this.me.getTime() - this.lastFireTime;
        this.time = this.me.getTime();
    }

    public void remove(JumperWave wave) {
        this.bullets.remove((Object)wave);
    }

    public JumperWave getClosestWave() {
        return this.getClosestWave(this.myLocation[0], this.time);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Point2D.Double impact = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        JumperWave wave = this.getClosestWave(impact, e.getTime());
        if (wave != null && Math.abs(wave.distanceToImpact(impact, e.getTime())) < 2.0 * wave.velocity) {
            wave.onBulletHitBullet(e);
        } else {
            System.out.println("wave not found");
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Point2D.Double impact = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        JumperWave wave = this.getClosestWave(impact, e.getTime());
        if (wave != null && Math.abs(wave.distanceToImpact(impact, e.getTime())) < 2.0 * wave.velocity) {
            wave.onHitByBullet(e);
        } else {
            System.out.println("wave not found");
        }
        this.energy += 3.0 * e.getPower();
        ++hits;
    }

    public void onHitRobot(HitRobotEvent e) {
        this.lastCollision = e.getTime();
        this.energy -= 0.6;
    }

    public void onBulletHit(BulletHitEvent e) {
        this.energy -= 4.0 * e.getBullet().getPower() + (e.getBullet().getPower() > 1.0 ? 2.0 * (e.getBullet().getPower() - 1.0) : 0.0);
    }

    public boolean isHoldingFire() {
        return this.gunHeat < -0.5;
    }

    public double holdingFireDistance() {
        return holdingFireDistance;
    }

    public boolean isSkyClear() {
        return this.timeSinceLastFire > 1.3 * this.enemyLocation.distance(this.myLocation[0]) / FUtils.bulletVelocity(this.lastFirePower);
    }

    public void dump() {
        System.out.println("Missed scans:" + missedScans + ":" + 1.0 * (double)missedScans / ((double)missedScans * 1.0 + (double)scans * 1.0));
        System.out.println("Missed scans (with extrapolation):" + (missedScans - ScanExtrapolator.extrapolations) + ":" + (1.0 * (double)missedScans - (double)ScanExtrapolator.extrapolations) / ((double)missedScans * 1.0 + (double)scans * 1.0));
        System.out.println("Shots:" + shots);
        System.out.println("Enemy HR:" + 1.0 * (double)hits / (1.0 * (double)shots) * 100.0);
        System.out.println("Hold fire distance:" + holdingFireDistance);
        System.out.println("Resume fire:" + resumeFire);
        JumperWave.dump();
    }

    public double getHitRate() {
        return 1.0 * (double)hits / (1.0 * (double)shots) * 100.0;
    }

    public boolean isResumeFire() {
        return resumeFire;
    }

    public void endRound() {
        this.me.getRoundNum();
        this.me.getNumRounds();
    }

    public ArrayList getBullets() {
        return this.bullets;
    }

    public void onDeath(DeathEvent e) {
        Vector hitEvents = this.me.getHitByBulletEvents();
        Vector collisionEvents = this.me.getHitRobotEvents();
        if (!hitEvents.isEmpty()) {
            System.out.println("Death by bullet");
            HitByBulletEvent hitEv = (HitByBulletEvent)hitEvents.get(0);
            this.onHitByBullet(hitEv);
        } else if (!collisionEvents.isEmpty()) {
            System.out.println("Death by ramming");
        } else {
            System.out.println("Death by unknown source");
        }
    }
}

