/*
 * Decompiled with CFR 0.152.
 */
package wcsv.Engineer.Utilities;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import wcsv.Engineer.Utilities.Utilities;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Target {
    public static final double velRollDepth = 5.0;
    public Point2D.Double location;
    public double energy;
    public double lastEnergy;
    public double velocity;
    public double lastVelocity;
    public double lateralVelocity;
    public double lastLateralVelocity;
    public double rollingVelocity;
    public double advancingVelocity;
    public double heading;
    public double lastHeading;
    public double absoluteBearing;
    public double relativeBearing;
    public double distance;
    public double damageDoneThisTick;
    public double tempDamage;
    public int orbitDir;
    public long scanTime;
    public int samples;

    public void update(ScannedRobotEvent e, AdvancedRobot observer) {
        this.absoluteBearing = Utilities.absoluteAngle((observer.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2));
        this.relativeBearing = Utilities.relativeAngle(this.absoluteBearing);
        this.distance = e.getDistance();
        this.lastVelocity = this.velocity;
        this.velocity = e.getVelocity();
        this.lastHeading = this.heading;
        this.heading = e.getHeadingRadians();
        this.lastEnergy = this.energy;
        this.energy = e.getEnergy();
        this.location = Utilities.projectPoint(observer.getX(), observer.getY(), this.absoluteBearing, this.distance);
        this.lastLateralVelocity = this.lateralVelocity;
        this.lateralVelocity = this.calculateLateralVelocity();
        this.rollingVelocity = Utilities.rollingAvg(this.rollingVelocity, this.lateralVelocity, this.samples, 5);
        this.advancingVelocity = this.calculateAdvancingVelocity();
        this.scanTime = e.getTime();
        this.damageDoneThisTick = this.tempDamage;
        this.tempDamage = 0.0;
        this.setOrbitalDirection();
        ++this.samples;
    }

    public void update(AdvancedRobot r, ScannedRobotEvent observer) {
        this.absoluteBearing = Utilities.absoluteAngle((r.getHeadingRadians() + observer.getBearingRadians()) % (Math.PI * 2) - Math.PI);
        this.relativeBearing = Utilities.relativeAngle((r.getHeadingRadians() + observer.getBearingRadians()) % (Math.PI * 2) - Math.PI);
        this.distance = observer.getDistance();
        this.lastVelocity = this.velocity;
        this.velocity = r.getVelocity();
        this.lastHeading = this.heading;
        this.heading = r.getHeadingRadians();
        this.lastEnergy = this.energy;
        this.energy = r.getEnergy();
        this.location = new Point2D.Double(r.getX(), r.getY());
        this.lastLateralVelocity = this.lateralVelocity;
        this.lateralVelocity = this.calculateLateralVelocity();
        this.rollingVelocity = Utilities.rollingAvg(this.rollingVelocity, this.lateralVelocity, this.samples, 5);
        this.advancingVelocity = this.calculateAdvancingVelocity();
        this.scanTime = observer.getTime();
        this.damageDoneThisTick = this.tempDamage;
        this.tempDamage = 0.0;
        this.setOrbitalDirection();
        ++this.samples;
    }

    public Target cloneTarget() {
        Target clone = new Target();
        clone.absoluteBearing = this.absoluteBearing;
        clone.relativeBearing = this.relativeBearing;
        clone.distance = this.distance;
        clone.velocity = this.velocity;
        clone.heading = this.heading;
        clone.lastHeading = this.lastHeading;
        clone.energy = this.energy;
        clone.lastEnergy = this.lastEnergy;
        clone.location = new Point2D.Double(this.location.getX(), this.location.getY());
        clone.lateralVelocity = this.lateralVelocity;
        clone.lastLateralVelocity = this.lastLateralVelocity;
        clone.advancingVelocity = this.advancingVelocity;
        clone.scanTime = this.scanTime;
        clone.damageDoneThisTick = this.damageDoneThisTick;
        clone.lastVelocity = this.lastVelocity;
        clone.orbitDir = this.orbitDir;
        clone.rollingVelocity = this.rollingVelocity;
        clone.samples = this.samples;
        return clone;
    }

    public void setOrbitalDirection() {
        int s = Utilities.sign(this.lateralVelocity);
        if (s != 0) {
            this.orbitDir = s;
        } else if (this.orbitDir == 0) {
            this.orbitDir = 1;
        }
    }

    public double calculateLateralVelocity() {
        return Math.sin(this.heading - this.absoluteBearing) * this.velocity;
    }

    public double calculateAdvancingVelocity() {
        return -Math.cos(this.heading - this.absoluteBearing) * this.velocity;
    }

    public int wallSegment(double[] segs) {
        int i = 0;
        while (i < segs.length) {
            if (Utilities.outsideWall(Utilities.projectPoint(this.location, this.heading, segs[i]))) {
                return i;
            }
            ++i;
        }
        return segs.length;
    }

    public double calculateLateralAcceleration() {
        return this.lateralVelocity - this.lastLateralVelocity;
    }

    public double calculateAcceleration() {
        return this.velocity - this.lastVelocity;
    }

    public double calculateTurnRate() {
        return Utilities.relativeAngle(this.heading - this.lastHeading);
    }

    private final /* synthetic */ void this() {
        this.damageDoneThisTick = 0.0;
        this.tempDamage = 0.0;
    }

    public Target(ScannedRobotEvent e, AdvancedRobot observer) {
        this.this();
        this.absoluteBearing = Utilities.absoluteAngle((observer.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2));
        this.relativeBearing = Utilities.relativeAngle(this.absoluteBearing);
        this.distance = e.getDistance();
        this.lastVelocity = this.velocity = e.getVelocity();
        this.lastHeading = this.heading = e.getHeadingRadians();
        this.lastEnergy = this.energy = e.getEnergy();
        this.location = Utilities.projectPoint(observer.getX(), observer.getY(), this.absoluteBearing, this.distance);
        this.lastLateralVelocity = this.lateralVelocity = this.calculateLateralVelocity();
        this.rollingVelocity = this.lateralVelocity;
        this.advancingVelocity = this.calculateAdvancingVelocity();
        this.scanTime = e.getTime();
        this.damageDoneThisTick = 0.0;
        this.tempDamage = 0.0;
        this.setOrbitalDirection();
        this.samples = 1;
    }

    public Target(AdvancedRobot r, ScannedRobotEvent observer) {
        this.this();
        this.absoluteBearing = Utilities.absoluteAngle((r.getHeadingRadians() + observer.getBearingRadians()) % (Math.PI * 2) - Math.PI);
        this.relativeBearing = Utilities.relativeAngle((r.getHeadingRadians() + observer.getBearingRadians()) % (Math.PI * 2) - Math.PI);
        this.distance = observer.getDistance();
        this.lastVelocity = this.velocity = r.getVelocity();
        this.lastHeading = this.heading = r.getHeadingRadians();
        this.lastEnergy = this.energy = r.getEnergy();
        this.location = new Point2D.Double(r.getX(), r.getY());
        this.lastLateralVelocity = this.lateralVelocity = this.calculateLateralVelocity();
        this.rollingVelocity = this.lateralVelocity;
        this.advancingVelocity = this.calculateAdvancingVelocity();
        this.scanTime = observer.getTime();
        this.damageDoneThisTick = 0.0;
        this.tempDamage = 0.0;
        this.setOrbitalDirection();
        this.samples = 1;
    }

    public Target() {
        this.this();
    }
}

