/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.ws.path;

import dsekercioglu.mega.rMove.MoveUtils;
import java.awt.geom.Point2D;
import java.util.List;
import robocode.util.Utils;

public class State {
    private static final double ROBOT_MAX_VELOCITY = 8.0;
    private static final double PI = Math.PI;
    private static final double HALF_PI = 1.5707963267948966;
    private final Point2D.Double LOCATION;
    private final double VELOCITY;
    private final double HEADING;
    private final int DELTA_TIME;
    private boolean intersecting;
    private double maxVelocity;
    List<Point2D.Double> intersections;

    public State(Point2D.Double location, double velocity, double heading, int deltaTime) {
        this.LOCATION = location;
        this.VELOCITY = velocity;
        this.HEADING = heading;
        this.DELTA_TIME = deltaTime;
        this.maxVelocity = 8.0;
    }

    public void setIntersecting(boolean intersecting) {
        this.intersecting = intersecting;
    }

    public boolean isIntersecting() {
        return this.intersecting;
    }

    public void setIntersection(List<Point2D.Double> intersections) {
        this.intersections = intersections;
    }

    public List<Point2D.Double> getIntersection() {
        return this.intersections;
    }

    public Point2D.Double getLocation() {
        return this.LOCATION;
    }

    public double getVelocity() {
        return this.VELOCITY;
    }

    public double getHeading() {
        return this.HEADING;
    }

    public int getDeltaTime() {
        return this.DELTA_TIME;
    }

    public void setMaxVelocity(double maxVelocity) {
        this.maxVelocity = maxVelocity;
    }

    public State moveTowards(double angleTo) {
        double turnAmount = Utils.normalRelativeAngle((double)(angleTo - this.HEADING));
        boolean backAsForward = Math.abs(turnAmount) >= 1.5707963267948966;
        double targetVelocity = backAsForward ? -this.maxVelocity : this.maxVelocity;
        double targetHeading = backAsForward ? angleTo + Math.PI : angleTo;
        double nextHeading = State.getNextHeading(this.VELOCITY, this.HEADING, targetHeading);
        double nextVelocity = State.getNextVelocity(this.VELOCITY, targetVelocity);
        Point2D.Double nextLocation = MoveUtils.project(this.LOCATION, nextHeading, nextVelocity);
        State nextState = new State((Point2D.Double)nextLocation.clone(), nextVelocity, nextHeading, this.DELTA_TIME + 1);
        nextState.setMaxVelocity(this.maxVelocity);
        return nextState;
    }

    public State moveTo(Point2D.Double targetLocation) {
        double angleTo = MoveUtils.absoluteBearing(this.LOCATION, targetLocation);
        return this.moveTowards(angleTo);
    }

    public State brake() {
        double nextVelocity = State.decelerate(this.VELOCITY);
        Point2D.Double nextLocation = MoveUtils.project(this.LOCATION, this.HEADING, nextVelocity);
        return new State((Point2D.Double)nextLocation.clone(), nextVelocity, this.HEADING, this.DELTA_TIME + 1);
    }

    public int stopTime() {
        return (int)Math.ceil(Math.abs(this.VELOCITY) / 2.0);
    }

    private static double accelerate(double velocity, double preferredDirection) {
        return MoveUtils.limit(-8.0, velocity + (velocity > 0.0 ? 1.0 : (velocity < 0.0 ? -1.0 : preferredDirection)), 8.0);
    }

    private static double decelerate(double velocity) {
        return Math.abs(velocity) <= 2.0 ? 0.0 : velocity + (double)(velocity > 0.0 ? -2 : (velocity < 0.0 ? 2 : 0));
    }

    private static double getNextVelocity(double velocity, double target) {
        double signedDifference;
        boolean sameSign;
        double velocitySign = Math.signum(velocity);
        double targetSign = Math.signum(target);
        boolean bl = sameSign = targetSign == velocitySign;
        if (target == 0.0 || !sameSign && velocitySign != 0.0) {
            return State.decelerate(velocity);
        }
        double difference = target - velocity;
        boolean possiblyInRange = Math.abs(difference) <= 2.0;
        double differenceSign = Math.signum(difference);
        if (possiblyInRange && (signedDifference = difference * differenceSign) <= 1.0 && signedDifference >= -2.0) {
            return target;
        }
        return State.accelerate(velocity, differenceSign);
    }

    private static double getNextHeading(double velocity, double heading, double target) {
        double maxTurn = Math.toRadians(10.0 - 0.75 * Math.abs(velocity));
        return heading + MoveUtils.limit(-maxTurn, Utils.normalRelativeAngle((double)(target - heading)), maxTurn);
    }

    public String toString() {
        return "State{LOCATION=" + this.LOCATION + ", VELOCITY=" + this.VELOCITY + ", HEADING=" + this.HEADING + ", intersecting=" + this.intersecting + '}';
    }
}

