/*
 * Decompiled with CFR 0.152.
 */
package ds.gun.dsgf;

import ds.Hud;
import ds.Versatile;
import ds.constant.ConstantManager;
import ds.gun.dsgf.FireIndex;
import ds.gun.dsgf.IndexedVirtualBullet;
import ds.gun.dsgf.Leaf;
import ds.gun.dsgf.LeafComparator;
import ds.gun.dsgf.SegmentationInfo;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import robocode.RobocodeFileOutputStream;

public class Node
implements Comparable<Node> {
    private ArrayList<Leaf> m_childLeafs;
    private ArrayList<Node> m_childNodes;
    private long[] m_samplesSummary;
    private int m_nbSamples;
    private int m_maxNodeLeafCount;
    private int m_effectiveMaxNodeLeafCount;
    private int m_segmentingInfoIndex;
    private double m_threshold;
    private Node m_parent;
    private int m_segmentationFactor;
    private int m_minNodeLeafCount;
    private int m_densityEstimationWindow;
    private boolean m_bIsDataSaver;
    private double m_decayFactor;

    public Node(Node parent, double threshold, int maxNodeLeafCount, int minNodeLeafCount, boolean bIsDataSaver) {
        this.Build(parent, threshold, maxNodeLeafCount, minNodeLeafCount, bIsDataSaver, parent.m_decayFactor);
    }

    public Node(int maxNodeLeafCount, int minNodeLeafCount, boolean bIsDataSaver, double decayFactor) {
        this.Build(null, Double.NEGATIVE_INFINITY, maxNodeLeafCount, minNodeLeafCount, bIsDataSaver, decayFactor);
    }

    protected Node(Node parent, double threshold, boolean bIsDataSaver) {
        this.Build(parent, threshold, parent.m_maxNodeLeafCount, parent.m_minNodeLeafCount, bIsDataSaver, parent.m_decayFactor);
    }

    protected Node(Node parent, boolean bIsDataSaver) {
        this.Build(parent, Double.NEGATIVE_INFINITY, parent.m_maxNodeLeafCount, parent.m_minNodeLeafCount, bIsDataSaver, parent.m_decayFactor);
    }

    private void Build(Node parent, double threshold, int maxNodeLeafCount, int minNodeLeafCount, boolean bIsDataSaver, double decayFactor) {
        this.m_parent = parent;
        this.m_bIsDataSaver = bIsDataSaver;
        ConstantManager cm = ConstantManager.getInstance();
        this.m_decayFactor = decayFactor;
        this.m_nbSamples = (int)cm.getIntegerConstant("gun.dsgf.nbSamples").longValue();
        this.m_segmentationFactor = (int)cm.getIntegerConstant("gun.dsgf.segmentationFactor").longValue();
        this.m_densityEstimationWindow = (int)(1L + cm.getIntegerConstant("gun.dsgf.densityEstimationWindow"));
        this.m_effectiveMaxNodeLeafCount = this.m_maxNodeLeafCount = maxNodeLeafCount;
        this.m_minNodeLeafCount = minNodeLeafCount;
        this.m_childLeafs = new ArrayList();
        this.m_childNodes = new ArrayList();
        this.m_samplesSummary = new long[this.m_nbSamples];
        this.m_segmentingInfoIndex = 0;
        this.m_threshold = threshold;
        if (parent == null) {
            this.m_childNodes.add(new Node(this, threshold, this.m_bIsDataSaver));
        }
    }

    public void add(IndexedVirtualBullet vb) {
        Leaf leaf = new Leaf(this, vb);
        this.add(leaf);
    }

    private void splitNode(Node node, Node sub1, Node sub2) {
        this.m_childNodes.remove(node);
        this.m_childNodes.add(sub1);
        this.m_childNodes.add(sub2);
        this.saveNodeToFile(this.getSegmentingInfoIndex(), node, sub1, sub2);
        Collections.sort(this.m_childNodes);
    }

    private void saveNodeToFile(int segmentingInfoIndex, Node node, Node sub1, Node sub2) {
        if (this.m_bIsDataSaver && ConstantManager.getInstance().getBooleanConstant("debugData")) {
            try {
                long sample;
                RobocodeFileOutputStream zipout = new RobocodeFileOutputStream(Versatile.getMe().getDataFile("data.csv").toString(), true);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)zipout));
                out.write("\n\n\n");
                out.write(",dimension," + segmentingInfoIndex + "," + SegmentationInfo.getDimensionName(segmentingInfoIndex) + "\n");
                out.write("," + System.identityHashCode(this) + ",original,");
                long[] lArray = node.getSamples();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    sample = lArray[n2];
                    out.write(sample + ",");
                    ++n2;
                }
                out.write(",," + node.getCrestFactor());
                out.write("\n");
                out.write("," + System.identityHashCode(sub1) + ",sub1,");
                lArray = sub1.getSamples();
                n = lArray.length;
                n2 = 0;
                while (n2 < n) {
                    sample = lArray[n2];
                    out.write(sample + ",");
                    ++n2;
                }
                out.write(",," + sub1.getCrestFactor());
                out.write("\n");
                out.write("," + System.identityHashCode(sub2) + ",sub2,");
                lArray = sub2.getSamples();
                n = lArray.length;
                n2 = 0;
                while (n2 < n) {
                    sample = lArray[n2];
                    out.write(sample + ",");
                    ++n2;
                }
                out.write(",," + sub2.getCrestFactor());
                out.write("\n");
                out.write("\n");
                ((Writer)out).flush();
                ((Writer)out).close();
                zipout.close();
            }
            catch (IOException e) {
                System.out.println("Error saving factors:" + e);
            }
        }
    }

    private void add(Leaf leaf) {
        if (!this.m_childNodes.isEmpty()) {
            double infoValue = leaf.getSegmentationInfo().getInfo(this.m_segmentingInfoIndex);
            for (Node node : this.m_childNodes) {
                if (!(infoValue >= node.getThreshold())) continue;
                node.add(leaf);
                return;
            }
        } else {
            this.m_childLeafs.add(leaf);
            this.updateSamples();
            if (this.m_childLeafs.size() > this.m_effectiveMaxNodeLeafCount) {
                int maxChildNodeCount = (int)ConstantManager.getInstance().getIntegerConstant("gun.dsgf.maxChildNodeCount").longValue();
                if (this.m_parent.m_childNodes.size() >= maxChildNodeCount) {
                    Node node = new Node(this, this.m_bIsDataSaver);
                    node.m_childLeafs = this.m_childLeafs;
                    this.m_childLeafs = new ArrayList();
                    this.m_childNodes.add(node);
                } else {
                    this.removeOldLeafs();
                    if (this.m_parent.m_childNodes.size() == 1) {
                        this.searchSplitDimension();
                        if (ConstantManager.getInstance().getBooleanConstant("debug")) {
                            System.out.println("Choosing dimension " + this.m_parent.m_segmentingInfoIndex);
                        }
                    }
                    Node sub1 = new Node(this.m_parent, this.m_threshold, this.m_bIsDataSaver);
                    Node sub2 = new Node(this.m_parent, 0.0, this.m_bIsDataSaver);
                    SplitSolution split = this.searchSplit(sub1, sub2);
                    if (sub1.m_childLeafs.size() == 0 || sub2.m_childLeafs.size() == 0) {
                        System.out.println("Alerte BUG!!!");
                        split = this.searchSplit(sub1, sub2);
                    }
                    this.m_parent.splitNode(this, sub1, sub2);
                }
            }
        }
    }

    private void removeOldLeafs() {
        if (this.m_decayFactor == 0.0) {
            return;
        }
        Collections.sort(this.m_childLeafs, new LeafComparator(-1));
        int end = this.m_childLeafs.size();
        double min = this.m_childLeafs.get(0).getSegmentationInfo().getInfo(-1);
        double max = this.m_childLeafs.get(end - 1).getSegmentationInfo().getInfo(-1);
        if (min == max) {
            return;
        }
        double threshold = min + (max - min) * this.m_decayFactor;
        int thresholdIndex = 0;
        int j = 0;
        while (j < end) {
            if (this.m_childLeafs.get(j).getSegmentationInfo().getInfo(-1) >= threshold) {
                thresholdIndex = j;
                break;
            }
            ++j;
        }
        ArrayList newLeafs = (ArrayList)this.m_childLeafs.clone();
        this.setLeafs(newLeafs.subList(thresholdIndex, end));
    }

    private void updateSamples() {
        this.m_samplesSummary = new long[this.m_nbSamples];
        for (Leaf l : this.m_childLeafs) {
            int sampleIndex;
            int n = sampleIndex = l.getAngleIndex();
            this.m_samplesSummary[n] = this.m_samplesSummary[n] + 1L;
        }
    }

    private void searchSplitDimension() {
        int nbDimensions = this.m_childLeafs.get(0).getSegmentationInfo().getDImCount();
        int bestDim = 0;
        double bestVar = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < nbDimensions) {
            this.m_parent.m_segmentingInfoIndex = i;
            Node sub1 = new Node(this.m_parent, this.m_threshold, this.m_bIsDataSaver);
            Node sub2 = new Node(this.m_parent, 0.0, this.m_bIsDataSaver);
            SplitSolution split = this.searchSplit(sub1, sub2);
            double sumVar = split.m_variance;
            if (sumVar > bestVar) {
                bestDim = i;
                bestVar = sumVar;
            }
            ++i;
        }
        this.m_parent.m_segmentingInfoIndex = bestDim;
    }

    private SplitSolution searchSplit(Node sub1, Node sub2) {
        int segmentingInfoIndex = this.m_parent != null ? this.m_parent.m_segmentingInfoIndex : 0;
        Collections.sort(this.m_childLeafs, new LeafComparator(segmentingInfoIndex));
        int end = this.m_childLeafs.size();
        ArrayList bestCut1 = new ArrayList();
        ArrayList bestCut2 = new ArrayList();
        double bestVar = Double.NEGATIVE_INFINITY;
        double bestThreshold = 0.0;
        int i = 1;
        while (i < this.m_segmentationFactor) {
            double min = this.m_childLeafs.get(0).getSegmentationInfo().getInfo(segmentingInfoIndex);
            double max = this.m_childLeafs.get(end - 1).getSegmentationInfo().getInfo(segmentingInfoIndex);
            double threshold = min + (double)i * (max - min) / (double)this.m_segmentationFactor;
            int thresholdIndex = 0;
            int j = 0;
            while (j < end) {
                if (this.m_childLeafs.get(j).getSegmentationInfo().getInfo(segmentingInfoIndex) >= threshold) {
                    thresholdIndex = j;
                    break;
                }
                ++j;
            }
            sub1.setLeafs(this.m_childLeafs.subList(0, thresholdIndex));
            sub2.setLeafs(this.m_childLeafs.subList(thresholdIndex, end));
            sub2.m_threshold = threshold;
            sub1.updateSamples();
            sub2.updateSamples();
            double crest1 = sub1.getCrestFactor();
            double crest2 = sub2.getCrestFactor();
            double sumVar = crest1 + crest2;
            sumVar *= this.getDifference(sub1, sub2);
            if (min == max) {
                sumVar /= 10.0;
            } else if (sub1.m_childLeafs.size() < this.m_minNodeLeafCount || sub2.m_childLeafs.size() < this.m_minNodeLeafCount) {
                sumVar /= 2.0;
            }
            if (sumVar > bestVar) {
                bestCut1 = (ArrayList)sub1.m_childLeafs.clone();
                bestCut2 = (ArrayList)sub2.m_childLeafs.clone();
                bestVar = sumVar;
                bestThreshold = threshold;
            }
            ++i;
        }
        sub1.m_childLeafs = bestCut1;
        sub2.m_childLeafs = bestCut2;
        sub1.updateSamples();
        sub2.updateSamples();
        sub2.m_threshold = bestThreshold;
        SplitSolution split = new SplitSolution(bestVar, bestThreshold);
        return split;
    }

    private double getCrestFactor() {
        double sommeDesCarres = 0.0;
        long[] lArray = this.getSamples();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long sample = lArray[n2];
            sommeDesCarres += (double)(sample * sample);
            ++n2;
        }
        double pic = this.getSamplesPic().m_nPicSizeRaw;
        double moyenneDesCarres = sommeDesCarres / (double)this.getSamples().length;
        double rms = Math.sqrt(moyenneDesCarres);
        return pic / rms;
    }

    private double getDifference(Node sub1, Node sub2) {
        double result = 0.0;
        result = sub1.getSamplesPic().m_nPicIndex - sub2.getSamplesPic().m_nPicIndex;
        result = Math.abs(result);
        if ((result = (5.0 + result * 1.0 / 3.0) / 6.0) > 1.0) {
            result = 1.0;
        }
        return result;
    }

    private void setLeafs(List<Leaf> leafList) {
        this.m_childLeafs.clear();
        this.m_childLeafs.addAll(leafList);
    }

    public Node getSolutionSamples(SegmentationInfo si) {
        if (!this.m_childLeafs.isEmpty()) {
            return this;
        }
        if (!this.m_childNodes.isEmpty()) {
            double infoValue = si.getInfo(this.m_segmentingInfoIndex);
            for (Node node : this.m_childNodes) {
                if (!(infoValue >= node.getThreshold())) continue;
                Node noeud = node.getSolutionSamples(si);
                return noeud;
            }
        }
        return null;
    }

    public FireIndex getSolution(SegmentationInfo si) {
        Node noeud = this.getSolutionSamples(si);
        if (noeud != null) {
            long bestSampleIndex = noeud.getSamplesPic().m_nPicIndex;
            FireIndex fi = new FireIndex(bestSampleIndex, Math.max(10, this.m_childLeafs.size()) / 10);
            return fi;
        }
        FireIndex fi = new FireIndex(this.m_nbSamples / 2, 0.0);
        return fi;
    }

    private PicDescription getSamplesPic() {
        int bestPicIndex = this.m_nbSamples / 2;
        int bestSampleValue = -1;
        int bestPicSize = 0;
        int bestPicSizeRaw = 0;
        int i = 0;
        while (i < this.m_nbSamples) {
            if (this.m_samplesSummary[i] > (long)bestPicSizeRaw) {
                bestPicSizeRaw = (int)this.m_samplesSummary[i];
            }
            int sampleEstimation = (int)this.m_samplesSummary[i] * this.m_densityEstimationWindow;
            int j = 1;
            while (j < this.m_densityEstimationWindow) {
                if (i - j >= 0) {
                    sampleEstimation = (int)((long)sampleEstimation + this.m_samplesSummary[i - j] * (long)(this.m_densityEstimationWindow - j));
                }
                if (i + j < this.m_nbSamples) {
                    sampleEstimation = (int)((long)sampleEstimation + this.m_samplesSummary[i + j] * (long)(this.m_densityEstimationWindow - j));
                }
                ++j;
            }
            if (sampleEstimation > bestSampleValue) {
                bestPicIndex = i;
                bestSampleValue = sampleEstimation;
            }
            ++i;
        }
        return new PicDescription(bestPicIndex, bestPicSize, bestPicSizeRaw);
    }

    private double getThreshold() {
        return this.m_threshold;
    }

    protected double getSamplesVariance() {
        double mean = 0.0;
        double S = 0.0;
        long sumweight = this.m_samplesSummary[0];
        int i = 1;
        while (i < this.m_nbSamples) {
            long weight = this.m_samplesSummary[i];
            long temp = weight + sumweight;
            if (weight != 0L) {
                S += (double)(sumweight * weight) * ((double)i - mean) * ((double)i - mean) / (double)temp;
                mean += ((double)i - mean) * (double)weight / (double)temp;
            }
            sumweight = temp;
            ++i;
        }
        double variance = S * (double)i / (double)((long)(i - 1) * sumweight);
        return variance;
    }

    public int getSegmentingInfoIndex() {
        return this.m_segmentingInfoIndex;
    }

    @Override
    public int compareTo(Node o) {
        if (this.m_threshold > o.m_threshold) {
            return -1;
        }
        if (this.m_threshold < o.m_threshold) {
            return 1;
        }
        return 0;
    }

    public int paint(Hud hud, int offset) {
        int i = 0;
        for (Node node : this.m_childNodes) {
            i += Math.max(node.paint(hud, offset + i) - 1, 0);
            ++i;
        }
        Node parent = this.m_parent;
        int parentCount = 0;
        while (parent != null) {
            parent = parent.m_parent;
            ++parentCount;
        }
        String ch = "X";
        if (this.m_childLeafs.size() > 0) {
            ch = "L";
        } else if (this.m_childNodes.size() > 1) {
            ch = Integer.toString(this.m_segmentingInfoIndex);
        }
        hud.drawString(ch, 790 - offset * 10, 10 + parentCount * 10);
        return i;
    }

    public long[] getSamples() {
        return this.m_samplesSummary;
    }

    public double[] getSamplesHitChances() {
        long pic = 1L;
        int i = 0;
        while (i < this.m_samplesSummary.length) {
            if (this.m_samplesSummary[i] > pic) {
                pic = this.m_samplesSummary[i];
            }
            ++i;
        }
        double[] hitchances = new double[this.m_nbSamples];
        int i2 = 0;
        while (i2 < this.m_samplesSummary.length) {
            hitchances[i2] = (double)this.m_samplesSummary[i2] / (double)pic;
            ++i2;
        }
        return hitchances;
    }

    public Vector<String> getSolutionString(SegmentationInfo si) {
        if (!this.m_childLeafs.isEmpty()) {
            Vector<String> v = new Vector<String>();
            v.add("L");
            return v;
        }
        if (!this.m_childNodes.isEmpty()) {
            double infoValue = si.getInfo(this.m_segmentingInfoIndex);
            String txt = "[";
            for (Node node : this.m_childNodes) {
                txt = node.getThreshold() == Double.NEGATIVE_INFINITY ? String.valueOf(txt) + "-inf" : String.valueOf(txt) + String.format("%.2f", node.getThreshold()).toString() + ":";
            }
            txt = String.valueOf(txt) + "]";
            for (Node node : this.m_childNodes) {
                if (!(infoValue >= node.getThreshold())) continue;
                String strInfoValue = String.format("%.2f", infoValue).toString();
                String strThreshold = String.format("%.2f", node.getThreshold()).toString();
                txt = SegmentationInfo.getDimensionName(this.m_segmentingInfoIndex) + txt + "(" + strInfoValue + ">=" + strThreshold + ")>" + "\n\t";
                Vector<String> v = node.getSolutionString(si);
                v.add(0, txt);
                return v;
            }
        }
        Vector<String> v = new Vector<String>();
        v.add("pas de solution de tir");
        return v;
    }

    protected class PicDescription {
        public int m_nPicIndex;
        public int m_nPicSize;
        public int m_nPicSizeRaw;

        public PicDescription(int nPicIndex, int nPicSize, int nPicSizeRaw) {
            this.m_nPicIndex = nPicIndex;
            this.m_nPicSize = nPicSize;
            this.m_nPicSizeRaw = nPicSizeRaw;
        }
    }

    public class SplitSolution {
        public double m_variance = 0.0;
        public double m_threshold = 0.0;

        public SplitSolution(double variance, double threshold) {
            this.m_variance = variance;
            this.m_threshold = threshold;
        }
    }
}

