/*
 * Decompiled with CFR 0.152.
 */
package com.spp.robocode;

import com.spp.robocode.BattlefieldModel;
import com.spp.robocode.Debug;
import com.spp.robocode.Gunner;
import com.spp.robocode.MovementManager;
import com.spp.robocode.RadarScanner;
import java.awt.Color;
import java.awt.Graphics2D;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;

public class MostlyHarmless
extends AdvancedRobot {
    private RadarScanner scanner = null;
    private MovementManager mover = null;
    private BattlefieldModel model = null;
    private Gunner gunner = null;

    public void run() {
        this.setBodyColor(Color.WHITE);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setScanColor(Color.WHITE);
        this.setBulletColor(Color.yellow);
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        this.model = new BattlefieldModel(this);
        this.scanner = new RadarScanner(this, this.model);
        this.scanner.startScanning();
        this.gunner = new Gunner(this, this.model);
        this.mover = new MovementManager(this, this.model);
        this.execute();
        Debug.Debug("Started");
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        System.out.println("--------- SKIPPED TURN  ---------- ");
    }

    public void onStatus(StatusEvent e) {
        if (this.gunner != null) {
            this.gunner.chooseTarget();
        }
        if (this.scanner != null && this.gunner != null) {
            this.scanner.setTarget(this.gunner.currentTarget());
        }
    }

    public void onBattleEnded(BattleEndedEvent event) {
        super.onBattleEnded(event);
    }

    public void onRoundEnded(RoundEndedEvent event) {
        Gunner.guidanceComputer.onNewRound();
        super.onRoundEnded(event);
    }

    public void onWin(WinEvent event) {
        Gunner.guidanceComputer.onNewRound();
        super.onWin(event);
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        this.model.onScannedRobot(event);
        if (this.scanner != null) {
            this.scanner.onScannedRobot(event);
        }
        boolean fired = false;
        if (this.gunner != null) {
            fired = this.gunner.onScannedRobot(event);
        }
        if (this.mover != null && !fired) {
            this.mover.move();
        }
    }

    public void onRobotDeath(RobotDeathEvent event) {
        if (event.getName().equals(this.getName())) {
            Gunner.guidanceComputer.onNewRound();
        }
        this.model.onRobotDeath(event.getName());
        this.gunner.onRobotDeath(event.getName());
    }

    public void onHitWall(HitWallEvent event) {
        Debug.Debug("Hit Wall");
    }

    public void onHitRobot(HitRobotEvent event) {
        this.mover.onHitRobot(event);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        super.onHitByBullet(event);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        super.onBulletMissed(event);
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        super.onBulletHitBullet(event);
    }

    public void onBulletHit(BulletHitEvent event) {
        super.onBulletHit(event);
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.RED);
        Gunner.guidanceComputer.onPaint(g);
    }
}

