/*
 * Decompiled with CFR 0.152.
 */
package eem.motion;

import eem.bot.fighterBot;
import eem.dangermap.dangerMap;
import eem.dangermap.dangerPoint;
import eem.misc.graphics;
import eem.misc.physics;
import eem.motion.basicMotion;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class dangerMapMotion
extends basicMotion {
    protected fighterBot myBot;
    public dangerMap _dangerMap;
    private double superDanger = 1.0E8;
    public dangerPoint destPoint = null;

    @Override
    public void initTic() {
        this._dangerMap.reCalculateDangerMap(this.myBot.getTime());
    }

    public dangerMapMotion() {
    }

    public dangerMapMotion(fighterBot fighterBot2) {
        this.myBot = fighterBot2;
        this.initBattle(this.myBot);
        this._dangerMap = new dangerMap(this.myBot);
        this.destPoint = new dangerPoint(new Point2D.Double(0.0, 0.0), this.superDanger);
    }

    @Override
    public void manage() {
        this._dangerMap.clearDangerPoints();
        this.buildListOfPointsToTestForDanger();
        double d = this._dangerMap.calculateDangerForPoint(this.myBot.getTime(), this.destPoint);
        this.destPoint.setDanger(d);
        this._dangerMap.reCalculateDangerMap(this.myBot.getTime());
        dangerPoint dangerPoint2 = this._dangerMap.getSafestPoint();
        if (this.destPoint.compareTo(dangerPoint2) > 0) {
            this.destPoint = dangerPoint2;
        }
        this.moveToPoint(this.destPoint.getPosition());
    }

    @Override
    public void makeMove() {
    }

    private void buildListOfPointsToTestForDanger() {
        double d = 40.0;
        int n = 20;
        Point2D.Double double_ = null;
        double_ = this.myBot.getPosition();
        if (double_ == null) {
            double_ = new Point2D.Double(0.0, 0.0);
        }
        for (int i = 0; i < n; ++i) {
            double d2 = Math.PI * 2 / (double)(n - 1) * (double)i;
            Point2D.Double double_2 = new Point2D.Double(d * Math.cos(d2), d * Math.sin(d2));
            double_2.x = double_.x + double_2.x;
            double_2.y = double_.y + double_2.y;
            if (!this.isItWithReacheableSpace(double_2)) continue;
            this._dangerMap.add(double_2);
        }
    }

    public boolean isItWithReacheableSpace(Point2D.Double double_) {
        double d = physics.shortestDist2wall(double_);
        return !(d < (double)physics.robotHalfSize);
    }

    @Override
    public void onPaint(Graphics2D graphics2D) {
        graphics2D.setColor(new Color(0, 255, 0, 128));
        graphics.drawCircle(graphics2D, this.destPoint.getPosition(), 10.0);
        this._dangerMap.onPaint(graphics2D);
    }
}

