/*
 * Decompiled with CFR 0.152.
 */
package simonton.waves;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import simonton.dc.Cluster;
import simonton.utils.FastMath;
import simonton.waves.GFProbability;
import simonton.waves.Wave;
import simonton.waves.WaveStats;

public class LogStats
extends WaveStats {
    private static final double STD_BOTWDTH = 0.125 / FastMath.asin(0.5714285714285714);
    private Wave wave;
    private List log;
    private GFProbability[] minimumProbabilities;

    public LogStats(Wave wave) {
        this.wave = wave;
    }

    public void setLog(Collection log) {
        this.log = new ArrayList(log);
        Collections.sort(this.log);
        this.minimumProbabilities = null;
    }

    public double getOpenPercentage() {
        double[] log = new double[this.log.size() + 2];
        log[0] = 1.0 + STD_BOTWDTH / 2.0;
        log[1] = -log[0];
        int i = log.length;
        while (--i > 1) {
            log[i] = (Double)((Cluster.Point)this.log.get((int)(i - 2))).value;
        }
        Arrays.sort(log);
        double open = 0.0;
        int i2 = log.length;
        while (--i2 > 0) {
            double space = log[i2] - log[i2 - 1] - STD_BOTWDTH;
            if (!(space > 0.0)) continue;
            open += space;
        }
        double maxSpace = 2.0 - STD_BOTWDTH / 2.0;
        double minSpace = FastMath.max(0.0, maxSpace - (double)(log.length - 1) * STD_BOTWDTH);
        return (open - minSpace) / (maxSpace - minSpace);
    }

    public double getProbability(double gf) {
        return this.getProbability(gf, STD_BOTWDTH);
    }

    @Override
    public double getProbability(double gf, double gfBotwidth) {
        int length = this.log.size();
        if (this.log == null || length == 0) {
            return 0.0;
        }
        double probability = 0.0;
        for (Cluster.Point p : this.log) {
            probability += 1.0 / (1.0 + FastMath.doubleSquare(2.0 * ((Double)p.value - gf) / gfBotwidth));
        }
        return probability / (double)length;
    }

    @Override
    public GFProbability getMaximumProbability(double gfBotwidth) {
        double bestGf = 0.7;
        double bestProbability = -1.0;
        for (Cluster.Point p : this.log) {
            double probablity = this.getProbability((Double)p.value, gfBotwidth);
            if (!(probablity > bestProbability)) continue;
            bestGf = (Double)p.value;
            bestProbability = probablity;
        }
        return new GFProbability(this.wave, bestGf);
    }

    @Override
    public GFProbability[] getMinimumProbabilities(int num, double gfBotwidth) {
        if (this.minimumProbabilities != null) {
            return this.minimumProbabilities;
        }
        int length = this.log.size();
        double[] specialPoints = null;
        int specialPointIndex = 0;
        double specialPointProbability = 0.0;
        double specialPoint = Double.NEGATIVE_INFINITY;
        if (this.log != null && length > 1) {
            specialPoints = new double[length - 1];
            int j = 0;
            int i = length;
            while (--i > 0) {
                specialPoints[j++] = ((Double)((Cluster.Point)this.log.get((int)i)).value + (Double)((Cluster.Point)this.log.get((int)(i - 1))).value) / 2.0;
            }
            specialPointIndex = specialPoints.length - 1;
            specialPoint = specialPoints[specialPointIndex];
            specialPointProbability = this.getProbability(specialPoint, gfBotwidth);
        }
        double partition = 1.0;
        double partitionProbability = this.getProbability(partition, gfBotwidth);
        this.minimumProbabilities = new GFProbability[num];
        int i = num;
        while (--i >= 0) {
            double minGf = partition;
            double minProbability = partitionProbability;
            partitionProbability = this.getProbability(partition -= 2.0 / (double)num, gfBotwidth);
            if (partitionProbability < minProbability) {
                minProbability = partitionProbability;
                minGf = partition;
            }
            while (specialPoint >= partition) {
                if (specialPointProbability <= minProbability) {
                    minProbability = specialPointProbability;
                    minGf = specialPoint;
                }
                if (--specialPointIndex < 0) {
                    specialPoint = Double.NEGATIVE_INFINITY;
                    specialPointProbability = 0.0;
                    continue;
                }
                specialPoint = specialPoints[specialPointIndex];
                specialPointProbability = this.getProbability(specialPoint, gfBotwidth);
            }
            this.minimumProbabilities[i] = new GFProbability(this.wave, minGf);
        }
        return this.minimumProbabilities;
    }

    @Override
    public void onPaint(Graphics2D g, int time) {
        super.onPaint(g, time);
        if (this.log != null) {
            g.setColor(Color.WHITE);
            for (Cluster.Point p : this.log) {
                this.wave.paintTickmark(g, this.wave.getAngle((Double)p.value), 40.0);
            }
        }
        if (this.minimumProbabilities != null) {
            GFProbability[] agfprobability = this.minimumProbabilities;
            int j = this.minimumProbabilities.length;
            int i = 0;
            while (i < j) {
                GFProbability m = agfprobability[i];
                m.onPaint(g);
                ++i;
            }
        }
    }
}

