/*
 * Decompiled with CFR 0.152.
 */
package execution;

import execution.IDrawable;
import execution.INotifiable;
import execution.Message;
import execution.MessageRouter;
import execution.Painter;
import execution.RobotListener$$Lambda$1;
import execution.RobotListener$$Lambda$2;
import execution.RobotListener$$Lambda$3;
import java.awt.Color;
import java.awt.Graphics2D;
import sim.Bot;
import sim.Data;
import sim.Stat;

public class RobotListener
implements INotifiable,
IDrawable {
    private Painter _painter;

    public RobotListener(Painter painter) {
        this._painter = painter;
    }

    @Override
    public void Initialize(MessageRouter router) {
        router.Subscribe(Message.Kind.PaintEnabled, RobotListener$$Lambda$1.lambdaFactory$(this));
        router.Subscribe(Message.Kind.PaintDisabled, RobotListener$$Lambda$2.lambdaFactory$(this));
        router.Subscribe(Message.Kind.PreUpdate, RobotListener$$Lambda$3.lambdaFactory$(this));
    }

    private final void PreUpdate(Message message) {
        for (Bot bot : Data.Robots.Enemies()) {
            if (!bot.Alive) continue;
            bot.Set(Stat.DAMAGE_RECEIVED_THIS_TURN, 0.0);
            bot.Set(Stat.ENERGY_RETURNED_THIS_TURN, 0.0);
            if (!((double)(message.time - bot.LastUpdated) > Data.Battle.LostTrackOfEnemyDuration)) continue;
            message.respondWith(Message.Kind.LostTrackOfEnemy).at(message.time).about(bot).send();
        }
    }

    private final void OnPaintEnabled(Message message) {
        this._painter.Register(this);
    }

    private final void OnPaintDisabled(Message message) {
        this._painter.UnRegister(this);
    }

    @Override
    public void Draw(Graphics2D e) {
        Color previous = e.getColor();
        for (Bot robot : Data.Robots.Enemies()) {
            e.setColor(robot.color);
            robot.HitBox.Draw(e);
        }
        e.setColor(Data.Robots.Self.color);
        Data.Robots.Self.HitBox.Draw(e);
        e.setColor(previous);
    }

    static /* synthetic */ void access$lambda$0(RobotListener robotListener, Message message) {
        robotListener.OnPaintEnabled(message);
    }

    static /* synthetic */ void access$lambda$1(RobotListener robotListener, Message message) {
        robotListener.OnPaintDisabled(message);
    }

    static /* synthetic */ void access$lambda$2(RobotListener robotListener, Message message) {
        robotListener.PreUpdate(message);
    }
}

