/*
 * Decompiled with CFR 0.152.
 */
package ha2;

import ha2.WaveBullet;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Gun {
    AdvancedRobot robot;
    ScannedRobotEvent e;
    static double lastEnemyHeading;
    double oldEnemyHeading = 0.0;
    ArrayList<WaveBullet> waves = new ArrayList();
    static int[] stats;
    int direction = 1;
    static double enemyVelocity;
    static int timeSinceDeccel;
    static double bearingDirection;
    static final int AIM_FACTORS = 25;
    static final int MIDDLE_FACTOR = 12;
    static Point2D enemyLocation;
    static final double MAX_DISTANCE = 900.0;
    static final int DISTANCE_INDEXES = 5;
    static final double MAX_BULLET_POWER = 3.0;
    static final double BULLET_POWER = 1.9;
    static final int VELOCITY_INDEXES = 5;
    static final int LAST_VELOCITY_INDEXES = 5;
    static final int DECCEL_TIME_INDEXES = 6;
    static final int WALL_INDEXES = 2;
    static int[][][][][][] aimFactors;
    static final double WALL_MARGIN = 18.0;
    static final double BATTLE_FIELD_WIDTH = 800.0;
    static final double BATTLE_FIELD_HEIGHT = 600.0;

    public void circular_fire() {
        double maxBP = 3.0;
        if (this.e.getDistance() > 200.0) {
            maxBP = 2.4;
        }
        double bulletPower = Math.min(maxBP, Math.min(this.robot.getEnergy() / 10.0, this.e.getEnergy() / 4.0));
        double bulletSpeed = 20.0 - 3.0 * bulletPower;
        double absBearing = this.e.getBearingRadians() + this.robot.getHeadingRadians();
        double EX = this.robot.getX() + this.e.getDistance() * Math.sin(absBearing);
        double EY = this.robot.getY() + this.e.getDistance() * Math.cos(absBearing);
        double enemyHeading = this.e.getHeadingRadians();
        double enemyHeadingChange = enemyHeading - this.oldEnemyHeading;
        this.oldEnemyHeading = enemyHeading;
        double deltaTime = 0.0;
        double predictedX = EX;
        double predictedY = EY;
        while (true) {
            double d;
            deltaTime += 1.0;
            if (!(d * bulletSpeed < Point2D.Double.distance(this.robot.getX(), this.robot.getY(), predictedX, predictedY))) break;
            predictedX += Math.sin(enemyHeading) * this.e.getVelocity();
            predictedY += Math.cos(enemyHeading) * this.e.getVelocity();
            enemyHeading += enemyHeadingChange;
            predictedX = Math.max(predictedX, 18.0);
            predictedY = Math.max(predictedY, 18.0);
            predictedX = Math.min(predictedX, this.robot.getBattleFieldWidth() - 18.0);
            predictedY = Math.min(predictedY, this.robot.getBattleFieldHeight() - 18.0);
        }
        double aim = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.robot.getX(), predictedY - this.robot.getY()));
        this.robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(aim - this.robot.getGunHeadingRadians())));
        if (this.robot.getGunHeat() == 0.0 && Math.abs(this.robot.getGunTurnRemaining()) < 10.0) {
            this.robot.setFire(bulletPower);
        }
    }

    public void circular_ognia() {
        double dy;
        double dx;
        double firepower = 350.0 / this.e.getDistance();
        double w = this.e.getHeadingRadians() - lastEnemyHeading;
        lastEnemyHeading = this.e.getHeadingRadians();
        double absbearing = this.e.getBearingRadians() + this.robot.getHeadingRadians();
        double eX = this.e.getDistance() * Math.sin(absbearing);
        double eY = this.e.getDistance() * Math.cos(absbearing);
        double db = 0.0;
        double ww = lastEnemyHeading;
        do {
            dx = this.e.getVelocity() * Math.sin(ww);
            dy = this.e.getVelocity() * Math.cos(ww);
            ww += w;
        } while ((db += 11.0) * (20.0 - 3.0 * firepower) < Point2D.distance(0.0, 0.0, eX += dx, eY += dy));
        this.robot.setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(eX, eY) - this.robot.getGunHeadingRadians())));
        if (this.robot.getGunHeat() == 0.0 && Math.abs(this.robot.getGunTurnRemaining()) < 10.0) {
            this.robot.setFire(firepower);
        }
    }

    public Gun(AdvancedRobot robot, ScannedRobotEvent e) {
        this.robot = robot;
        this.e = e;
        this.ustaw();
    }

    public Gun(AdvancedRobot robot) {
        this.robot = robot;
    }

    public void sete(ScannedRobotEvent e) {
        this.e = e;
        this.ustaw();
    }

    public void ustaw() {
        if (this.e.getDistance() > 100.0) {
            this.GFaristo();
        } else {
            this.shootprosty(this.e);
        }
    }

    public void guessfactor() {
        double absBearing = this.robot.getHeadingRadians() + this.e.getBearingRadians();
        double ex = this.robot.getX() + Math.sin(absBearing) * this.e.getDistance();
        double ey = this.robot.getY() + Math.cos(absBearing) * this.e.getDistance();
        for (int i = 0; i < this.waves.size(); ++i) {
            WaveBullet currentWave = this.waves.get(i);
            if (!currentWave.checkHit(ex, ey, this.robot.getTime())) continue;
            this.waves.remove(currentWave);
            --i;
        }
        double maxBP = 3.0;
        if (this.e.getDistance() > 200.0) {
            maxBP = 2.4;
        }
        double power = Math.min(maxBP, Math.min(this.robot.getEnergy() / 10.0, this.e.getEnergy() / 4.0));
        if (this.e.getVelocity() != 0.0) {
            this.direction = Math.sin(this.e.getHeadingRadians() - absBearing) * this.e.getVelocity() < 0.0 ? -1 : 1;
        }
        int[] currentStats = stats;
        WaveBullet newWave = new WaveBullet(this.robot.getX(), this.robot.getY(), absBearing, power, this.direction, this.robot.getTime(), currentStats);
        int bestindex = 15;
        for (int i = 0; i < 31; ++i) {
            if (currentStats[bestindex] >= currentStats[i]) continue;
            bestindex = i;
        }
        double guessfactor = (double)(bestindex - (stats.length - 1) / 2) / (double)((stats.length - 1) / 2);
        double angleOffset = (double)this.direction * guessfactor * newWave.maxEscapeAngle();
        double gunAdjust = Utils.normalRelativeAngle((double)(absBearing - this.robot.getGunHeadingRadians() + angleOffset));
        this.robot.setTurnGunRightRadians(gunAdjust);
        if (this.robot.getGunHeat() == 0.0 && gunAdjust < Math.atan2(9.0, this.e.getDistance()) && this.robot.setFireBullet(power) != null) {
            this.waves.add(newWave);
        }
    }

    public void GFaristo() {
        int distanceIndex;
        double enemyAbsoluteBearing = this.robot.getHeadingRadians() + this.e.getBearingRadians();
        Wave wave = new Wave();
        wave.wGunLocation = new Point2D.Double(this.robot.getX(), this.robot.getY());
        double enemyDistance = this.e.getDistance();
        enemyLocation = Gun.project(wave.wGunLocation, enemyAbsoluteBearing, enemyDistance);
        Rectangle2D.Double fieldRectangle = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
        int lastVelocityIndex = (int)Math.abs(enemyVelocity) / 2;
        enemyVelocity = this.e.getVelocity();
        int velocityIndex = (int)Math.abs(enemyVelocity / 2.0);
        if (velocityIndex < lastVelocityIndex) {
            timeSinceDeccel = 0;
        }
        if (enemyVelocity != 0.0) {
            bearingDirection = enemyVelocity * Math.sin(this.e.getHeadingRadians() - enemyAbsoluteBearing) > 0.0 ? 0.05833333333333333 : -0.05833333333333333;
        }
        wave.wBearingDirection = bearingDirection;
        wave.wBulletPower = Math.min(this.e.getEnergy() / 4.0, (distanceIndex = (int)(enemyDistance / 180.0)) > 1 ? 1.9 : 3.0);
        wave.wAimFactors = aimFactors[distanceIndex][velocityIndex][lastVelocityIndex][Math.min(5, timeSinceDeccel++ / 13)][fieldRectangle.contains(Gun.project(wave.wGunLocation, enemyAbsoluteBearing + wave.wBearingDirection * 13.0, enemyDistance)) ? 1 : 0];
        wave.wBearing = enemyAbsoluteBearing;
        int mostVisited = 12;
        int i = 25;
        do {
            if (wave.wAimFactors[--i] <= wave.wAimFactors[mostVisited]) continue;
            mostVisited = i;
        } while (i > 0);
        this.robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.robot.getGunHeadingRadians() + wave.wBearingDirection * (double)(mostVisited - 12))));
        this.robot.setFire(wave.wBulletPower);
        if (this.robot.getEnergy() >= 1.9) {
            this.robot.addCustomEvent((Condition)wave);
        }
    }

    public void shootprosty(ScannedRobotEvent e) {
        double firepower = 350.0 / e.getDistance();
        double fireangle = this.robot.getGunHeading() - this.robot.getHeading() - e.getBearing();
        fireangle = this.fixAngle(fireangle);
        this.robot.setTurnGunLeft(fireangle);
        if (this.robot.getGunHeat() == 0.0 && Math.abs(this.robot.getGunTurnRemaining()) < 10.0) {
            this.robot.setFire(firepower);
        }
    }

    public void shootAtEnemy(ScannedRobotEvent e) {
        double firepower = 350.0 / e.getDistance();
        double fireangle = this.robot.getGunHeading() - this.robot.getHeading() - e.getBearing() + Math.toDegrees(Math.asin(e.getVelocity() / (20.0 - 3.0 * firepower) * Math.sin(Math.toRadians(180.0 - this.robot.getHeading() - e.getBearing() + e.getHeading()))));
        fireangle = this.fixAngle(fireangle);
        this.robot.setTurnGunLeft(fireangle);
        if (this.robot.getGunHeat() == 0.0 && Math.abs(this.robot.getGunTurnRemaining()) < 10.0) {
            this.robot.setFire(firepower);
        }
    }

    public double fixAngle(double angle) {
        if ((angle %= 360.0) > 180.0) {
            return angle - 360.0;
        }
        if (angle < -180.0) {
            return angle + 360.0;
        }
        return angle;
    }

    public double quickAngle(double angle) {
        if ((angle = this.fixAngle(angle)) > 90.0) {
            return angle - 180.0;
        }
        if (angle < -90.0) {
            return angle + 180.0;
        }
        return angle;
    }

    static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    static Point2D project(Point2D sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    static {
        stats = new int[31];
        aimFactors = new int[5][5][5][6][2][25];
    }

    class Wave
    extends Condition {
        double wBulletPower;
        Point2D wGunLocation;
        double wBearing;
        double wBearingDirection;
        int[] wAimFactors;
        double wDistance;

        Wave() {
        }

        public boolean test() {
            double d;
            this.wDistance += Gun.bulletVelocity(this.wBulletPower);
            if (d > this.wGunLocation.distance(enemyLocation) - 18.0) {
                try {
                    int n = (int)Math.round(Utils.normalRelativeAngle((double)(Gun.absoluteBearing(this.wGunLocation, enemyLocation) - this.wBearing)) / this.wBearingDirection + 12.0);
                    this.wAimFactors[n] = this.wAimFactors[n] + 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Gun.this.robot.removeCustomEvent((Condition)this);
            }
            return false;
        }
    }
}

