/*
 * Decompiled with CFR 0.152.
 */
package florent;

import florent.jUtil;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import robocode.AdvancedRobot;
import robocode.RobocodeFileOutputStream;

public class FUtils {
    public static int getDistanceIndex(double distance) {
        if (distance > 400.0) {
            return 2;
        }
        if (distance > 200.0) {
            return 1;
        }
        return 0;
    }

    public static int getAccelIndex(double accel) {
        if (accel > 0.1) {
            return 2;
        }
        if (accel > -0.1) {
            return 1;
        }
        return 0;
    }

    public static int getPowerIndex(double power) {
        if (power > 2.0) {
            return 2;
        }
        if (power > 1.0) {
            return 1;
        }
        return 0;
    }

    public static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public static double angleBetween(Point2D.Double origin, Point2D.Double p1, Point2D.Double p2) {
        return jUtil.absoluteBearing(origin, p1) - jUtil.absoluteBearing(origin, p2);
    }

    public static Point2D.Double getReferencePoint(Point2D.Double start, Point2D.Double orbitCentre, double circleDir, double angle, Rectangle2D.Double BF, double length) {
        Point2D.Double newDestination;
        double distDelta = 1.6707963267948966 + angle;
        while (!BF.contains(newDestination = jUtil.projectMotion(start, jUtil.absoluteBearing(start, orbitCentre) - circleDir * (distDelta -= 0.1), length))) {
        }
        return newDestination;
    }

    public static Point2D.Double getReferencePoint(Point2D.Double start, Point2D.Double orbitCentre, double circleDir, Rectangle2D BF, double length) {
        double bestDist = 525.0;
        double closeAngle = -0.1;
        double angle = orbitCentre.distance(start) > bestDist ? closeAngle : 0.5;
        return FUtils.getReferencePoint(start, orbitCentre, circleDir, angle, (Rectangle2D.Double)BF, length);
    }

    public static Object load(String fileName, AdvancedRobot me) {
        Object o = "FNF";
        try {
            ZipInputStream zipin = new ZipInputStream(new FileInputStream(me.getDataFile(fileName)));
            zipin.getNextEntry();
            o = new ObjectInputStream(zipin).readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o;
    }

    public static void save(String fileName, String entry, Object o, AdvancedRobot me) {
        try {
            ZipOutputStream zipout = new ZipOutputStream((OutputStream)new RobocodeFileOutputStream(me.getDataFile(fileName)));
            zipout.setLevel(9);
            zipout.putNextEntry(new ZipEntry(entry));
            ObjectOutputStream out = new ObjectOutputStream(zipout);
            out.writeObject(o);
            out.flush();
            zipout.closeEntry();
            out.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public static Point2D.Double projectMotion(Point2D.Double loc, double heading, double time, double vel, double maxVel) {
        double avg = 0.0;
        int i = 0;
        while ((double)i < time) {
            avg += vel;
            vel += Math.min(vel + 1.0, maxVel);
            ++i;
        }
        double distance = (avg /= time) * time;
        return new Point2D.Double(loc.x + distance * Math.sin(heading), loc.y + distance * Math.cos(heading));
    }

    public static Point2D.Double projectMotionReverse(Point2D.Double loc, double heading, double time, double vel, double minVel) {
        double avg = 0.0;
        int i = 0;
        while ((double)i < time) {
            avg += vel;
            vel += Math.max(vel - 2.0, minVel);
            ++i;
        }
        double distance = (avg /= time) * time;
        return new Point2D.Double(loc.x + distance * Math.sin(heading), loc.y + distance * Math.cos(heading));
    }

    public static double getBulletSpeed(double power) {
        return 20.0 - power * 3.0;
    }

    public static double maxEscapeAngle(double bVel) {
        return Math.asin(8.0 / bVel);
    }

    public static double getBulletPower(double speed) {
        return (speed - 20.0) / 3.0;
    }

    public static double entropy(double[] samples) {
        double sum = 0.0;
        int i = 0;
        while (i < samples.length) {
            sum += samples[i];
            ++i;
        }
        double entropy = 0.0;
        int i2 = 0;
        while (i2 < samples.length) {
            if (samples[i2] != 0.0) {
                entropy += -samples[i2] / sum * Math.log(samples[i2] / sum) / Math.log(2.0);
            }
            ++i2;
        }
        return entropy;
    }

    public static double maxEntropy(int possibleValues) {
        return Math.log(possibleValues) / Math.log(2.0);
    }

    public static double normalizedEntropy(double[] samples) {
        return FUtils.entropy(samples) / FUtils.maxEntropy(samples.length);
    }

    public static double informationGain(double[] samples, double[][] segmentedSamples) {
        int totalSamples = 0;
        int i = 0;
        while (i < samples.length) {
            totalSamples = (int)((double)totalSamples + samples[i]);
            ++i;
        }
        double entropyS = FUtils.entropy(samples);
        int i2 = 0;
        while (i2 < segmentedSamples.length) {
            int segmentSamples = 0;
            int j = 0;
            while (j < segmentedSamples[i2].length) {
                segmentSamples = (int)((double)segmentSamples + segmentedSamples[i2][j]);
                ++j;
            }
            entropyS -= (double)segmentSamples / (double)totalSamples * FUtils.entropy(segmentedSamples[i2]);
            ++i2;
        }
        return entropyS;
    }

    public static boolean isConstant(ArrayList list) {
        return list.get(0).equals(list.get(list.size() - 1));
    }

    public static String intArrayToString(int[] array) {
        String res = "";
        int i = 0;
        while (i < array.length) {
            res = String.valueOf(res) + new Integer(array[i]).toString() + "|";
            ++i;
        }
        return res;
    }

    public static String doubleArrayToString(double[] array) {
        String res = "";
        int i = 0;
        while (i < array.length) {
            res = String.valueOf(res) + new Double(array[i]).toString() + "|";
            ++i;
        }
        return res;
    }
}

