/*
 * Decompiled with CFR 0.152.
 */
package florent;

import florent.Context;
import florent.FloatingTadpole;
import florent.WaveCommand;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.util.Utils;

public class Wave
extends Condition {
    protected static Point2D targetLocation;
    protected static double time;
    protected static AdvancedRobot robot;
    protected double lowGf;
    protected double highGf;
    protected double gf;
    protected double startBearing;
    protected double goodAngle;
    protected double fireTime;
    protected double power;
    protected double bearingDirection;
    protected double bulletVelocity;
    protected double bulletPower;
    protected double distance;
    protected Point2D.Double gunLocation;
    protected static int maxCommand;
    protected WaveCommand[] commands = new WaveCommand[maxCommand];
    protected double[][] bins = new double[maxCommand][];
    protected int[] gfs = new int[maxCommand];
    protected int commandCount = 0;
    protected static Context context;

    static {
        maxCommand = 15;
    }

    public Wave(Point2D gunLocation, double fireTime, double bearing, double power, double bearingDirection) {
        this.gunLocation = (Point2D.Double)gunLocation;
        this.fireTime = fireTime;
        this.startBearing = bearing;
        this.power = power;
        this.bearingDirection = bearingDirection;
        this.bulletVelocity = FloatingTadpole.bulletVelocity(power);
        this.bulletPower = power;
        Wave.synch();
        this.distance = this.gunLocation.distance(targetLocation);
    }

    public boolean test() {
        Wave.synch();
        if (this.distanceToImpact(targetLocation, time) < 0.0 && robot.getOthers() > 0) {
            this.arrived(targetLocation);
            robot.removeCustomEvent((Condition)this);
        }
        return false;
    }

    public double getGf() {
        return this.gf;
    }

    public double[][] getBins() {
        return this.bins;
    }

    public double arrived(Point2D enemyLocation) {
        if (robot.getOthers() < 0) {
            return -10000.0;
        }
        this.goodAngle = Utils.normalRelativeAngle((double)(FloatingTadpole.absoluteBearing(this.gunLocation, (Point2D.Double)enemyLocation) - this.startBearing));
        this.gf = this.goodAngle / this.bearingDirection / Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(this.power));
        this.lowGf = this.gf - Math.abs(Math.atan(18.0 / this.distance) / this.bearingDirection / Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(this.power)));
        this.highGf = this.gf + Math.abs(Math.atan(18.0 / this.distance) / this.bearingDirection / Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(this.power)));
        int i = 0;
        while (i < this.commandCount) {
            this.commands[i].doOnArrival(this);
            ++i;
        }
        return this.goodAngle;
    }

    public double hit(Point2D enemyLocation) {
        if (robot.getOthers() < 0) {
            return -10000.0;
        }
        this.goodAngle = Utils.normalRelativeAngle((double)(FloatingTadpole.absoluteBearing(this.gunLocation, (Point2D.Double)enemyLocation) - this.startBearing));
        this.gf = this.goodAngle / this.bearingDirection / Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(this.power));
        this.lowGf = this.gf - Math.abs(Math.atan(18.0 / this.distance) / this.bearingDirection / Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(this.power)));
        this.highGf = this.gf + Math.abs(Math.atan(18.0 / this.distance) / this.bearingDirection / Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(this.power)));
        int i = 0;
        while (i < this.commandCount) {
            this.commands[i].doOnHit(this);
            ++i;
        }
        return this.goodAngle;
    }

    public double hitBullet(Point2D enemyLocation) {
        if (robot.getOthers() < 0) {
            return -100000.0;
        }
        this.goodAngle = Utils.normalRelativeAngle((double)(FloatingTadpole.absoluteBearing(this.gunLocation, (Point2D.Double)enemyLocation) - this.startBearing));
        this.gf = this.goodAngle / this.bearingDirection / Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(this.power));
        this.lowGf = this.gf - Math.abs(Math.atan(18.0 / this.distance) / this.bearingDirection / Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(this.power)));
        this.highGf = this.gf + Math.abs(Math.atan(18.0 / this.distance) / this.bearingDirection / Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(this.power)));
        int i = 0;
        while (i < this.commandCount) {
            this.commands[i].doOnHitBullet(this);
            ++i;
        }
        return this.goodAngle;
    }

    public double distanceToImpact(Point2D location, double time) {
        return this.gunLocation.distance(location) - FloatingTadpole.bulletVelocity(this.power) * (time - this.fireTime);
    }

    public double getBulletVellocity() {
        return this.bulletVelocity;
    }

    public void addCommand(WaveCommand command) {
        if (this.commandCount == maxCommand) {
            System.out.println("max command per wave reached");
        }
        this.commands[this.commandCount] = command;
        this.bins[this.commandCount] = command.getBin();
        this.gfs[this.commandCount] = this.bins[this.commandCount] == null ? -1 : command.getBestIndex(this.distance);
        ++this.commandCount;
    }

    public double getGF(Point2D.Double location) {
        return Utils.normalRelativeAngle((double)(FloatingTadpole.absoluteBearing(this.gunLocation, location) - this.startBearing)) / this.bearingDirection / Wave.maxEscapeAngle(FloatingTadpole.bulletVelocity(this.power));
    }

    public Point2D.Double getGunLocation() {
        return this.gunLocation;
    }

    public int[] getGfs() {
        return this.gfs;
    }

    public static void synch() {
        time = context.getTime();
        targetLocation = context.getEnemyLocation();
    }

    public static void setRobot(AdvancedRobot robot) {
        Wave.robot = robot;
    }

    public static void setContext(Context context) {
        Wave.context = context;
    }

    public double getFireTime() {
        return this.fireTime;
    }

    public double getGoodAngle() {
        return this.goodAngle;
    }

    public double getBulletPower() {
        return this.bulletPower;
    }

    public double getHighGf() {
        return this.highGf;
    }

    public double getLowGf() {
        return this.lowGf;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity) * 1.4;
    }
}

