/*
 * Decompiled with CFR 0.152.
 */
package mue;

import mue.BulletData;
import mue.MovementBase;
import mue.Position;
import mue.RobotBase;
import mue.RobotData;
import mue.Util;

class CircularMovement
extends MovementBase {
    private String opponent = null;
    private boolean ahead = true;
    private double distance = 0.0;
    private long directionChangeTick = 0L;

    public CircularMovement(RobotBase robotBase) {
        super(robotBase);
    }

    public void setOpponent(String string) {
        this.opponent = string;
    }

    public String getOpponent() {
        return this.opponent;
    }

    public void setDistance(double d) {
        this.distance = d;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean isMovingStraightSince(long l) {
        return l >= this.directionChangeTick;
    }

    public void reset() {
    }

    public boolean move() {
        double d;
        double d2;
        Position position;
        if (this.opponent == null) {
            return false;
        }
        BulletData bulletData = this.getKnowledge().lastBulletFired();
        if (bulletData != null) {
            position = new Position(bulletData.getOriginX(), bulletData.getOriginY());
        } else {
            RobotData robotData = this.getKnowledge().getRobotData(this.opponent);
            if (robotData == null) {
                return false;
            }
            position = robotData.guessPosition(robotData.getTime());
        }
        double d3 = this.directionTo(position.getX(), position.getY());
        double d4 = this.distance == 0.0 ? 90.0 : (this.distanceTo(position.getX(), position.getY()) > this.distance ? 80.0 : 100.0);
        if (!this.ahead) {
            d4 = 180.0 - d4;
        }
        double d5 = (d2 = Math.abs(Util.relativeAngle(this.getHeading(), d3 + d4))) <= (d = Math.abs(Util.relativeAngle(this.getHeading(), d3 - d4))) ? d3 + d4 : d3 - d4;
        if (this.ahead && this.distanceToWall(d5) < 40.0 || !this.ahead && this.distanceToWall(d5 + 180.0) < 40.0) {
            this.directionChangeTick = this.getTime();
            this.ahead = !this.ahead;
            d4 = 180.0 - d4;
            d2 = Math.abs(Util.relativeAngle(this.getHeading(), d3 + d4));
            d = Math.abs(Util.relativeAngle(this.getHeading(), d3 - d4));
            d5 = d2 <= d ? d3 + d4 : d3 - d4;
        }
        this.setTurn(d5);
        if (this.ahead) {
            this.setAhead(21.0);
        } else {
            this.setBack(21.0);
        }
        return true;
    }
}

