package simonton.mini;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;
import java.util.List;

import robocode.*;
import robocode.util.*;

/**
 * Alas, I tried to give up this game. Maybe sometime later ...
 * 
 * This bot is my first attempt at wave surfing. Finally I'm into the mini's, so
 * there is room. It does well in the WaveSurfingChallenge2K6, but I have no
 * idea how it will perform against more complex guns. We'll see!
 * 
 * The gun is an improvement of this guy's younger brother's, WeeklongObsession.
 * 
 * CREDIT: the base of my wave surfing code was BasicGFSurfer. CREDIT: I got the
 * idea to factor dive protection into the calculation of surfing dangers from
 * Komarious.
 * 
 * More information, including version history, can be found at
 * http://robowiki.net/?WeeksOnEnd
 * 
 * @author Eric Simonton
 */
public class WeeksOnEnd extends AdvancedRobot {

	static final int BINS = 47;
	static final int WS_PROJECT = 64;
	static final int TIME_DECAY = 16; // higher -> less impact
	static final int WALKING_STICK = 122;
	static final int PATTERN_LENGTH = 30;
	static final int HEADING_SLICES = 11; // make this odd
	static final int BATTLEFIELD_WIDTH = 800;
	static final int BATTLEFIELD_HEIGHT = 600;
	// // PMC
	// static final int BATTLEFIELD_WIDTH = 1000;
	// static final int BATTLEFIELD_HEIGHT = 1000;
	static final int GF_ZERO = (BINS - 1) / 2;
	static final int ZERO_HEADING_SLICE = (HEADING_SLICES - 1) / 2;

	static final double NEW_DECAY = .875;
	static final double TARGET_DISTANCE = 800;
	static final double FIREPOWER_FACTOR = 900;
	static final double WALL_MARGIN = 17.999999999999;
	static final double MAX_RETREAT = 30 * Math.PI / 180;
	static final double MAX_DIVE_ANGLE = 45 * Math.PI / 180;
	static final double N = BATTLEFIELD_HEIGHT - WALL_MARGIN;
	static final double E = BATTLEFIELD_WIDTH - WALL_MARGIN;
	static final double S = WALL_MARGIN;
	static final double W = WALL_MARGIN;

	// movement
	static EnemyWave nextEWave;
	static ArrayList eWaves;
	static Point2D.Double myLocation;
	static double surfStats[][] = new double[5][2 * BINS];
	static double lastLatV;
	static double lastEAng;
	static double lastEDir;
	static double eEnergy;
	// static double eHeat;
	static int oDir;
	static int time;
	// // MC
	// static double energy;

	// gun
	static String eHistory;
	static String flipEHistory;
	static Map ePatterns = new HashMap();
	static int halfLastEHead;
	static int lastEVel;

	public void run() {

		oDir = 0;
		eWaves = new ArrayList();
		eHistory = flipEHistory = "";
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		do {
			turnRadarRightRadians(1);
		} while (true);
	}

	public void onScannedRobot(ScannedRobotEvent r2e) {

		int r3i;
		double r4d;

		// double eDist; use r4d
		Point2D.Double myLoc;

		// int oDir; use r3i
		// double eBPow; use r4d
		// double eAng; use r4d
		double bearing;

		// int step; use r3i
		Point2D.Double possibleLocation;
		Point2D.Double probableLocation;
		short[] nextSteps;
		String flipPattern;
		String pattern;
		String p2;
		String p3;
		double bTrav;
		double bPow;
		double eDir;
		int velocity;
		int heading;
		int i;
		// // MC
		// energy = getEnergy();

		// watch.
		// eHeat -= .1;
		if ((r4d = eEnergy - (eEnergy = r2e.getEnergy())) < 3.01 && r4d > 0.09) {
			// nextEWave.timeTillNext = (int) (10 * Rules.getGunHeat(tmp));
			nextEWave.bulletVelocity = Rules.getBulletSpeed(r4d);
			eWaves.add(nextEWave);
			// eHeat = Rules.getGunHeat(r4d);
		}
		(probableLocation = nextEWave = new EnemyWave((int) getTime()))
			.setLocation(project(myLocation =
				myLoc = new Point2D.Double(getX(), getY()), r4d =
				getHeadingRadians() + (bearing = r2e.getBearingRadians()), r2e
				.getDistance()));
		// must happen after nextEWave is made, because it uses *last*EAng
		setTurnRadarRightRadians(2 * Utils.normalRelativeAngle((lastEAng = r4d)
			- getRadarHeadingRadians()));
		// must happen after nextEWave is made, because it uses "lastLatV."
		lastLatV = getVelocity() * Math.sin(bearing);

		// ----------------------------------------------------------- movement

		// setMaxVelocity(eHeat <= .4 ? 0 : 8);

		// // Debug
		// positions.clear();
		// intensities.clear();
		// // execution speed
		// r3i = 0;
		// try { do {
		// if (((EnemyWave) eWaves.get(r3i)).impactCode(myLocation, time) > 0) {
		// eWaves.remove(r3i);
		// }
		// } while (true); } catch (IndexOutOfBoundsException done) { }

		// move.
		r3i = oDir;
		if (r3i == 0) {
			r3i = -(int) Math.signum(Math.cos(bearing));
		}
		if (getGoodness(this, r3i) < getGoodness(this, -r3i)) {
			r3i = -r3i;
		}
		setTurnRightRadians(getDesiredDH(
			myLoc,
			r3i = maybeFlipped(myLoc, r3i),
			getHeadingRadians()));
		setAhead((oDir = r3i) * Integer.MAX_VALUE);

		// ---------------------------------------------------------------- gun

		// fire.
		// setFire(bPow =
		// Math.min(Math.min(Math.min(
		// FIREPOWER_FACTOR / r4d,
		// (getEnergy() - 1) / 5), eEnergy / 4), 3));
		setFire(bPow =
			Math.min(Math.min(
				FIREPOWER_FACTOR / r2e.getDistance(),
				getEnergy() / 16), 3));
		// // PMC
		// setFire(tmp = .5);
		// //// TC
		// //setFire(tmp = 3);
		// hisLocation =
		// probableLocation =
		// project(
		// myLocation = new Point2D.Double(getX(), getY()),
		// getHeadingRadians() + e.getBearingRadians(),
		// e.getDistance());

		// memorize.
		r3i =
			encodeTable.charAt(-33
				* (halfLastEHead - (halfLastEHead =
					(heading = (int) r2e.getHeading()) / 2))
				+ (velocity = (int) Math.rint(r2e.getVelocity()))
				- lastEVel
				+ (16 + -33 * -180));
		p2 = pattern = eHistory = concat(r3i, eHistory);
		flipPattern = flipEHistory = concat(flip(r3i), flipEHistory);
		if ((r4d = lastEDir) < 0) {
			p2 = flipPattern;
			r3i = flip(r3i);
		}

		i = PATTERN_LENGTH + 1;
		try {
			do {
				if ((nextSteps =
					(short[]) ePatterns.get(p3 =
						concat(lastEVel, p2.substring(1, i)))) == null) {
					ePatterns
						.put(p3, nextSteps = new short[6 * HEADING_SLICES]);
				}
				++nextSteps[r3i];
				--i;
			} while (true);
		} catch (Exception doneOrNotEnoughHistoryOrLastHeadingNotSet) {}
		lastEDir = Math.toRadians(lastEDir + (lastEVel = velocity));

		// aim.
		 // execution speed
		 if (getGunHeat() <= 0.2) {
		// // Debug
		// positions.clear();
		// intensities.clear();
		bTrav = 0;
		do {
			try {
				r4d = Math.toRadians(r4d + velocity);
				i = PATTERN_LENGTH;
				while ((nextSteps =
					(short[]) ePatterns.get(concat(velocity, (r4d < 0
						? flipPattern
						: pattern).substring(0, i--)))) == null)
					;
				i = 0;
				do {
					if (i % 6 != 0 && nextSteps[i] > nextSteps[r3i]) {
						r3i = i;
					}
					++i;
				} while (true);
			} catch (Exception doneLoopingOrNoPatternYet) {}
			if (r4d < 0) {
				r3i = flip(r3i);
			}
			if (new Rectangle2D.Double(
				WALL_MARGIN,
				WALL_MARGIN,
				BATTLEFIELD_WIDTH - 2 * WALL_MARGIN,
				BATTLEFIELD_HEIGHT - 2 * WALL_MARGIN)
				.contains(possibleLocation =
					project(
						probableLocation,
						Math.toRadians(heading =
							heading + 2 * (r3i / 6 - ZERO_HEADING_SLICE)),
						velocity = velocity + r3i % 6 - 3))) {
				probableLocation = possibleLocation;
			} else {
				velocity = 0;
				r3i = r3i / 6 * 6;
			}
			// // debug
			// positions.add(probableLocation);
			// intensities.add(new Float(0));
			flipPattern = concat(flip(r3i), flipPattern);
			pattern = concat(r3i, pattern);
		} while ((bTrav = bTrav + Rules.getBulletSpeed(bPow)) < myLocation
			.distance(probableLocation));
		 }
		setTurnGunRightRadians(dBearing(
			myLocation,
			probableLocation,
			getGunHeadingRadians()));
	}

	/**
	 * @param step
	 * @return
	 */
	private static int flip(int step) {

		return flipTable.charAt(step);
	}

	/**
	 * @param thisStep
	 * @param pattern
	 * @return
	 */
	private static String concat(int step, String pattern) {

		return String.valueOf((char) Math.abs(step)).concat(pattern);
	}

	/**
	 * @param oDir
	 * @return
	 */
	private static double getGoodness(WeeksOnEnd r1t, int r2i) {

		int r3i;
		Point2D.Double r4p;

		EnemyWave wave;
		double goodness;
		double maxTurn;
		double h;
		int elapsed;
		int i;
		int factor;

		// int oDir; unused, passed as r2i
		// int v; unused, use r3i instead
		// Point2D.Double loc; unused, use r4p instead

		// execution speed
		 int more = 0;
		 int code;

		// // debug
		// positions.clear();
		// intensities.clear();

		r3i = (int) r1t.getVelocity();
		r4p = myLocation;
		h = r1t.getHeadingRadians();
		elapsed = 0;
		goodness = 1;
		do {
			i = 0;
			try {
				do {
					// the wave would strike this tick at my position last tick
					if (
					// execution speed
					 (code =
					(wave = (EnemyWave) eWaves.get(i)).impactCode(r4p, time
						+ elapsed)) == 0) {
						goodness =
							goodness
								* (1 - wave.surfStats[wave.getFactorIndex(r4p)]
									/ (elapsed / TIME_DECAY + 1)); // wave.timeTillNext
						// + 1);
					}
					 if (code <= 0) {
					 more = 1;
					 } else if (code > 0 && elapsed == 0) {
					 eWaves.remove(i);
					 }
					++i;
				} while (true);
			} catch (IndexOutOfBoundsException doneLooping) {}
			// // Debug
			// r1t.positions.add(r4p);
			// r1t.intensities.add(new Float(1 - goodness));
			// execution speed
			 if (more == 0) {
			 break;
			 }

			r4p =
				project(
					r4p,
					h =
						h
							+ Math.min(
								Math.max(getDesiredDH(r4p, r2i =
									maybeFlipped(r4p, r2i), h), -(maxTurn =
									Rules.getTurnRateRadians(Math.abs(r3i)))),
								maxTurn),
					r3i =
						Math.min(Math.max(
							r3i + r2i * (r3i * r2i < 0 ? 2 : 1),
							-8), 8));
			++elapsed;
		} while (elapsed < WS_PROJECT);
		return goodness;
	}

	/**
	 * @param loc
	 * @param oDir
	 * @return
	 */
	private static int maybeFlipped(Point2D.Double loc, int oDir) {

		if (dBearing(loc, nextEWave, getDesiredDH(loc, oDir, -Math.PI / 2))
			* oDir < -MAX_DIVE_ANGLE) {
			return -oDir;
		}
		return oDir;
	}

	/**
	 * @param loc
	 * @param oDir
	 * @param curH
	 * @return
	 */
	private static double getDesiredDH(Point2D.Double loc, int oDir, double curH) {

		return Utils.normalRelativeAngle(smoothWest(loc.x - W, smoothWest(E
			- loc.x, smoothWest(loc.y - S, smoothWest(N - loc.y, dBearing(
			nextEWave,
			loc,
			(TARGET_DISTANCE - nextEWave.distance(loc))
				* oDir
				* (MAX_RETREAT / TARGET_DISTANCE)), oDir *= -WALKING_STICK)
			+ Math.PI, oDir)
			+ Math.PI
			/ 2, oDir)
			- Math.PI, oDir)
			- curH);
	}

	/**
	 * @param dist
	 * @param angle
	 * @param oDir
	 * @return
	 */
	private static double smoothWest(double dist, double angle, int oDir) {

		if (
		// // execution speed
		// dist >= WALKING_STICK ||
		oDir * Math.sin(angle) <= dist) {
			return angle;
		}
		return Math.asin(dist / oDir);
	}

	/**
	 * @param source
	 * @param target
	 * @param curAngle
	 * @return
	 */
	static double dBearing(
		Point2D.Double source,
		Point2D.Double target,
		double curAngle) {

		return Utils.normalRelativeAngle(Math.atan2(
			target.x - source.x,
			target.y - source.y)
			- curAngle);
	}

	/**
	 * @param location
	 * @param angle
	 * @param distance
	 * @return
	 */
	static Point2D.Double project(
		Point2D.Double loc,
		double angle,
		double distance) {

		return new Point2D.Double(loc.x + distance * Math.sin(angle), loc.y
			+ distance
			* Math.cos(angle));
	}

	/**
	 * @param e
	 * @see robocode.Robot#onHitByBullet(robocode.HitByBulletEvent)
	 */
	public void onHitByBullet(HitByBulletEvent r1e) {

		// // MC
		// damage += Rules.getBulletDamage(e.getBullet().getPower());
		eEnergy = eEnergy + 3 * r1e.getPower();
		logHit(r1e.getBullet());
	}

	/**
	 * @param e
	 * @see robocode.Robot#onBulletHitBullet(robocode.BulletHitBulletEvent)
	 */
	public void onBulletHitBullet(BulletHitBulletEvent r1e) {

		logHit(r1e.getHitBullet());
	}

	private static void logHit(Bullet r1b) {

		EnemyWave r2w;
		Point2D.Double r3p;
		int r4i = 0;
		// Debug
		// boolean found = false;
		r3p = new Point2D.Double(r1b.getX(), r1b.getY());
		try {
			do {
				r2w = (EnemyWave) eWaves.get(r4i);
				if (r2w.impactCode(r3p, time) == 0
					&& Utils.isNear(r1b.getVelocity(), r2w.bulletVelocity)) {

					eWaves.remove(r4i);
					r4i = 0;
					do {
						r2w.surfStats[r4i] =
							Math.max(
								1 / (1 + Math.pow(
									r4i - r2w.getFactorIndex(r3p),
									2)),
								r2w.surfStats[r4i] * NEW_DECAY);
						++r4i;
					} while (true);
				}
				++r4i;
			} while (true);
		} catch (IndexOutOfBoundsException doneLooping) {}
		// if (!found) {
		// System.out.println("NO WAVE FOUND!! " + (time -
		// hisLocation.distance(location) / bullet.getVelocity()));
		// }
	}

	/**
	 * @param e
	 * @see robocode.Robot#onBulletHit(robocode.BulletHitEvent)
	 */
	public void onBulletHit(BulletHitEvent e) {

		// // TC
		// damage += Math.min(Rules.getBulletDamage(e.getBullet().getPower()),
		// eEnergy);
		// System.out.println(damage);
		eEnergy = eEnergy - Rules.getBulletDamage(e.getBullet().getPower());
	}

	/**
	 * Credit goes to the bot Troodon for the idea of making this extend
	 * Point2D.Double.
	 * 
	 * @author Eric
	 */
	static class EnemyWave extends Point2D.Double {

		double flippedHeadOnAngle;
		double bulletVelocity;
		// int timeTillNext;
		double[] surfStats;
		int fireTime;
		double oDir;

		/**
		 * @param t
		 */
		public EnemyWave(int t) {

			this.oDir = Math.signum(lastLatV + 4.9E-324);
			this.surfStats =
				WeeksOnEnd.surfStats[(int) Math.rint(Math.abs(lastLatV / 2))];
			// [dseg = (int)(Math.min((dist + 50) / 200, 3))];
			this.fireTime = time = t;
			this.flippedHeadOnAngle = lastEAng;
		}

		/**
		 * @param targetLocation
		 * @return
		 */
		int getFactorIndex(Point2D.Double targetLocation) {

			return GF_ZERO
				+ (int) ((1 + oDir
					* dBearing(targetLocation, this, flippedHeadOnAngle)
					/ Math.asin(8 / bulletVelocity)) * GF_ZERO);
		}

		/**
		 * returns < 0 when the wave is still approaching<br>
		 * returns = 0 when the wave is in impact range<br>
		 * returns > 0 when the wave has passed
		 * 
		 * These are evaluated for the position of the wave the tick AFTER the
		 * time you pass, since the wave will advance before the point moves.
		 */
		int impactCode(Point2D.Double loc, int time) {

			double r4d = bulletVelocity;
			return (int) (((time - fireTime + .5) * r4d - distance(loc)) / (25.45584412271571087843039704 + r4d / 2));
		}
	}

	// MC
	// private static double damage;
	// public void onDeath(DeathEvent e) {
	// Vector events = getAllEvents();
	// for (int i = 0; i < events.size(); ++i) {
	// if (events.get(i) instanceof HitByBulletEvent) {
	// damage += energy;
	// }
	// }
	// onWin(null);
	// }
	// public void onWin(WinEvent e) {
	// Challenge
	// double percent = damage / (getRoundNum() + 1);
	// System.out.println("Damage: " + damage
	// + " (" + percent + "/" + (100 - percent) + ")");
	// }

	// Debug
	// public void onSkippedTurn(SkippedTurnEvent e) {
	//
	// System.out.println("Skipped turn! " + getTime());
	// }
	//
	// public void onHitRobot(HitRobotEvent e) {
	//
	// System.out.println("Hit robot. " + getTime());
	// }
	//
	// public void onHitWall(HitWallEvent e) {
	//
	// System.out.println("Hit wall. " + getTime());
	// }
	//
	// List positions = new LinkedList();
	// List intensities = new LinkedList();
	//
	// public void onPaint(Graphics2D g) {
	//
	// for (int i = positions.size(); --i >= 0;) {
	// float intensity = ((Number) intensities.get(i)).floatValue();
	// intensity *= intensity;
	// g.setColor(new Color(intensity, 0, 1 - intensity));
	// Point2D.Double p = (Point2D.Double) positions.get(i);
	// g.fillOval((int) p.x - 1, (int) p.y - 1, 3, 3);
	// }
	//
	// // g.drawLine((int) myLocation.x, (int) myLocation.y,
	// // (int) hisLocation.x, (int) hisLocation.y);
	//
	// for (int i = eWaves.size(); --i >= 0;) {
	// EnemyWave ew = (EnemyWave) eWaves.get(i);
	// double dist = (getTime() - ew.fireTime) * ew.bulletVelocity;
	// for (int j = BINS; --j >= 0;) {
	// Point2D.Double p =
	// project(ew, ew.oDir
	// * (j - GF_ZERO)
	// * Math.asin(8 / ew.bulletVelocity)
	// / GF_ZERO
	// + ew.flippedHeadOnAngle
	// + Math.PI, dist);
	// float intensity = (float) ew.surfStats[GF_ZERO + j];
	// intensity = (float) Math.sqrt(intensity);
	// g.setColor(new Color(intensity, 1 - intensity, 0));
	// g.fillOval((int) p.x - 1, (int) p.y - 1, 3, 3);
	// }
	// }
	// }

	// // Retired
	// private static final Rectangle2D.Double world =
	// new Rectangle2D.Double(
	// WALL_MARGIN,
	// WALL_MARGIN,
	// BATTLEFIELD_WIDTH - 2 * WALL_MARGIN,
	// BATTLEFIELD_HEIGHT - 2 * WALL_MARGIN);
	//
	// private static double getDesiredDH(Point2D.Double loc, int oDir, double
	// curH) {
	// double angle = dBearing(
	// hisLocation,
	// loc,
	// ( TARGET_DISTANCE
	// - hisLocation.distance(loc))
	// * oDir
	// * ( MAX_RETREAT
	// / TARGET_DISTANCE))
	// + Math.PI / 2;
	// while (
	// !world.contains(
	// project(loc, angle += oDir * 0.1, oDir * WALKING_STICK)));
	// return Utils.normalRelativeAngle(angle - curH);
	// }

	// // Table Generation
	// static PrintStream out;
	// public static void main(String[] args) throws IOException {
	// out = System.out;//new PrintWriter(new FileWriter("table.txt"));
	//        
	// // encodeTable
	// line = " private static final String encodeTable = \"";
	// for (int halfDHCode = 0; halfDHCode <= 360; ++halfDHCode) {
	// int halfDH = (int) (Math.rint(Math.toDegrees(
	// Utils.normalRelativeAngle(Math.toRadians(halfDHCode * 2))))
	// / 2);
	// int dhEncode;
	// if (halfDH < -5 || halfDH > 5) {
	// dhEncode = 0;
	// } else {
	// dhEncode = 6 * (halfDH + 5);
	// }
	// //System.out.println(halfDH + " -> " + dhEncode);
	// for (int dvCode = 0; dvCode <= 32; ++dvCode) {
	// int dv = dvCode - 16;
	// int dvEncode;
	// if (halfDH < -5 || halfDH > 5 || dv < -2 || dv > 2) {
	// dvEncode = 0;
	// } else {
	// dvEncode = dv + 3;
	// }
	// print(dhEncode + dvEncode);
	// // if (dh < -10 || dh > 10 || dv < -8 || dv > 8) {
	// // print(30); // start of round
	// // } else {
	// // if (dv < -2 || dv > 2) {
	// // dvEncode = 0; // hit wall
	// // }
	// // print(dhEncode * 6 + dvEncode);
	// // }
	// }
	// }
	// end();
	//        
	// // flipTable
	// line = " private static final String flipTable = \"";
	// for (int step = 0; step < HEADING_SLICES * 6; ++step) {
	// int dhCode = ZERO_HEADING_SLICE - step / 6 + 180;
	// int dvCode = 3 - step % 6 + 16;
	// print(encodeTable.charAt(dhCode * 33 + dvCode));
	// }
	// end();
	//        
	// // line = " static final String smoothTable = \"";
	// // Point2D.Double loc = new Point2D.Double();
	// // for (int x = 0; x < 800; ++x) {
	// // for (int y = 0; y < 600; ++y) {
	// // loc.setLocation(x, y);
	// // for (int a = 0; a < 360; ++a) {
	// // for (int oDir = -1; oDir <= 1; oDir += 2) {
	// // double smoothed =
	// // smoothWest(loc.x - W,
	// // smoothWest(E - loc.x,
	// // smoothWest(loc.y - S,
	// // smoothWest(N - loc.y,
	// // Math.toRadians(a),
	// // oDir) + Math.PI,
	// // oDir) + Math.PI / 2,
	// // oDir) - Math.PI,
	// // oDir);
	// // print((int)
	// Math.rint(Math.toDegrees(Utils.normalAbsoluteAngle(smoothed))));
	// // }
	// // }
	// // }
	// // }
	// // flush();
	//        
	// System.out.println(lines + " lines total");
	// }
	// private static void print(int code) throws IOException {
	// String now = "\\" + Integer.toString(code, 8);
	// if (line.length() + now.length() > 79) {
	// flush();
	// }
	// line += now;
	// }
	// static int lines;
	// static String line;
	// private static void end() throws IOException {
	// flush();
	// out.println(";");
	// }
	// private static void flush() throws IOException {
	// out.print("\n" + line + "\"");
	// line = " + \"";
	// if (++lines % 1200 == 0) {
	// System.out.println(lines + " lines, and more to come");
	// System.in.read();
	// System.in.read();
	// }
	// }

	private static final String encodeTable =
		"\36\36\36\36\36\36\36\36\36\36"
			+ "\36\36\36\36\37\40\41\42\43\36\36\36\36\36\36\36\36\36\36\36\36\36"
			+ "\36\44\44\44\44\44\44\44\44\44\44\44\44\44\44\45\46\47\50\51\44\44"
			+ "\44\44\44\44\44\44\44\44\44\44\44\44\52\52\52\52\52\52\52\52\52\52"
			+ "\52\52\52\52\53\54\55\56\57\52\52\52\52\52\52\52\52\52\52\52\52\52"
			+ "\52\60\60\60\60\60\60\60\60\60\60\60\60\60\60\61\62\63\64\65\60\60"
			+ "\60\60\60\60\60\60\60\60\60\60\60\60\66\66\66\66\66\66\66\66\66\66"
			+ "\66\66\66\66\67\70\71\72\73\66\66\66\66\66\66\66\66\66\66\66\66\66"
			+ "\66\74\74\74\74\74\74\74\74\74\74\74\74\74\74\75\76\77\100\101\74\74"
			+ "\74\74\74\74\74\74\74\74\74\74\74\74\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1"
			+ "\2\3\4\5\0\0\0\0\0\0\0\0\0\0\0\0\0\0\6\6\6\6\6\6\6\6\6\6\6\6\6\6\7"
			+ "\10\11\12\13\6\6\6\6\6\6\6\6\6\6\6\6\6\6\14\14\14\14\14\14\14\14\14"
			+ "\14\14\14\14\14\15\16\17\20\21\14\14\14\14\14\14\14\14\14\14\14\14"
			+ "\14\14\22\22\22\22\22\22\22\22\22\22\22\22\22\22\23\24\25\26\27\22"
			+ "\22\22\22\22\22\22\22\22\22\22\22\22\22\30\30\30\30\30\30\30\30\30"
			+ "\30\30\30\30\30\31\32\33\34\35\30\30\30\30\30\30\30\30\30\30\30\30"
			+ "\30\30\36\36\36\36\36\36\36\36\36\36\36\36\36\36\37\40\41\42\43\36"
			+ "\36\36\36\36\36\36\36\36\36\36\36\36\36\44\44\44\44\44\44\44\44\44"
			+ "\44\44\44\44\44\45\46\47\50\51\44\44\44\44\44\44\44\44\44\44\44\44"
			+ "\44\44\52\52\52\52\52\52\52\52\52\52\52\52\52\52\53\54\55\56\57\52"
			+ "\52\52\52\52\52\52\52\52\52\52\52\52\52\60\60\60\60\60\60\60\60\60"
			+ "\60\60\60\60\60\61\62\63\64\65\60\60\60\60\60\60\60\60\60\60\60\60"
			+ "\60\60\66\66\66\66\66\66\66\66\66\66\66\66\66\66\67\70\71\72\73\66"
			+ "\66\66\66\66\66\66\66\66\66\66\66\66\66\74\74\74\74\74\74\74\74\74"
			+ "\74\74\74\74\74\75\76\77\100\101\74\74\74\74\74\74\74\74\74\74\74\74"
			+ "\74\74\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\2\3\4\5\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\6\6\6\6\6\6\6\6\6\6\6\6\6\6\7\10\11\12\13\6\6\6\6\6\6\6\6\6\6"
			+ "\6\6\6\6\14\14\14\14\14\14\14\14\14\14\14\14\14\14\15\16\17\20\21\14"
			+ "\14\14\14\14\14\14\14\14\14\14\14\14\14\22\22\22\22\22\22\22\22\22"
			+ "\22\22\22\22\22\23\24\25\26\27\22\22\22\22\22\22\22\22\22\22\22\22"
			+ "\22\22\30\30\30\30\30\30\30\30\30\30\30\30\30\30\31\32\33\34\35\30"
			+ "\30\30\30\30\30\30\30\30\30\30\30\30\30\36\36\36\36\36\36\36\36\36"
			+ "\36\36\36\36\36\37\40\41\42\43\36\36\36\36\36\36\36\36\36\36\36\36"
			+ "\36\36";

	private static final String flipTable =
		"\74\101\100\77\76\75\66\73\72\71"
			+ "\70\67\60\65\64\63\62\61\52\57\56\55\54\53\44\51\50\47\46\45\36\43"
			+ "\42\41\40\37\30\35\34\33\32\31\22\27\26\25\24\23\14\21\20\17\16\15\6"
			+ "\13\12\11\10\7\0\5\4\3\2\1";
}
