package zyx.micro;

import java.awt.Color;
import java.util.ArrayList;

import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Ant extends AdvancedRobot {
  private static final double HALF_PI = Math.PI * 0.53;
  private static final int BINS = 47;
  private static final double BINS_2 = (BINS - 1) * 0.5;
  //private static final double MAX_ESCAPE_ANGLE_2 = 0.60824557891020961807986752264699;
  //private static final double MAX_ESCAPE_ANGLE_3 = 0.81433994212652530966355998541367;
  private static final double MAX_ESCAPE_ANGLE = 0.60824557891020961807986752264699;

  private static double old_energy_;
  private static double direction_;

  private static ArrayList<Wave> waves_;
  private static int enemy_direction_ = -1;
  private static boolean escaping_;
  private static double guess_stats_[][] = new double[3][BINS]; 
  public void run() {
    setAdjustGunForRobotTurn(true);
    setAdjustRadarForGunTurn(true);
    setAllColors(Color.BLACK);
    waves_ = new ArrayList<Wave>();
    direction_ = -1;
    escaping_ = false;
    onRobotDeath(null);
    while ( true ) {
      execute();
    }
  }
  public void onRobotDeath(RobotDeathEvent event) {
    setTurnRadarRightRadians(1000);
  }
  public void onScannedRobot(ScannedRobotEvent event) {
    if ( getDistanceRemaining() == 0 ) {
      escaping_ = false;
      double fire_power = old_energy_ - event.getEnergy();
      if ( fire_power > 0 ) {
        setAhead(40 * direction_);
      }
    }
    setTurnRightRadians(Utils.normalRelativeAngle(event.getBearingRadians() + HALF_PI));
    old_energy_  = event.getEnergy();
    Wave new_wave = new Wave();
    double absolute_bearing = new_wave.angle = getHeadingRadians() + event.getBearingRadians();
    setTurnRadarRightRadians(Utils.normalRelativeAngle(absolute_bearing - getRadarHeadingRadians()) * 2.1);
    double distance;
    double enemy_x = (new_wave.x = getX()) + Math.sin(absolute_bearing) * (distance = event.getDistance());
    double enemy_y = (new_wave.y = getY()) + Math.cos(absolute_bearing) * distance;
    int location = new_wave.location = distance <= 300 ? (distance <= 75 ? 0 : 1) : 2;
    //out.printf("scan time: %d\n", getTime());
    for ( int i = 0; i < waves_.size(); ++i ) {
      Wave wave = waves_.get(i);
      if ( Math.sqrt(Math.pow(wave.x - enemy_x, 2) + Math.pow(wave.y - enemy_y, 2)) <= (wave.travelled += 14) ) {

        int index = (int)Math.round(BINS_2 * ((
            ((/*Math.max(-1,*/ 
                /*Math.min(1,*/ 
                    Utils.normalRelativeAngle(
                        Math.atan2(enemy_x - wave.x, enemy_y - wave.y) - wave.angle
                     ) / MAX_ESCAPE_ANGLE
                )
            ) * wave.direction
         ) + 1));
        for ( int j = 0; j < BINS; ++j ) {
          double smoothing;
          /**
          guess_stats_[0][j] += 1.0 / (Math.pow(0 - wave.location, 2) + smoothing);
          guess_stats_[1][j] += 1.0 / (Math.pow(1 - wave.location, 2) + smoothing);
          guess_stats_[2][j] += 1.0 / (Math.pow(2 - wave.location, 2) + smoothing);
          /**/
          guess_stats_[wave.location][j] += 5 * (smoothing = (wave.sync ? 0.2 : 0.1) / (Math.pow(j - index, 2) + 1));
          guess_stats_[(wave.location + 1) % 3][j] += smoothing;
          guess_stats_[(wave.location + 2) % 3][j] += smoothing;
          /**
          RollAverage(guess_stats_[0], j, 1.0 / (Math.pow(0 - wave.location, 2) + smoothing));          
          RollAverage(guess_stats_[1], j, 1.0 / (Math.pow(1 - wave.location, 2) + smoothing));          
          RollAverage(guess_stats_[2], j, 1.0 / (Math.pow(2 - wave.location, 2) + smoothing));
          /**
          RollAverage(guess_stats_[0], j, 1.0 / smoothing);          
          RollAverage(guess_stats_[(wave.location + 1) % 3], j, 0.5 / smoothing);          
          RollAverage(guess_stats_[(wave.location + 2) % 3], j, 0.5 / smoothing);          
          /**/          
        }
        waves_.remove(i--);
      }
    }
    if ( event.getVelocity() != 0 ) {
      enemy_direction_ = ( Math.sin(event.getHeadingRadians() - absolute_bearing) * event.getVelocity() < 0 ) ? -1 : 1;
    }
    int best = BINS - 1;
    for ( int i = 0; i < BINS; ++i ) {
      if ( guess_stats_[location][i] > guess_stats_[location][best] ) {
        best = i;
      }
    }
    setTurnGunRightRadians(
      Utils.normalRelativeAngle(
        absolute_bearing -
        getGunHeadingRadians() +
        (new_wave.direction = enemy_direction_) * (best / BINS_2 - 1) * MAX_ESCAPE_ANGLE
      )
    );
    if ( setFireBullet(2) != null ) {
      new_wave.sync = true;
    }
    waves_.add(new_wave);
  }
  /*
  private void RollAverage(double[] stats, int index, double value) {
    stats[index] = (stats[index] * 23 + value) / 23;
  }
  */
  public void onBulletHit(BulletHitEvent event) {
    old_energy_ -= 10;
  }
  public void onHitByBullet(HitByBulletEvent event) {
    //old_energy_ += Rules.getBulletHitBonus(event.getPower());
    old_energy_ += 9;
    //direction_ = -1.2 * direction_;
    if ( !escaping_ ) setAhead(ChangeDirection());
    //out.printf("%f\n", direction_);
  }
  public void onHitWall(HitWallEvent event) {
    setAhead(ChangeDirection());
  }
  private double ChangeDirection() {
    escaping_ = true;
    return 120 * (direction_ *= ((Math.abs(direction_) > 2.5) ? -0.8 : -1.2));
  }
  /*
  public void onPaint(Graphics2D g) {
    //out.printf("paint time: %d\n", getTime());
    g.setColor(Color.RED);
    for (Wave wave : waves_) {
      Painter.Circle(g, wave.x, wave.y, wave.travelled, 5);
    }
  }
  */
}
