package tjk;

import robocode.*;
import robocode.util.Utils;
import tjk.universe.Universe;
import tjk.offense.Gun;
import tjk.defense.Wheels;
import tjk.utils.MovementPredictor;
import tjk.utils.FastTrig;
import java.awt.Color;
import java.awt.Graphics2D;

/**
 * DeBroglie - a robot by tkiesel
 * Copyright (c) 2012 Tom Kiesel (Tkiesel @ Robowiki)
 *
 * See individual source files for licenses.
 *
 * This software is provided 'as-is', without any express or implied warranty. In no event will the authors be held liable for any damages arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose, including commercial applications, and to alter it and redistribute it freely, subject to the following restrictions:
 * 
 *     1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. 
 *        If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 * 
 *     2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 * 
 *     3. This notice may not be removed or altered from any source distribution.
 * 
 */

public class deBroglie extends AdvancedRobot
{
	
	public static boolean isTC;
	public static boolean isMC;
	public static boolean isASTC;
	
	private static Universe universe = null;
	private static Gun gun = null;
	private static Wheels wheels = null;
	
	private static int skipped = 0;
	
	private static boolean initialized = false;
	private static boolean trigReady = false;
	
	public deBroglie()
	{
		this(false,false,false);
	}

	public deBroglie(boolean isTC, boolean isASTC, boolean isMC)
	{
		deBroglie.isTC = isTC || isASTC;
		deBroglie.isMC = isMC;
		deBroglie.isASTC = isASTC;
	}
	
	/**
	 * run: DeBroglie's default behavior
	 */
	public void run() {
		
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		
		setColors(new Color(148,95,38), new Color(186,127,59), new Color(223,173,112), Color.WHITE, new Color(206,182,146));
		MovementPredictor.setBFSize(getBattleFieldWidth(), getBattleFieldHeight());
		
		// Set up FastTrig, Universe, Wheels, Gun
		initialize();
		
		setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
		
		while (true)
		{
			if ( !initialized )
			{
				initialize();
			}
			else if (getRadarTurnRemainingRadians() == 0) {
				if ( initialized )
				{
					// If initialized, quick turn toward enemy location.
					setTurnRadarRightRadians(2.0*Utils.normalRelativeAngle(FastTrig.atan2( universe.getEnemy().getX()-universe.getMe().getX() , universe.getEnemy().getY()-universe.getMe().getY() ) - getRadarHeadingRadians())*Double.POSITIVE_INFINITY);
				}
				else
				{
					setTurnRadarRightRadians(5000000);
				}
        	}
			execute();
		}
	}

	// Set up all Objects.
	private void initialize()
	{
		if ( initialized )
		{
			return;
		}
	
		if ( !trigReady )
		{
			try
			{
				FastTrig.init();
				trigReady = true;
				System.out.println("FastTrig ready!!");
			}
			catch ( Exception ex )
			{
				trigReady = false;
				System.out.println("Failed to initialize FastTrig!!");
			}
		}
	
		if ( universe == null )
		{
			try
			{
				universe = new Universe(this);
				universe.init();
				System.out.println("Universe ready!!");
			}
			catch ( Exception ex )
			{
				universe = null;
				System.out.println("Failed to initialize Universe!!");
			}
		}
		
		if ( wheels == null && universe != null )
		{
			try
			{
				wheels = new Wheels(this,universe);
				System.out.println("Wheels ready!!");
			}
			catch ( Exception ex )
			{
				wheels = null;
				System.out.println("Failed to initialize Wheels!!");
			}
		}
		
		if ( gun == null && wheels != null && universe != null ) 
		{
			try
			{
				gun = new Gun(this,universe,wheels);
				System.out.println("Gun ready!!");
			}
			catch ( Exception ex )
			{
				gun = null;
				System.out.println("Failed to initialize Gun!!");
			}
		}
		
		initialized = trigReady && universe != null && wheels != null && gun != null;
		if ( initialized )
		{
			System.out.println("Ready to fight!!");
		}
		else
		{
			System.out.println("Initialization failure!!");
		}
	}

	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		
		if ( !initialized )
		{
			return;
		}
		
		// Update Universe.
		universe.update(e);
		
		// Move
		if (!isTC)
		{
			wheels.onScannedRobot();
		}
	
		// Shoot
		if (!isMC)
		{
			gun.onScannedRobot();
		}
	
		// Radar
		double radarTurn = universe.getMe().headingToEnemy() - getRadarHeadingRadians();
		setTurnRadarRightRadians(2.0*Utils.normalRelativeAngle(radarTurn));
	}

	/**
	 * onHitByBullet: What to do when you're hit by a bullet
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		if ( getRadarTurnRemaining() < 0.00000001)
		{
			setTurnRadarRightRadians(2.0*Utils.normalRelativeAngle(FastTrig.atan2( universe.getEnemy().getX()-universe.getMe().getX() , universe.getEnemy().getY()-universe.getMe().getY() ) - getRadarHeadingRadians())*Double.POSITIVE_INFINITY);
		}
		if (!isTC)
		{
			wheels.onHitByBullet(e);
		}
	}
	
	/**
	 * onHitWall: What to do when you hit a wall
	 */
	public void onHitWall(HitWallEvent e) {
	}

	public void onBulletHitBullet(BulletHitBulletEvent e)
	{
		if (!isTC)
		{
			wheels.onBulletHitBullet(e);
		}
		universe.onBulletHitBullet(e);
	}

	public void onDeath(DeathEvent e)
	{
		universe.onDeath(e);
	}

	public void onWin(WinEvent e)
	{
		universe.onWin(e);
	}

	public void onRoundEnded(RoundEndedEvent e)
	{
		universe.onRoundEnded(e);
		if (!isTC)
		{
			wheels.onRoundEnded(e);
		}
		if (!isMC)
		{
			gun.onRoundEnded();
		}
		System.out.println("Total skipped turns = " + skipped); 
	}

	public void onSkippedTurn(SkippedTurnEvent e)
	{
		if ( getRadarTurnRemaining() < 0.00000001)
		{
			setTurnRadarRightRadians(2.0*Utils.normalRelativeAngle(FastTrig.atan2( universe.getEnemy().getX()-universe.getMe().getX() , universe.getEnemy().getY()-universe.getMe().getY() ) - getRadarHeadingRadians())*Double.POSITIVE_INFINITY);
		}
		skipped++;
		//System.out.println("Skipped turn " + e.getSkippedTurn());
	}

	public void onPaint(Graphics2D g)
	{
		universe.paint(g);
		wheels.paint(g);
	}

}
																																																		