package jep.intelligence;

import java.util.*;

/**
 * MyClass - a class by (your name here)
 */
public class EnemyMap extends HashMap
{
	public Enemy closestEnemy() {
		Iterator enemyIterator = (this.values()).iterator();
		double minDistance = 1000000.0;
		Enemy closestEnemy = null;
		Enemy currEnemy;
		
		while (enemyIterator.hasNext()) {
			currEnemy = (Enemy) (enemyIterator.next());
			if (currEnemy.getDistance() < minDistance) {
				minDistance = currEnemy.getDistance();
				closestEnemy = currEnemy;
			}
		}
		return closestEnemy;
	}
	
	public Enemy oldestEnemy() {
		Iterator enemyIterator = (this.values()).iterator();
		long oldestScan = 0;
		Enemy oldestEnemy = null;
		Enemy currEnemy;
		
		while (enemyIterator.hasNext()) {
			currEnemy = (Enemy) (enemyIterator.next());
			if (currEnemy.getLastScanned() > oldestScan) {
				oldestScan = currEnemy.getLastScanned();
				oldestEnemy = currEnemy;
			}
		}
		return oldestEnemy;
	}
	
	public Enemy weakestEnemy() {
		Iterator enemyIterator = (this.values()).iterator();
		double lowestEnergy = 10000.0;
		Enemy weakestEnemy = null;
		Enemy currEnemy;
		
		while (enemyIterator.hasNext()) {
			currEnemy = (Enemy) (enemyIterator.next());
			if (currEnemy.getEnergy() < lowestEnergy) {
				lowestEnergy = currEnemy.getEnergy();
				weakestEnemy = currEnemy;
			}
		}
		return weakestEnemy;
	}
}
