package wiki.mini;
import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.awt.Color;
import java.util.zip.*;
import java.util.*;
import java.io.*;

// Use this code under the conditions of the combination of the following restrictions
// 1. http://robowiki.net/?BlackPearl/Code
// 2. http://robowiki.net/?RWPCL
// In short it means that if you use any of the code here you must:
// 1. Tell Jim Bishop (jim at jekl dot com) about it
// 2. Release your bot under the RWPCL
//
// BlackDestroyer, by Jim Bishop (guess factor gun) and PEZ (flattener movement).
// $Id: BlackDestroyer.java,v 1.1 2004/01/01 14:40:25 peter Exp $
public class BlackDestroyer extends AdvancedRobot {
    private static final double 	WALL_MARGIN		        = 25D;
    private static final double 	MAX_VELOCITY		        = 8D;
    private static final double 	GUESS_FACTORS 			= 17;
    private static Point2D rLocation = new Point2D.Double();
    private static int statBuffer[][][][];
    private double moveAngle = 0.2;
    private double eFirePower = 3D;
    private int eDirection;
    private double eEnergy = 100D;
    private double eDelta = 0D;
    private double eX, eY;
    private double eAbsBearing, eVelocity, eDeltaHeading, eDistance, eBearing, eLastVelocity;
    private static String targetName;
    private static boolean save;
    private List waves;

    public void run() {
	setColors(Color.BLACK, Color.MAGENTA, Color.MAGENTA);
	waves = new ArrayList();
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	save = (getOthers() == 1);	//Only save data if we are in a 1-v-1 engagement, otherwise the data will be polluted
	do {
	    turnRadarRightRadians(Double.POSITIVE_INFINITY);
	} while(true);
    }

    public void onScannedRobot(ScannedRobotEvent e) {		
	rLocation.setLocation(getX(), getY());
	//Gather target information
	targetName = e.getName();		//Not the best way to do this but it works for what we are trying to accomplish
	eX = getX() + Math.sin(eAbsBearing) * (eDistance = e.getDistance());
	eY = getY() + Math.cos(eAbsBearing) * eDistance;

	double latVel = (eVelocity = e.getVelocity()) * Math.sin(e.getHeadingRadians() - (eAbsBearing = Utils.normalRelativeAngle(getHeadingRadians() + (eBearing = e.getBearingRadians()))));
	eDirection = (latVel > 0 ? 1 : -1);
	int latVelIndex = (int) (Math.abs(latVel) / 3);
	int distanceIndex = Math.min(10, (int) eDistance / 100);
	double accelDiff = Math.round(Math.abs(eVelocity) - Math.abs(eLastVelocity));
	int accellIndex = (accelDiff == 0 ? 0 : (accelDiff > 0 ? 2 : 1));

        double eEnergyLost = eEnergy - e.getEnergy();
        eEnergy = e.getEnergy();
        if (eEnergyLost >= 0.1 && eEnergyLost <= 3.0) {
            eFirePower = eEnergyLost;
        }
	double firePower = Math.max(Math.min(Math.min(Math.min(getEnergy() * .2, eEnergy * .25), 950/eDistance), 3), .1);


	//Statistics
	doStats();

	move();

	//Radar
	setTurnRadarRightRadians(Math.sin(eAbsBearing - getRadarHeadingRadians()));

	//Gun 
	int stats[] = statBuffer[accellIndex][latVelIndex][distanceIndex];
	int bestIndex = (int)((GUESS_FACTORS -1) / 2);
	for (int i = 0; i < stats.length ; i++) {
	    if (stats[i] > stats[bestIndex])
		bestIndex = i;
	}

	setTurnGunRightRadians(robocode.util.Utils.normalRelativeAngle(eAbsBearing - getGunHeadingRadians() + (getGuessAngle(bestIndex, firePower))));
	if (getGunHeat() == 0 && firePower > 0) {
	    setFire(firePower);
	    Wave w = new Wave();
	    w.accelIndex = accellIndex;
	    w.distanceIndex = distanceIndex;
	    w.latVelIndex = latVelIndex;
	    w.wDirection = eDirection;
	    w.eventTime = getTime();
	    w.shotOrigin = new Point2D.Double(getX(), getY());
	    w.shotPower = firePower;
	    w.startingAbsTargetBearing = eAbsBearing;
	    w.maxAnglePossible = Math.asin(8D / (20 - (3 * firePower)));
	    waves.add(w);
	}

	//Housekeeping
	eLastVelocity = eVelocity;
    }

    /** Save the data if I win the round */
    public void onWin(WinEvent e) {
	if (save)
	    writeObject(targetName);
    }

    void move() {
	Point2D destination = null;
	Point2D eLocation = new Point2D.Double(eX, eY);
	double bulletTravelTime = eDistance / bulletVelocity(eFirePower);
	if (Math.random() < Math.min(0.14, Math.pow(2.4 / bulletTravelTime, 1.08))) {
	    moveAngle *= -1;
	}
	for (int i = 0; i < 2; i++) {
	    double tries = 0;
	    do {
		destination = vectorToLocation(absoluteBearing(eLocation, rLocation) + moveAngle,
			eDistance * (1.1 - tries / 100.0), eLocation);
		tries++;
	    } while (tries < 40 && !fieldRectangle(WALL_MARGIN).contains(destination));
	    if (!fieldRectangle(WALL_MARGIN).contains(destination)) {
		moveAngle *= -1;
	    }
	    else {
		break;
	    }
	}
	goTo(destination);
    }


    RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin,
	    getBattleFieldWidth() - margin * 2, getBattleFieldHeight() - margin * 2, 75, 75);
    }

    void goTo(Point2D destination) {
        double angle = Utils.normalRelativeAngle(absoluteBearing(rLocation, destination) - getHeadingRadians());
	double turnAngle = Math.atan(Math.tan(angle));
        setTurnRightRadians(turnAngle);
        setAhead(rLocation.distance(destination) * (angle == turnAngle ? 1 : -1));
	setMaxVelocity(Math.abs(getTurnRemaining()) > 25 ? 0 : MAX_VELOCITY);
    }

    static double bulletVelocity(double power) {
        return 20 - 3 * power;
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
	return vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length,
            sourceLocation.getY() + Math.cos(angle) * length);
	return targetLocation;
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    /** Runs through the waves to determine aiming adjustment */
    //I would normally use an Iterator here but this is smaller and I need the bytes
    public void doStats() {
	if (statBuffer == null) {
	    initializeStats(targetName);
	}
	int i = 0;
	while (i < waves.size()) {
	    Wave w = (Wave) waves.get(i);
	    if (w.hasReached(getTime(),eX,eY)) {
		statBuffer[w.accelIndex][w.latVelIndex][w.distanceIndex][w.getGuessIndex(eX,eY)]++;
		waves.remove(i);
	    }
	    i++;
	}
    }

    /** Figures the Guess Angle Radians to offset the gun by */
    private double getGuessAngle(int guessIndex, double firePower) {
	if (eEnergy == 0.0) {
	    return 0.0;
	}
	return (guessIndex - ((GUESS_FACTORS - 1) / 2)) / ((GUESS_FACTORS - 1) / 2) * Math.asin(8.0 / (20 - (3 * firePower))) * eDirection;
    }

    /** Retrieves the stats buffer from disc if available:
     * otherwise initialize with default values
     */
    private void initializeStats(String target) {
	if ((statBuffer = (int[][][][]) readObject(target)) == null) {
	    statBuffer = new int[3][3][11][(int)GUESS_FACTORS];
	}
    }

    /** Method to read data from disc. Taken from SandboxMini */
    Object readObject(String fileName) { //returns an object read from file (could be an array, collection, anything other than a primative) from the specified file
	try {
	    ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(getDataFile(fileName))));
	    Object o = ois.readObject();
	    ois.close();
	    return o;
	} catch (Exception e) {
	    //Should do something here but alas it is too big
	    //e.printStackTrace();
	}
	return null;
    }

    /** Method to save data to disc. Taken from SandboxMini */
    synchronized void writeObject(String fileName) {
	ObjectOutputStream oos = null;
	try {
	    oos = new ObjectOutputStream(new GZIPOutputStream(new RobocodeFileOutputStream(getDataFile(fileName))));
	    oos.writeObject(statBuffer);
	    oos.close();
	} catch (IOException e) {
	    //Should do something here but alas it is too big
	    //e.printStackTrace();
	}
    }

    /** Jekyl's implementation of a Wave (mostly) */
    public class Wave {
	public Point2D.Double shotOrigin;
	public double shotPower;
	public double startingAbsTargetBearing;
	public double maxAnglePossible;
	public long eventTime;
	public int distanceIndex;
	public int latVelIndex;
	public int accelIndex;
	public int wDirection;

	/** Method determines if the wave has traveled far enough to strike the target */
	public boolean hasReached(long timeNow, double x, double y) {
	    return (((timeNow - eventTime) * (20 - (3 * shotPower))) >= shotOrigin.distance(x,y));
	}

	/** Determines the correct guess angle that would have hit */
	public int getGuessIndex(double x, double y) {
	    double currentAbsBearingFromShotOrigin = Math.atan2(x - shotOrigin.getX(), y - shotOrigin.getY());
	    return (int) Math.max(0, Math.min((GUESS_FACTORS - 1),(int) Math.round(((((Utils.normalRelativeAngle(currentAbsBearingFromShotOrigin - startingAbsTargetBearing) * wDirection) / maxAnglePossible) * ((GUESS_FACTORS - 1) / 2)) + ((GUESS_FACTORS - 1) / 2)))));
	}
    }  //End Wave
}
