package brainfade.utils;

import robocode.*;
import java.io.*;
import java.util.*;

public class Learning implements Serializable
{
    final int numOfOpps = 10;
    final int numOfSegments = 10;
    final int magicNumber = 20;
    
    Score[][][] scores;
    boolean[][][] tickSheet;
    
    Hashtable enemies;
    
    int currentEnemy = -1;
    int currentSegment = -1;
    int currentMagicNumber = -1;
    
    int roundNum = 99999;
    
    double increment;
    
    public Learning()
    {
        scores = new Score[numOfOpps][numOfSegments][magicNumber];
        tickSheet = new boolean[numOfOpps][numOfSegments][magicNumber];
        increment = 1;
        enemies = new Hashtable();
        
        for(int i=0; i<numOfOpps; i++)
        {
            for(int j=0; j<numOfSegments; j++)
            {
                for(int k=0; k<magicNumber; k++)
                {
                    scores[i][j][k] = new Score();
                    tickSheet[i][j][k]  = false;
                }
            }
        }
    }
    
    public void onScannedRobot(ScannedRobotEvent e, AdvancedRobot robot) 
    {
        if(robot.getRoundNum()<roundNum)
        {
            setEnemyIndex(e.getName());
            setCurrentValueIndex();
            System.out.println("We're initialising it...");
        }
        
        roundNum = robot.getRoundNum();
        
        getCurrentScore().onScannedRobot(e, robot); 
    }
    
    public void onBulletHit(BulletHitEvent e) 
    {
        getCurrentScore().onBulletHit(e); 
    }
    
    public void onHitByBullet(HitByBulletEvent e) 
    {
        getCurrentScore().onHitByBullet(e); 
    }
    
    public void onWin(WinEvent e) 
    {
        getCurrentScore().onWin(e); 
    }
    
    public void onDeath(DeathEvent e) 
    {
        getCurrentScore().onDeath(e); 
    }
    
    public void atEnd()
    {
        roundNum = 6543216;
    }
    
    public void setEnemyIndex(String name)
    {
        if(enemies.containsKey(name))
        {
            currentEnemy = ((Integer)enemies.get(name)).intValue();
        }
        else
        {        
            currentEnemy = enemies.size();
            enemies.put(name, new Integer(currentEnemy));
        }
    }
    
    public void setCurrentValueIndex()
    {
        for(int i=0; i<numOfSegments; i++)
        {
            for(int j=0; j<magicNumber; j++)
            {
                if(scores[getEnemyIndex()][i][j].getScore(0)==0)
                {
                    System.out.println("We've picked the magic number");
                    currentSegment = i;
                    currentMagicNumber = j;
                    return;
                }
                System.out.println("Ignoring Magic Number " + (j+1));
            }
            System.out.println("Ignoring Segment Count " + (i+1));
        }   
        
        currentSegment = 0;
        currentMagicNumber = 0;
    }
    
    public int getEnemyIndex()
    {
        return currentEnemy;
    }
    
    public int getSegmentCount()
    {
        return currentSegment;
    }
    
    public int getMagicIndex()
    {
        return currentMagicNumber;
    }
    
    public Score getCurrentScore()
    {
        return scores[getEnemyIndex()][getSegmentCount()][getMagicIndex()];
    }
    
    public String getCurrentValue()
    {
        return "Segment Count = " + (currentSegment+2) + "\nMagic Number = " + (currentMagicNumber+1);
    }
    
    public double getCurrentSectorValue(int segmentToUse, int magicNumberToUse)
    {
        double myValue = 0;
        double theirValue = 0;
        
        for(int i=0; i<numOfOpps; i++)
        {
            myValue += scores[i][segmentToUse][magicNumberToUse].getScore(0);
            theirValue += scores[i][segmentToUse][magicNumberToUse].getScore(1);
        }
        
        return myValue/theirValue;
    }
    
    
    public String getBestValue()
    {
        double bestVal = 0;
        int bestSegmentCount = 0;
        int bestMagicNumber = 0;
        
        for(int i=0; i<numOfSegments; i++)
        {
            for(int j=0; j<magicNumber; j++)
            {
                if(getCurrentSectorValue(i, j)>bestVal)
                {
                    bestVal = getCurrentSectorValue(i, j);
                    bestSegmentCount = i;
                    bestMagicNumber = j;
                }
            }
        }
        
        return "Segment Count = " + (bestSegmentCount+2) + "\nMagic Number = " + (bestMagicNumber+1);
    }
}


