package ar.horizon.components;

import ar.horizon.Component;
import robocode.*;

import static java.lang.Math.*;
import static ar.horizon.util.Util.*;

/**
 * This is a "wide lock"; see <a
 * href="http://robowiki.net/wiki/Radar#Wide_lock">
 * http://robowiki.net/wiki/Radar#Wide_lock</a>.
 * 
 * @author Aaron Rotenberg
 */
public class RadarLock extends Component {
	@Override
	public void onTickBegin() {
		robot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	}

	@Override
	public void onScannedRobot(ScannedRobotEvent e) {
		double baseTurn =
				angleDifference(myRecording.getEnemyAbsoluteBearing(),
						robot.getRadarHeadingRadians());
		double arcToScan =
				min(atan(ROBOT_WIDTH / e.getDistance()),
						RADAR_TURN_RATE_RADIANS);
		robot.setTurnRadarRightRadians(baseTurn + sign(baseTurn) * arcToScan);
	}
}
