package Legend;
import robocode.*;
public class Qetro extends AdvancedRobot
{
	double moveDirection = 1;
	double previousEnergy = 100;
	double avoid;
	public void run() {
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		while(true) {
			// Replace the next 4 lines with any behavior you would like
			turnRadarRight(360);
		}
	}
	public void onScannedRobot(ScannedRobotEvent e) {
		double absoluteBearing = e.getBearingRadians() + getHeadingRadians();
		double latVel= e.getVelocity()  * Math.sin(e.getHeadingRadians() - absoluteBearing);
		double goalDirection = e.getBearing() - 90;
	
		setTurnRadarRightRadians(robocode.util.Utils.normalRelativeAngle(absoluteBearing-getRadarHeadingRadians()) * 1.9);
		double gunTurn = robocode.util.Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()) + latVel/22;
		setTurnGunRightRadians(gunTurn);
		setTurnRightRadians(goalDirection);
	    double changeInEnergy =
     	previousEnergy-e.getEnergy();
    	if (changeInEnergy>0 && changeInEnergy<=3) {      	
			moveDirection = -moveDirection;
        	setAhead((e.getDistance()/4+25)*moveDirection);
			avoid = 0;
			
   		}
 
    	fire(3);
   		previousEnergy = e.getEnergy();
  
	}
		
	public void onHitWall(HitWallEvent e) {
		moveDirection = -moveDirection;
		setAhead(200 * moveDirection);
	}
	public void onHitByBullet(HitByBulletEvent e) {
		setAhead(30 * moveDirection);
	}
	public void onHitRobot(HitRobotEvent e) {
		moveDirection *= -1;
	}
}
