/*
 * Written by Kinsen Choy
 */

package kinsen.melee;

/**
 * Bullet - A class that contains bullet information.
 */
public class Bullet
{
	// Bullet properties -- set on initialization
	private double myStartX, myStartY;
	private double myHeading;
	private double myFirePower;
	private long myFireTime;

	// Calculated by class
	private double myVelocity;

	/*
	 * Bullet: Creates a new instance of Bullet and sets its properties
	 */
	public Bullet(double startX, double startY, double heading, double firePower, long fireTime)
	{
		myStartX = startX;
		myStartY = startY;
		myHeading = heading;
		myFirePower = firePower;
		myFireTime = fireTime;

		myVelocity = 20 - 3 * firePower;
	}

	/*
	 * Returns bullet properties
	 */
	public double getStartX()
	{
		return myStartX;
	}

	public double getStartY()
	{
		return myStartY;
	}

	public double getHeading()
	{
		return myHeading;
	}

	public double getFirePower()
	{
		return myFirePower;
	}

	/* 
	 * getCurrentX: Returns x-coordinate of bullet at the given time
	 */
	public double getCurrentX(long time)
	{
		return myStartX + Math.sin(Math.toRadians(myHeading)) * myVelocity * (time - myFireTime);
	}

	/* 
	 * getCurrentY: Returns y-coordinate of bullet at the given time
	 */
	public double getCurrentY(long time)
	{
		return myStartY + Math.cos(Math.toRadians(myHeading)) * myVelocity * (time - myFireTime);
	}
}